/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui.widget;

import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.gui.widget.AbstractAspectWidget;
import thaumicenergistics.gui.widget.AbstractWidget;
import thaumicenergistics.gui.widget.IAspectSelectorGui;
import thaumicenergistics.util.GuiHelper;

public class WidgetAspectSelector
extends AbstractAspectWidget {
    private static final int borderThickness = 1;
    private static final int GRADIENT_COUNT = 15;
    private static final int selectorBorderColor = -16711681;
    private int[] backgroundPulseGradient;
    private long amount = 0L;

    public WidgetAspectSelector(IAspectSelectorGui selectorGui, AspectStack stack, int xPos, int yPos, EntityPlayer player) {
        super(selectorGui, stack.aspect, xPos, yPos, player);
        this.amount = stack.stackSize;
        int aspectColor = stack.aspect.getColor();
        this.backgroundPulseGradient = GuiHelper.INSTANCE.createColorGradient(0x70000000 | aspectColor, 0x20000000 | aspectColor, 16);
    }

    private void drawHollowRectWithCorners(int posX, int posY, int width, int height, int color, int thickness) {
        int rightXEnd = posX + width;
        int rightXBegin = rightXEnd - thickness;
        int leftXEnd = posX + thickness;
        int topYEnd = posY + thickness;
        int bottomYEnd = posY + height;
        int bottomYBegin = bottomYEnd - thickness;
        Gui.func_73734_a((int)posX, (int)posY, (int)rightXEnd, (int)bottomYEnd, (int)color);
        Gui.func_73734_a((int)posX, (int)posY, (int)(leftXEnd + 1), (int)(topYEnd + 1), (int)-16711681);
        Gui.func_73734_a((int)rightXEnd, (int)posY, (int)(rightXBegin - 1), (int)(topYEnd + 1), (int)-16711681);
        Gui.func_73734_a((int)rightXEnd, (int)bottomYEnd, (int)(rightXBegin - 1), (int)(bottomYBegin - 1), (int)-16711681);
        Gui.func_73734_a((int)posX, (int)bottomYEnd, (int)(leftXEnd + 1), (int)(bottomYBegin - 1), (int)-16711681);
        Gui.func_73734_a((int)posX, (int)posY, (int)rightXEnd, (int)topYEnd, (int)-16711681);
        Gui.func_73734_a((int)posX, (int)bottomYBegin, (int)rightXEnd, (int)bottomYEnd, (int)-16711681);
        Gui.func_73734_a((int)posX, (int)posY, (int)leftXEnd, (int)bottomYEnd, (int)-16711681);
        Gui.func_73734_a((int)rightXBegin, (int)posY, (int)rightXEnd, (int)bottomYEnd, (int)-16711681);
    }

    private int getBackgroundColor() {
        int time = (int)(System.currentTimeMillis() / 45L);
        int index = Math.abs(Math.abs(time % 30) - 15);
        return this.backgroundPulseGradient[index];
    }

    @Override
    public void drawWidget() {
        if (this.getAspect() == null) {
            return;
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        AspectStack selectedStack = ((IAspectSelectorGui)this.hostGUI).getSelectedAspect();
        if (selectedStack != null && selectedStack.aspect == this.getAspect()) {
            this.drawHollowRectWithCorners(this.xPosition, this.yPosition, AbstractWidget.WIDGET_SIZE, AbstractWidget.WIDGET_SIZE, this.getBackgroundColor(), 1);
        }
        this.drawAspect();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public long getAmount() {
        return this.amount;
    }

    public AspectStack getAspectStackRepresentation() {
        return new AspectStack(this.getAspect(), this.amount);
    }

    @Override
    public void getTooltip(List<String> tooltip) {
        if (this.getAspect() != null && this.amount > 0L) {
            tooltip.add(this.aspectName);
            tooltip.add(Long.toString(this.amount));
        }
    }

    @Override
    public void mouseClicked() {
        if (this.getAspect() != null) {
            ((IAspectSelectorGui)this.hostGUI).getContainer().setSelectedAspect(this.getAspect());
        }
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }
}

