/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui.abstraction;

import appeng.api.AEApi;
import appeng.parts.automation.UpgradeInventory;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import thaumicenergistics.container.ContainerWithNetworkTool;
import thaumicenergistics.container.slot.SlotNetworkTool;
import thaumicenergistics.gui.buttons.AbstractGuiButtonBase;
import thaumicenergistics.gui.widget.IWidgetHost;
import thaumicenergistics.texture.AEStateIconsEnum;
import thaumicenergistics.util.GuiHelper;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractGuiBase
extends GuiContainer
implements IWidgetHost {
    private static final int TOOLTIP_OFFSET = 12;
    private static final int TOOLTIP_EMPTY_HEIGHT = 8;
    private static final int TOOLTIP_HEIGHT_MARGIN = 2;
    private static final int TOOLTIP_LINE_HEIGHT = 10;
    private static final int TOOLTIP_COLOR_OUTER = -16777216;
    private static final int TOOLTIP_COLOR_BACKGROUND = -267386864;
    private static final int TOOLTIP_COLOR_INNER_BEGIN = -1068498689;
    private static final int TOOLTIP_COLOR_INNER_END = -1068498689;
    private static final int TOOLTIP_BORDER_SIZE = 3;
    private static final int upgradeU = AEStateIconsEnum.UPGRADE_CARD_BACKGROUND.getU();
    private static final int upgradeV = AEStateIconsEnum.UPGRADE_CARD_BACKGROUND.getV();
    private static final int upgradeWidth = AEStateIconsEnum.UPGRADE_CARD_BACKGROUND.getWidth();
    private static final int upgradeHeight = AEStateIconsEnum.UPGRADE_CARD_BACKGROUND.getHeight();
    protected final List<String> tooltip = new ArrayList<String>();

    public AbstractGuiBase(Container container) {
        super(container);
    }

    private final void drawTooltipBackground(Bounds bounds) {
        this.func_73733_a(bounds.L, bounds.T, bounds.R, bounds.B, -267386864, -267386864);
        this.drawTooltipBorders(bounds, -16777216, -16777216, 0);
        ++bounds.T;
        ++bounds.L;
        --bounds.B;
        --bounds.R;
        this.drawTooltipBorders(bounds, -1068498689, -1068498689, 1);
    }

    private final void drawTooltipBorders(Bounds bounds, int colorStart, int colorEnd, int cornerExpansion) {
        this.func_73733_a(bounds.L - 1, bounds.T - cornerExpansion, bounds.L, bounds.B + cornerExpansion, colorStart, colorEnd);
        this.func_73733_a(bounds.L, bounds.T - 1, bounds.R, bounds.T, colorStart, colorEnd);
        this.func_73733_a(bounds.R, bounds.T - cornerExpansion, bounds.R + 1, bounds.B + cornerExpansion, colorStart, colorEnd);
        this.func_73733_a(bounds.L, bounds.B, bounds.R, bounds.B + 1, colorStart, colorEnd);
    }

    private final boolean isPointWithinSlot(Slot slot, int x, int y) {
        return GuiHelper.INSTANCE.isPointInGuiRegion(slot.field_75221_f, slot.field_75223_e, 16, 16, x, y, this.field_147003_i, this.field_147009_r);
    }

    private final boolean nonLeftClickHandler_Buttons(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0) {
            for (Object buttonObj : this.field_146292_n) {
                GuiButton button = (GuiButton)buttonObj;
                if (!button.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                button.func_146113_a(this.field_146297_k.func_147118_V());
                this.onButtonClicked(button, mouseButton);
                return true;
            }
        }
        return false;
    }

    protected final boolean addTooltipFromButtons(int mouseX, int mouseY) {
        for (Object obj : this.field_146292_n) {
            AbstractGuiButtonBase currentButton;
            if (!(obj instanceof AbstractGuiButtonBase) || !(currentButton = (AbstractGuiButtonBase)((Object)obj)).isMouseOverButton(mouseX, mouseY)) continue;
            currentButton.getTooltip(this.tooltip);
            return true;
        }
        return false;
    }

    protected final void drawAEToolAndUpgradeSlots(float alpha, int mouseX, int mouseY) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AEStateIconsEnum.AE_STATES_TEXTURE);
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (!(slot instanceof SlotNetworkTool) && !(slot.field_75224_c instanceof UpgradeInventory)) continue;
            this.func_73729_b(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, upgradeU, upgradeV, upgradeWidth, upgradeHeight);
        }
    }

    protected final void drawTooltip(int posX, int posY, boolean clearTooltipAfterDraw) {
        if (!this.tooltip.isEmpty()) {
            GL11.glDisable((int)32826);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            if (posY < 0) {
                posY = 0;
            }
            int maxStringLength_px = 0;
            for (String string : this.tooltip) {
                int stringLen = this.field_146297_k.field_71466_p.func_78256_a(string);
                if (stringLen <= maxStringLength_px) continue;
                maxStringLength_px = stringLen;
            }
            posX += 12;
            posY -= 12;
            int tooltipHeight = 8;
            if (this.tooltip.size() > 1) {
                int lineHeight = (this.tooltip.size() - 1) * 10;
                tooltipHeight += 2 + lineHeight;
            }
            float prevZlevel = this.field_73735_i;
            this.field_73735_i = 300.0f;
            Bounds bounds = new Bounds(posY - 3, posX - 3, posY + tooltipHeight + 3, posX + maxStringLength_px + 3);
            this.drawTooltipBackground(bounds);
            for (int index = 0; index < this.tooltip.size(); ++index) {
                String line = this.tooltip.get(index);
                this.field_146297_k.field_71466_p.func_78261_a(line, posX, posY, -1);
                if (index == 0) {
                    posY += 2;
                }
                posY += 10;
            }
            this.field_73735_i = prevZlevel;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
            if (clearTooltipAfterDraw) {
                this.tooltip.clear();
            }
        }
    }

    protected final Slot func_146975_c(int x, int y) {
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (!this.isPointWithinSlot(slot, x, y)) continue;
            return slot;
        }
        return null;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        Slot slot;
        if (this.nonLeftClickHandler_Buttons(mouseX, mouseY, mouseButton)) {
            return;
        }
        if (this.field_147002_h instanceof ContainerWithNetworkTool && ((ContainerWithNetworkTool)this.field_147002_h).hasNetworkTool() && (slot = this.func_146975_c(mouseX, mouseY)) != null && slot.func_75211_c() != null && slot.func_75211_c().func_77969_a((ItemStack)AEApi.instance().definitions().items().networkTool().maybeStack(1).get())) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void onButtonClicked(GuiButton button, int mouseButton) {
    }

    public final void func_146284_a(GuiButton button) {
        this.onButtonClicked(button, 0);
    }

    @Override
    public final int guiLeft() {
        return this.field_147003_i;
    }

    @Override
    public final int guiTop() {
        return this.field_147009_r;
    }

    private class Bounds {
        public int T;
        public int L;
        public int B;
        public int R;

        public Bounds(int t, int l, int b, int r) {
            this.T = t;
            this.L = l;
            this.B = b;
            this.R = r;
        }
    }
}

