/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.container.ContainerEssentiaVibrationChamber;
import thaumicenergistics.gui.abstraction.AbstractGuiBase;
import thaumicenergistics.texture.GuiTextureManager;
import thaumicenergistics.util.GuiHelper;

@SideOnly(value=Side.CLIENT)
public class GuiEssentiaVibrationChamber
extends AbstractGuiBase {
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 82;
    private static final int POWER_POS_X = 96;
    private static final int POWER_POS_Y = 32;
    private static final int POWER_TEX_X = 51;
    private static final int POWER_TEX_Y = 83;
    private static final int POWER_WIDTH = 6;
    private static final int POWER_HEIGHT = 18;
    private static final int STORED_POS_X = 62;
    private static final int STORED_POS_Y = 16;
    private static final int STORED_TEX_X = 200;
    private static final int STORED_WIDTH = 8;
    private static final int STORED_HEIGHT = 48;
    private static final int VIAL_POS_X = 61;
    private static final int VIAL_POS_Y = 12;
    private static final int VIAL_TEX_X = 232;
    private static final int VIAL_WIDTH = 11;
    private static final int VIAL_HEIGHT = 56;
    private static final int FIRE_POS_X = 78;
    private static final int FIRE_POS_Y = 30;
    private static final int FIRE_TEX_X = 177;
    private static final int FIRE_WIDTH = 15;
    private static final int FIRE_HEIGHT = 20;
    private static final ResourceLocation alchemyFurnaceTexture = new ResourceLocation("thaumcraft", "textures/gui/gui_alchemyfurnace.png");
    private final ContainerEssentiaVibrationChamber container;

    public GuiEssentiaVibrationChamber(EntityPlayer player, World world, int x, int y, int z) {
        super(new ContainerEssentiaVibrationChamber(player, world, x, y, z));
        this.container = (ContainerEssentiaVibrationChamber)this.field_147002_h;
        this.field_146999_f = 176;
        this.field_147000_g = 82;
    }

    private void drawTC_Textures() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(alchemyFurnaceTexture);
        int storedHeightOffset = (int)(48.0f * this.container.getStoredEssentiaPercent());
        this.func_73729_b(this.field_147003_i + 62, this.field_147009_r + 16 + storedHeightOffset, 200, storedHeightOffset, 8, 48 - storedHeightOffset);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_73729_b(this.field_147003_i + 61, this.field_147009_r + 12, 232, 0, 11, 56);
        int progressHeightOffset = (int)(20.0f * this.container.getTicksRemainingPercent());
        this.func_73729_b(this.field_147003_i + 78, this.field_147009_r + 30 + progressHeightOffset, 177, progressHeightOffset, 15, 20 - progressHeightOffset);
        GL11.glDisable((int)3042);
    }

    private void drawThE_Textures() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.ESSENTIA_VIBRATION_CHAMBER.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int powerBarHeightOffset = (int)(18.0f * this.container.getPowerPercent());
        this.func_73729_b(this.field_147003_i + 96, this.field_147009_r + 32 + powerBarHeightOffset, 51, 83 + powerBarHeightOffset, 6, 18 - powerBarHeightOffset);
    }

    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawThE_Textures();
        this.drawTC_Textures();
    }

    public void func_146979_b(int mouseX, int mouseY) {
        if (GuiHelper.INSTANCE.isPointInGuiRegion(12, 61, 56, 11, mouseX, mouseY, this.field_147003_i, this.field_147009_r)) {
            Aspect storedAspect = this.container.getStoredEssentiaAspect();
            int storedAmount = this.container.getStoredEssentiaAmount();
            if (storedAmount > 0 && storedAspect != null) {
                this.tooltip.add(String.format("%s x %d", storedAspect.getName(), storedAmount));
            } else {
                this.tooltip.add("Empty");
            }
        } else if (GuiHelper.INSTANCE.isPointInGuiRegion(30, 78, 20, 15, mouseX, mouseY, this.field_147003_i, this.field_147009_r)) {
            Aspect processingAspect = this.container.getProcessingAspect();
            if (processingAspect != null) {
                float secondsRemaining = (float)this.container.getTicksRemaining() / 20.0f;
                this.tooltip.add(String.format("Processing: %s", processingAspect.getName()));
                this.tooltip.add(String.format("Time Remaining: %.0fs", Float.valueOf(secondsRemaining)));
            }
        } else if (GuiHelper.INSTANCE.isPointInGuiRegion(32, 96, 18, 6, mouseX, mouseY, this.field_147003_i, this.field_147009_r)) {
            this.tooltip.add(String.format("%.0f AE/t", Float.valueOf(this.container.getPowerPerTick())));
        }
        this.drawTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r, true);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }
}

