/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.grid;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.grid.GridEssentiaCache;
import thaumicenergistics.grid.IEssentiaWatcher;
import thaumicenergistics.grid.IEssentiaWatcherHost;

public class EssentiaWatcher
implements IEssentiaWatcher {
    private final HashSet<Aspect> trackedAspects;
    private final GridEssentiaCache.WatcherManager manager;
    private final WeakReference<IEssentiaWatcherHost> host;

    public EssentiaWatcher(GridEssentiaCache.WatcherManager manager, IEssentiaWatcherHost host) {
        this.manager = manager;
        this.trackedAspects = new HashSet();
        this.host = new WeakReference<IEssentiaWatcherHost>(host);
    }

    @Override
    public boolean add(Aspect aspect) {
        boolean changed = this.trackedAspects.add(aspect);
        if (changed) {
            this.manager.onWatcherAddAspect(this, aspect);
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends Aspect> c) {
        boolean changed = false;
        for (Aspect aspect : c) {
            changed |= this.add(aspect);
        }
        return changed;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.manager.onWatcherCleared(this, this.trackedAspects);
            this.trackedAspects.clear();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.trackedAspects.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.trackedAspects.containsAll(c);
    }

    @Override
    public IEssentiaWatcherHost getHost() {
        return (IEssentiaWatcherHost)this.host.get();
    }

    @Override
    public boolean isEmpty() {
        return this.trackedAspects.isEmpty();
    }

    @Override
    public Iterator<Aspect> iterator() {
        return this.trackedAspects.iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Aspect) {
            boolean changed = this.trackedAspects.remove(o);
            if (changed) {
                this.manager.onWatcherRemoveAspect(this, (Aspect)o);
            }
            return changed;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object aspect : c) {
            changed |= this.remove(aspect);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.trackedAspects.size();
    }

    @Override
    public Object[] toArray() {
        return this.trackedAspects.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.trackedAspects.toArray(a);
    }
}

