/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.grid;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.fluids.GaseousEssentia;
import thaumicenergistics.grid.IMEEssentiaMonitor;
import thaumicenergistics.grid.IMEEssentiaMonitorReceiver;
import thaumicenergistics.integration.tc.EssentiaConversionHelper;

public class EssentiaMonitor
implements IMEEssentiaMonitor,
IMEMonitorHandlerReceiver<IAEFluidStack> {
    public static final double AE_PER_ESSENTIA = 0.3;
    private final Map<Aspect, AspectStack> cache = new ConcurrentHashMap<Aspect, AspectStack>();
    protected final HashMap<IMEEssentiaMonitorReceiver, Object> listeners = new HashMap();
    protected IMEMonitor<IAEFluidStack> fluidMonitor;
    protected IEnergyGrid energyGrid;
    private Collection<AspectStack> cacheView;
    private WeakReference<Object> token;
    protected boolean cacheNeedsUpdate = false;

    public EssentiaMonitor() {
    }

    public EssentiaMonitor(IMEMonitor<IAEFluidStack> fluidMonitor, IEnergyGrid energyGrid, Object validationToken) {
        this();
        this.wrap(fluidMonitor, energyGrid, validationToken);
    }

    private long changeAspectAmount(Aspect aspect, long diff) {
        if (aspect == null) {
            return 0L;
        }
        AspectStack prevStack = this.cache.get(aspect);
        if (prevStack == null) {
            if (diff > 0L) {
                this.cache.put(aspect, new AspectStack(aspect, diff));
                return diff;
            }
            return 0L;
        }
        long prevAmount = prevStack.stackSize;
        long newAmount = Math.max(0L, prevAmount + diff);
        if (newAmount > 0L) {
            prevStack.stackSize = newAmount;
        } else {
            this.cache.remove(aspect);
        }
        return newAmount - prevAmount;
    }

    private long injectEssentiaSafely(Aspect aspect, long amount, Actionable mode, BaseActionSource source, GaseousEssentia essentiaGas) {
        IAEFluidStack fluidRequest = EssentiaConversionHelper.INSTANCE.createAEFluidStackInEssentiaUnits(essentiaGas, amount);
        IAEFluidStack fluidRejected = (IAEFluidStack)this.fluidMonitor.injectItems((IAEStack)fluidRequest, mode, source);
        if (fluidRejected != null && fluidRejected.getStackSize() > 0L) {
            if (fluidRejected.getStackSize() == fluidRequest.getStackSize()) {
                return amount;
            }
            long rejectedAdjustedAmount = EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(fluidRejected.getStackSize());
            return rejectedAdjustedAmount;
        }
        return 0L;
    }

    private void notifyListeners(List<AspectStack> changes) {
        ImmutableList changeList = ImmutableList.copyOf(changes);
        Iterator<Map.Entry<IMEEssentiaMonitorReceiver, Object>> entryIterator = this.listeners.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<IMEEssentiaMonitorReceiver, Object> entry = entryIterator.next();
            if (entry.getKey().isValid(entry.getValue())) {
                entry.getKey().postChange(this, (Iterable<AspectStack>)changeList);
                continue;
            }
            entryIterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCacheToMatchNetwork() {
        Map<Aspect, AspectStack> map = this.cache;
        synchronized (map) {
            boolean hasListeners;
            IItemList fluidStackList = this.fluidMonitor.getStorageList();
            if (fluidStackList == null) {
                return;
            }
            ArrayList<AspectStack> aspectChanges = null;
            HashSet<Aspect> previousAspects = null;
            boolean bl = hasListeners = this.listeners.size() > 0;
            if (hasListeners) {
                aspectChanges = new ArrayList<AspectStack>();
                previousAspects = new HashSet<Aspect>();
                previousAspects.addAll(this.cache.keySet());
            } else {
                this.cache.clear();
            }
            for (IAEFluidStack fluidStack : fluidStackList) {
                if (!(fluidStack.getFluid() instanceof GaseousEssentia)) continue;
                Aspect aspect = ((GaseousEssentia)fluidStack.getFluid()).getAspect();
                Long newAmount = EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(fluidStack.getStackSize());
                AspectStack prevStack = this.cache.put(aspect, new AspectStack(aspect, newAmount));
                if (!hasListeners) continue;
                previousAspects.remove(aspect);
                long diff = newAmount - (prevStack != null ? prevStack.stackSize : 0L);
                if (diff == 0L) continue;
                aspectChanges.add(new AspectStack(aspect, diff));
            }
            if (hasListeners) {
                for (Aspect aspect : previousAspects) {
                    aspectChanges.add(new AspectStack(aspect, -this.cache.remove((Object)aspect).stackSize));
                }
                this.notifyListeners(aspectChanges);
            }
            this.cacheNeedsUpdate = false;
        }
    }

    @Override
    public void addListener(IMEEssentiaMonitorReceiver listener, Object verificationToken) {
        if (this.listeners.size() == 0 && this.cacheNeedsUpdate) {
            this.updateCacheToMatchNetwork();
        }
        this.listeners.put(listener, verificationToken);
    }

    public void detach() {
        if (this.fluidMonitor != null) {
            this.fluidMonitor.removeListener((IMEMonitorHandlerReceiver)this);
            this.token = null;
        }
    }

    @Override
    public long extractEssentia(Aspect aspect, long amount, Actionable mode, BaseActionSource source, boolean powered) {
        double powerRequest;
        double powerReceived;
        if (aspect == null || amount <= 0L) {
            return 0L;
        }
        GaseousEssentia essentiaGas = GaseousEssentia.getGasFromAspect(aspect);
        if (essentiaGas == null) {
            return 0L;
        }
        if (powered && (powerReceived = this.energyGrid.extractAEPower(powerRequest = 0.3 * (double)amount, Actionable.SIMULATE, PowerMultiplier.CONFIG)) < powerRequest) {
            return 0L;
        }
        IAEFluidStack fluidRequest = EssentiaConversionHelper.INSTANCE.createAEFluidStackInEssentiaUnits(essentiaGas, amount);
        IAEFluidStack fluidReceived = (IAEFluidStack)this.fluidMonitor.extractItems((IAEStack)fluidRequest, mode, source);
        if (fluidReceived == null || fluidReceived.getStackSize() <= 0L) {
            return 0L;
        }
        long extractedAmount = EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(fluidReceived.getStackSize());
        if (powered && mode == Actionable.MODULATE) {
            this.energyGrid.extractAEPower(0.3 * (double)extractedAmount, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
        return extractedAmount;
    }

    @Override
    public long getEssentiaAmount(Aspect aspect) {
        if (!this.energyGrid.isNetworkPowered()) {
            return 0L;
        }
        if (this.cacheNeedsUpdate) {
            this.updateCacheToMatchNetwork();
        }
        if (this.cache.containsKey(aspect)) {
            return this.cache.get((Object)aspect).stackSize;
        }
        return 0L;
    }

    @Override
    public Collection<AspectStack> getEssentiaList() {
        if (!this.energyGrid.isNetworkPowered()) {
            return new ArrayList<AspectStack>();
        }
        if (this.cacheNeedsUpdate) {
            this.updateCacheToMatchNetwork();
        }
        if (this.cacheView == null) {
            this.cacheView = Collections.unmodifiableCollection(this.cache.values());
        }
        return this.cacheView;
    }

    @Override
    public long injectEssentia(Aspect aspect, long amount, Actionable mode, BaseActionSource source, boolean powered) {
        double powerRequest;
        double powerReceived;
        if (aspect == null || amount <= 0L) {
            return amount;
        }
        GaseousEssentia essentiaGas = GaseousEssentia.getGasFromAspect(aspect);
        if (essentiaGas == null) {
            return amount;
        }
        long rejectedAmount = this.injectEssentiaSafely(aspect, amount, Actionable.SIMULATE, source, essentiaGas);
        long adjustedAmount = amount - rejectedAmount;
        if (powered && (powerReceived = this.energyGrid.extractAEPower(powerRequest = 0.3 * (double)adjustedAmount, Actionable.SIMULATE, PowerMultiplier.CONFIG)) < powerRequest) {
            return amount;
        }
        if (mode == Actionable.MODULATE) {
            rejectedAmount = this.injectEssentiaSafely(aspect, adjustedAmount, Actionable.MODULATE, source, essentiaGas);
            adjustedAmount -= rejectedAmount;
            if (powered) {
                powerRequest = 0.3 * (double)adjustedAmount;
                this.energyGrid.extractAEPower(powerRequest, Actionable.MODULATE, PowerMultiplier.CONFIG);
            }
        }
        return rejectedAmount;
    }

    public boolean isValid(Object verificationToken) {
        Object vToken;
        return this.token != null && this.token.equals(verificationToken) && (vToken = this.token.get()) != null;
    }

    public void onListUpdate() {
        this.cacheNeedsUpdate = true;
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> fluidChanges, BaseActionSource actionSource) {
        if (this.cacheNeedsUpdate) {
            return;
        }
        if (fluidChanges == null) {
            return;
        }
        boolean hasListeners = this.listeners.size() > 0;
        ArrayList<AspectStack> aspectChanges = null;
        for (IAEFluidStack change : fluidChanges) {
            if (!(change.getFluid() instanceof GaseousEssentia)) continue;
            Aspect aspect = ((GaseousEssentia)change.getFluid()).getAspect();
            long diff = EssentiaConversionHelper.INSTANCE.convertFluidAmountToEssentiaAmount(change.getStackSize());
            diff = this.changeAspectAmount(aspect, diff);
            if (!hasListeners) continue;
            if (aspectChanges == null) {
                aspectChanges = new ArrayList<AspectStack>();
            }
            aspectChanges.add(new AspectStack(aspect, diff));
        }
        if (aspectChanges != null && aspectChanges.size() > 0) {
            this.notifyListeners((List<AspectStack>)aspectChanges);
        }
    }

    @Override
    public void removeListener(IMEEssentiaMonitorReceiver listener) {
        this.listeners.remove(listener);
    }

    public void wrap(IMEMonitor<IAEFluidStack> fluidMonitor, IEnergyGrid energyGrid, Object validationToken) {
        if (validationToken == null) {
            throw new NullPointerException("Validation Token Can Not Be Null");
        }
        this.token = new WeakReference<Object>(validationToken);
        this.fluidMonitor = fluidMonitor;
        this.energyGrid = energyGrid;
        this.fluidMonitor.addListener((IMEMonitorHandlerReceiver)this, this.token);
        this.cacheNeedsUpdate = true;
    }
}

