/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.features;

import java.util.EnumSet;
import thaumicenergistics.registries.ResearchRegistry;

public abstract class AbstractBasicFeature {
    private boolean available = false;
    private boolean hasRegistered = false;

    public AbstractBasicFeature(boolean initiallyAvailable) {
        this.setAvailable(initiallyAvailable);
    }

    protected void registerCrafting() {
    }

    protected void registerResearch() {
    }

    protected void setAvailable(boolean available) {
        this.available = available;
    }

    public String getFirstValidParentKey(boolean includeSelf) {
        return "";
    }

    public EnumSet<ResearchRegistry.PseudoResearchTypes> getPseudoParentTypes() {
        return EnumSet.noneOf(ResearchRegistry.PseudoResearchTypes.class);
    }

    public boolean isAvailable() {
        return this.available;
    }

    public final void registerFeature() {
        if (this.isAvailable() && !this.hasRegistered) {
            this.registerCrafting();
            this.registerResearch();
            this.hasRegistered = true;
        }
    }
}

