/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.aspect;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.Thaumcraft;
import thaumicenergistics.network.packet.AbstractPacket;
import thaumicenergistics.util.GuiHelper;

public class AspectStack {
    public Aspect aspect;
    public long stackSize;

    public AspectStack() {
        this.aspect = null;
        this.stackSize = 0L;
    }

    public AspectStack(Aspect aspect, long amount) {
        this.aspect = aspect;
        this.stackSize = amount;
    }

    public AspectStack(AspectStack source) {
        this.aspect = source.aspect;
        this.stackSize = source.stackSize;
    }

    public static AspectStack loadAspectStackFromNBT(NBTTagCompound nbt) {
        Aspect aspect = (Aspect)Aspect.aspects.get(nbt.func_74779_i("AspectTag"));
        if (aspect == null) {
            return null;
        }
        long amount = nbt.func_74763_f("Amount");
        return new AspectStack(aspect, amount);
    }

    public static AspectStack loadAspectStackFromStream(ByteBuf stream) {
        AspectStack stack = new AspectStack();
        stack.readFromStream(stream);
        return stack;
    }

    public AspectStack copy() {
        return new AspectStack(this);
    }

    public String getAspectName() {
        if (this.aspect == null) {
            return "";
        }
        return this.aspect.getName();
    }

    public String getAspectName(EntityPlayer player) {
        if (!this.hasPlayerDiscovered(player)) {
            return StatCollector.func_74838_a((String)"tc.aspect.unknown");
        }
        return this.getAspectName();
    }

    public String getChatColor() {
        if (this.aspect != null) {
            return GuiHelper.INSTANCE.getAspectChatColor(this.aspect);
        }
        return "";
    }

    public String getTag() {
        if (this.aspect != null) {
            return this.aspect.getTag();
        }
        return "";
    }

    public boolean hasPlayerDiscovered(EntityPlayer player) {
        boolean hasDiscovered = false;
        if (player != null && this.aspect != null) {
            hasDiscovered = Thaumcraft.proxy.getPlayerKnowledge().hasDiscoveredAspect(player.func_70005_c_(), this.aspect);
        }
        return hasDiscovered;
    }

    public boolean isEmpty() {
        return this.stackSize <= 0L;
    }

    public void readFromStream(ByteBuf stream) {
        this.aspect = AbstractPacket.readAspect(stream);
        this.stackSize = stream.readLong();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.aspect != null) {
            nbt.func_74778_a("AspectTag", this.aspect.getTag());
            nbt.func_74772_a("Amount", this.stackSize);
        }
        return nbt;
    }

    public void writeToStream(ByteBuf stream) {
        AbstractPacket.writeAspect(this.aspect, stream);
        stream.writeLong(this.stackSize);
    }
}

