/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.TeamStats;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenu;
import hardcorequesting.client.interfaces.GuiEditMenuTeam;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.RenderRotation;
import net.minecraft.entity.player.EntityPlayer;

public class GuiEditMenuTeamList
extends GuiEditMenu {
    private GuiEditMenuTeam parent;
    private static final int TEAM_X = 20;
    private static final int TEAM_X_2ND_PAGE = 180;
    private static final int TEAM_Y = 20;
    private static final int TEAM_OFFSET = 50;
    private static final int TEAM_LINE_OFFSET = 10;
    private static final int TEAM_LINE_INDENT = 5;
    private static final int TEAMS_PER_PAGE = 4;
    private static final int TEAMS_PER_PAIR = 8;
    private int pagePair = 0;
    private static final int ARROW_X_LEFT = 30;
    private static final int ARROW_X_RIGHT = 288;
    private static final int ARROW_Y = 212;
    private static final int ARROW_SRC_X = 181;
    private static final int ARROW_SRC_Y = 69;
    private static final int ARROW_W = 20;
    private static final int ARROW_H = 9;

    protected GuiEditMenuTeamList(GuiQuestBook gui, EntityPlayer player, GuiEditMenuTeam parent) {
        super(gui, player);
        this.parent = parent;
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        this.drawArrow(gui, mX, mY, true);
        this.drawArrow(gui, mX, mY, false);
        TeamStats[] teamStats = TeamStats.getTeamStats();
        int start = this.pagePair * 8;
        int end = Math.min(start + 8, teamStats.length);
        for (int i = start; i < end; ++i) {
            TeamStats teamStat = teamStats[i];
            int x = i - start < 4 ? 20 : 180;
            int y = 20 + (i - start) % 4 * 50;
            gui.drawString(teamStat.getName(), x, y, 0x404040);
            gui.drawString(teamStat.getProgress() + "% done", x + 5, y + 10, 0.7f, 0x404040);
            gui.drawString("Players: " + teamStat.getPlayers(), x + 5, y + 20, 0.7f, 0x404040);
            gui.drawString("Lives: " + teamStat.getLives(), x + 5, y + 30, 0.7f, 0x404040);
        }
        gui.drawCenteredString("Page " + (this.pagePair * 2 + 1), 0, 202, 0.7f, 170, 30, 0x707070);
        if (end - start > 4) {
            gui.drawCenteredString("Page " + (this.pagePair * 2 + 2), 170, 202, 0.7f, 170, 30, 0x707070);
        }
    }

    private void drawArrow(GuiBase gui, int mX, int mY, boolean left) {
        int x = left ? 30 : 288;
        int srcY = 0;
        if (this.isArrowEnabled(left)) {
            srcY = gui.inBounds(x, 212, 20, 9, mX, mY) ? 2 : 1;
        }
        gui.drawRect(x, 212, 181, 69 + srcY * 20, 9, 20, left ? RenderRotation.ROTATE_90 : RenderRotation.ROTATE_270);
    }

    private boolean isArrowEnabled(boolean left) {
        return left && this.pagePair > 0 || !left && (double)this.pagePair < Math.ceil((float)TeamStats.getTeamStats().length / 8.0f) - 1.0;
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        if (this.isArrowEnabled(true) && gui.inBounds(30, 212, 20, 9, mX, mY)) {
            --this.pagePair;
        } else if (this.isArrowEnabled(false) && gui.inBounds(288, 212, 20, 9, mX, mY)) {
            ++this.pagePair;
        }
    }

    @Override
    protected void save(GuiBase gui) {
    }

    @Override
    protected void close(GuiBase gui) {
        gui.setEditMenu(this.parent);
    }
}

