/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.SaveHelper;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenuExtended;
import hardcorequesting.quests.Quest;
import net.minecraft.entity.player.EntityPlayer;

public class GuiEditMenuParentCount
extends GuiEditMenuExtended {
    private boolean useModifiedParentRequirement;
    private int parentRequirementCount;
    private int id;

    public GuiEditMenuParentCount(GuiBase gui, EntityPlayer player, Quest quest) {
        super(gui, player, true, 25, 20, 25, 105);
        this.id = quest.getId();
        this.useModifiedParentRequirement = quest.getUseModifiedParentRequirement();
        this.parentRequirementCount = this.useModifiedParentRequirement ? quest.getParentRequirementCount() : quest.getRequirement().size();
        this.textBoxes.add(new GuiEditMenuExtended.TextBoxNumber(gui, 0, "Parent count"){

            @Override
            protected void setValue(int number) {
                GuiEditMenuParentCount.this.parentRequirementCount = number;
            }

            @Override
            protected int getValue() {
                return GuiEditMenuParentCount.this.parentRequirementCount;
            }

            @Override
            protected boolean isVisible() {
                return GuiEditMenuParentCount.this.useModifiedParentRequirement;
            }
        });
    }

    @Override
    protected void onArrowClick(boolean left) {
        this.useModifiedParentRequirement = !this.useModifiedParentRequirement;
    }

    @Override
    protected String getArrowText() {
        return this.useModifiedParentRequirement ? "Requires specified amount" : "Requires all";
    }

    @Override
    protected String getArrowDescription() {
        return this.useModifiedParentRequirement ? "For this quest to unlock the player will have to complete a certain amount of parent quests. The required amount can be specified below." : "All parent quests have to be completed before this quest unlocks.";
    }

    @Override
    protected void save(GuiBase gui) {
        Quest quest = Quest.getQuest(this.id);
        if (quest != null) {
            quest.setUseModifiedParentRequirement(this.useModifiedParentRequirement);
            quest.setParentRequirementCount(this.parentRequirementCount);
            SaveHelper.add(SaveHelper.EditType.PARENT_REQUIREMENT_CHANGED);
        }
    }
}

