/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import hardcorequesting.QuestingData;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;

public enum DeathType {
    LAVA("Lava"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("lava");
        }
    }
    ,
    FIRE("Fire"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76347_k();
        }
    }
    ,
    SUFFOCATION("Suffocation"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("inWall");
        }
    }
    ,
    THORNS("Thorns"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("thorns") || source.func_76355_l().equals("cactus");
        }
    }
    ,
    DROWNING("Drowning"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("drown");
        }
    }
    ,
    STARVATION("Starvation"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("starve");
        }
    }
    ,
    FALL("Fall"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("fall");
        }
    }
    ,
    VOID("Void"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("outOfWorld");
        }
    }
    ,
    CRUSHED("Crushed"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("anvil") || source.func_76355_l().equals("fallingBlock");
        }
    }
    ,
    EXPLOSION("Explosions"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_94541_c();
        }
    }
    ,
    MONSTER("Monsters"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("mob") || source.func_76346_g() instanceof EntityLiving;
        }
    }
    ,
    PLAYER("Other players"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_76355_l().equals("player") || source.func_76346_g() instanceof EntityPlayer;
        }
    }
    ,
    MAGIC("Magic"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.func_82725_o();
        }
    }
    ,
    HQM("Rotten Hearts"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return false;
        }
    }
    ,
    OTHER("Other / Unknown"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return true;
        }
    };

    private String name;

    private DeathType(String name) {
        this.name = name;
    }

    public void onDeath(EntityPlayer player) {
        QuestingData.getQuestingData(player).getDeathStat().increaseDeath(this.ordinal());
    }

    public static void onDeath(EntityPlayer player, DamageSource source) {
        if (source != null && source.func_76355_l() != null) {
            for (DeathType deathType : DeathType.values()) {
                if (!deathType.isSourceValid(source)) continue;
                deathType.onDeath(player);
                break;
            }
        } else {
            OTHER.onDeath(player);
        }
    }

    abstract boolean isSourceValid(DamageSource var1);

    public String getName() {
        return this.name;
    }
}

