/*
 * Decompiled with CFR 0.152.
 */
package squeek.asmhelper;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class ObfHelper {
    private static Boolean obfuscated = null;
    private static HashMap<String, String> classNameToObfClassNameCache = new HashMap();
    private static HashMap<String, String> obfClassNameToClassNameCache = new HashMap();

    public static void setObfuscated(boolean obfuscated) {
        ObfHelper.obfuscated = obfuscated;
    }

    public static boolean isObfuscated() {
        if (obfuscated == null) {
            try {
                byte[] bytes = ((LaunchClassLoader)ObfHelper.class.getClassLoader()).getClassBytes("net.minecraft.world.World");
                ObfHelper.setObfuscated(bytes == null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return obfuscated;
    }

    private static void cacheObfClassMapping(String obfClassName, String className) {
        obfClassNameToClassNameCache.put(obfClassName, className);
        classNameToObfClassNameCache.put(className, obfClassName);
    }

    public static String toDeobfClassName(String obfClassName) {
        if (ObfHelper.isObfuscated()) {
            if (!obfClassNameToClassNameCache.containsKey(obfClassName)) {
                ObfHelper.cacheObfClassMapping(obfClassName, FMLDeobfuscatingRemapper.INSTANCE.map(obfClassName.replace('.', '/')).replace('/', '.'));
            }
            return obfClassNameToClassNameCache.get(obfClassName);
        }
        return obfClassName;
    }

    public static String toObfClassName(String deobfClassName) {
        if (ObfHelper.isObfuscated()) {
            if (!classNameToObfClassNameCache.containsKey(deobfClassName)) {
                ObfHelper.cacheObfClassMapping(FMLDeobfuscatingRemapper.INSTANCE.unmap(deobfClassName.replace('.', '/')).replace('/', '.'), deobfClassName);
            }
            return classNameToObfClassNameCache.get(deobfClassName);
        }
        return deobfClassName;
    }

    public static String getInternalClassName(String className) {
        return ObfHelper.toObfClassName(className).replace('.', '/');
    }

    public static String getDescriptor(String className) {
        return "L" + ObfHelper.getInternalClassName(className) + ";";
    }
}

