/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.AppleCore;
import squeek.applecore.asm.Hooks;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.ASMHelper;

public class ModuleDrawTooltip
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.client.gui.GuiScreen", "codechicken.lib.gui.GuiDraw", "tconstruct.client.gui.NewContainerGui"};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassNode classNode = ASMHelper.readClassFromBytes(bytes);
        if (transformedName.equals("net.minecraft.client.gui.GuiScreen")) {
            boolean isObfuscated = !name.equals(transformedName);
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "drawHoveringText", isObfuscated ? "(Ljava/util/List;IILbbu;)V" : "(Ljava/util/List;IILnet/minecraft/client/gui/FontRenderer;)V");
            if (methodNode == null) throw new RuntimeException("GuiScreen.drawHoveringText not found");
            this.addDrawHoveringTextHook(methodNode, Hooks.class, "onDrawHoveringText", "(IIII)V", isObfuscated);
            return ASMHelper.writeClassToBytes(classNode);
        } else if (name.equals("codechicken.lib.gui.GuiDraw")) {
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "drawTooltipBox", "(IIII)V");
            if (methodNode != null) {
                this.addCodeChickenDrawHoveringTextHook(methodNode, Hooks.class, "onDrawHoveringText", "(IIII)V");
                return ASMHelper.writeClassToBytes(classNode);
            } else {
                AppleCore.Log.error("drawTooltipBox method in codechicken.lib.gui.GuiDraw not found");
            }
            return ASMHelper.writeClassToBytes(classNode);
        } else {
            if (!name.equals("tconstruct.client.gui.NewContainerGui")) return ASMHelper.writeClassToBytes(classNode);
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_102021_a", "(Ljava/util/List;II)V");
            if (methodNode != null) {
                this.addTinkersDrawHoveringTextHook(methodNode, Hooks.class, "onDrawHoveringText", "(IIII)V", false);
                return ASMHelper.writeClassToBytes(classNode);
            } else {
                AppleCore.Log.error("func_102021_a method in tconstruct.client.gui.NewContainerGui not found");
            }
        }
        return ASMHelper.writeClassToBytes(classNode);
    }

    public void addDrawHoveringTextHook(MethodNode method, Class<?> hookClass, String hookMethod, String hookDesc, boolean isObfuscated) {
        AbstractInsnNode targetNode = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != 182) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)instruction;
            if (!methodInsn.desc.equals("(IIIIII)V")) continue;
            targetNode = instruction;
        }
        if (targetNode == null) {
            throw new RuntimeException("Unexpected instruction pattern encountered in " + method.name);
        }
        LocalVariableNode x = ASMHelper.findLocalVariableOfMethod(method, "j2", "I");
        LocalVariableNode y = ASMHelper.findLocalVariableOfMethod(method, "k2", "I");
        LocalVariableNode w = ASMHelper.findLocalVariableOfMethod(method, "k", "I");
        LocalVariableNode h = ASMHelper.findLocalVariableOfMethod(method, "i1", "I");
        if (x == null || y == null || w == null || h == null) {
            AppleCore.Log.warn("Could not patch " + method.name + "; local variables not found");
            return;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(21, x.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, y.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, w.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, h.index));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, hookClass.getName().replace('.', '/'), hookMethod, hookDesc));
        method.instructions.insert(targetNode, toInject);
    }

    public void addTinkersDrawHoveringTextHook(MethodNode method, Class<?> hookClass, String hookMethod, String hookDesc, boolean isObfuscated) {
        AbstractInsnNode targetNode = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != 182) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)instruction;
            if (!methodInsn.desc.equals("(IIIIII)V")) continue;
            targetNode = instruction;
        }
        if (targetNode == null) {
            AppleCore.Log.warn("Could not patch " + method.name + "; target node not found");
            return;
        }
        LocalVariableNode x = ASMHelper.findLocalVariableOfMethod(method, "i1", "I");
        LocalVariableNode y = ASMHelper.findLocalVariableOfMethod(method, "j1", "I");
        LocalVariableNode w = ASMHelper.findLocalVariableOfMethod(method, "k", "I");
        LocalVariableNode h = ASMHelper.findLocalVariableOfMethod(method, "k1", "I");
        if (x == null || y == null || w == null || h == null) {
            AppleCore.Log.warn("Could not patch " + method.name + "; local variables not found");
            return;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(21, x.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, y.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, w.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, h.index));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, hookClass.getName().replace('.', '/'), hookMethod, hookDesc));
        method.instructions.insert(targetNode, toInject);
    }

    public void addCodeChickenDrawHoveringTextHook(MethodNode method, Class<?> hookClass, String hookMethod, String hookDesc) {
        AbstractInsnNode targetNode = ASMHelper.findFirstInstruction(method);
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, hookClass.getName().replace('.', '/'), hookMethod, hookDesc));
        method.instructions.insertBefore(targetNode, toInject);
    }
}

