/*
 * Decompiled with CFR 0.152.
 */
package talonos.cavestokingdoms.extendedproperties;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PlayerOrbsGotten
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "CavesToKingdoms";
    private final EntityPlayer player;
    private int currentOrbs;

    public PlayerOrbsGotten(EntityPlayer player) {
        this.player = player;
        this.currentOrbs = 0;
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new PlayerOrbsGotten(player));
    }

    public static final PlayerOrbsGotten get(EntityPlayer player) {
        return (PlayerOrbsGotten)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a("CurrentOrbs", this.currentOrbs);
        compound.func_74782_a(EXT_PROP_NAME, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(EXT_PROP_NAME);
        this.currentOrbs = properties.func_74762_e("CurrentOrbs");
        System.out.println("[CTK PROPS] Mana from NBT: " + this.currentOrbs);
    }

    public void init(Entity entity, World world) {
    }

    public boolean consumeOrb() {
        if (this.currentOrbs >= 1) {
            --this.currentOrbs;
            return true;
        }
        return false;
    }

    public void giveOrb() {
        ++this.currentOrbs;
    }

    public boolean hasOrb() {
        return this.currentOrbs > 0;
    }
}

