/*
 * Decompiled with CFR 0.152.
 */
package talonos.blightbuster.tileentity.dawnmachine;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import talonos.blightbuster.BlightBuster;

public class DawnMachineChunkLoader
implements ForgeChunkManager.LoadingCallback {
    private List<ForgeChunkManager.Ticket> tickets = new ArrayList<ForgeChunkManager.Ticket>(12);

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            NBTTagCompound data = ticket.getModData();
            int x = data.func_74762_e("X");
            int z = data.func_74762_e("Z");
            boolean aerTicket = data.func_74767_n("Aer");
            boolean isActive = !aerTicket || data.func_74767_n("AerLoaded");
            this.loadChunks(ticket, world, x, z, aerTicket, isActive);
        }
    }

    public void newDawnMachine(World world, int x, int y, int z) {
        ForgeChunkManager.Ticket aerTicket;
        this.eliminateDawnMachine(world, x, y, z);
        ForgeChunkManager.Ticket normalTicket = ForgeChunkManager.requestTicket((Object)BlightBuster.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (normalTicket != null) {
            normalTicket.getModData().func_74768_a("X", x);
            normalTicket.getModData().func_74768_a("Y", y);
            normalTicket.getModData().func_74768_a("Z", z);
            normalTicket.getModData().func_74757_a("Aer", false);
            this.loadChunks(normalTicket, world, x, z, false, true);
        }
        if ((aerTicket = ForgeChunkManager.requestTicket((Object)BlightBuster.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
            aerTicket.getModData().func_74768_a("X", x);
            aerTicket.getModData().func_74768_a("Y", y);
            aerTicket.getModData().func_74768_a("Z", z);
            aerTicket.getModData().func_74757_a("Aer", true);
            aerTicket.getModData().func_74757_a("AerLoaded", false);
            this.loadChunks(aerTicket, world, x, z, true, false);
        }
    }

    public void eliminateDawnMachine(World world, int x, int y, int z) {
        for (int i = this.tickets.size() - 1; i >= 0; --i) {
            NBTTagCompound data;
            if (this.tickets.get((int)i).world != world || (data = this.tickets.get(i).getModData()).func_74762_e("X") != x || data.func_74762_e("Y") != y || data.func_74762_e("Z") != z) continue;
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.tickets.get(i));
            this.tickets.remove(i);
        }
    }

    public boolean getAerStatus(World world, int x, int y, int z) {
        for (int i = this.tickets.size() - 1; i >= 0; --i) {
            NBTTagCompound data;
            if (this.tickets.get((int)i).world != world || !(data = this.tickets.get(i).getModData()).func_74767_n("Aer") || data.func_74762_e("X") != x || data.func_74762_e("Y") != y || data.func_74762_e("Z") != z) continue;
            return data.func_74767_n("AerLoaded");
        }
        return false;
    }

    public void changeAerStatus(World world, int x, int y, int z, boolean active) {
        for (int i = this.tickets.size() - 1; i >= 0; --i) {
            NBTTagCompound data;
            if (this.tickets.get((int)i).world != world || !(data = this.tickets.get(i).getModData()).func_74767_n("Aer") || data.func_74762_e("X") != x || data.func_74762_e("Y") != y || data.func_74762_e("Z") != z) continue;
            data.func_74757_a("AerLoaded", active);
            ForgeChunkManager.Ticket ticket = this.tickets.get(i);
            if (active) {
                this.loadChunks(ticket, world, x, z, true, true);
                continue;
            }
            ImmutableSet list = ticket.getChunkList();
            for (ChunkCoordIntPair coords : list) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)coords);
            }
        }
    }

    protected void loadChunks(ForgeChunkManager.Ticket ticket, World world, int x, int z, boolean aerTicket, boolean isActive) {
        int chunkX = x / 16;
        int chunkZ = z / 16;
        int xInChunk = x % 16;
        int zInChunk = z % 16;
        int minChunkX = chunkX - 3;
        int minChunkZ = chunkZ - 3;
        if (xInChunk < 8) {
            --minChunkX;
        }
        if (zInChunk < 8) {
            --minChunkZ;
        }
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                boolean inCenter;
                boolean xInCenter = j >= 2 && j <= 5;
                boolean yInCenter = i >= 2 && i <= 5;
                boolean bl = inCenter = xInCenter && yInCenter;
                if (aerTicket == inCenter) continue;
                if (isActive) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(minChunkX + j, minChunkZ + i));
                    continue;
                }
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(minChunkX + j, minChunkZ + i));
            }
        }
        if (!this.tickets.contains(ticket)) {
            this.tickets.add(ticket);
        }
    }
}

