/*
 * Decompiled with CFR 0.152.
 */
package talonos.blightbuster.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import talonos.blightbuster.network.BlightbusterNetwork;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockFluxGoo;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.monster.EntityTaintChicken;
import thaumcraft.common.entities.monster.EntityTaintCow;
import thaumcraft.common.entities.monster.EntityTaintCreeper;
import thaumcraft.common.entities.monster.EntityTaintPig;
import thaumcraft.common.entities.monster.EntityTaintSheep;
import thaumcraft.common.entities.monster.EntityTaintVillager;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.tiles.TileNode;

public class ItemPurityFocus
extends ItemFocusBasic {
    private static final AspectList cost = new AspectList().add(Aspect.EARTH, 10).add(Aspect.ORDER, 15);
    private static final AspectList auraCost = new AspectList().add(Aspect.EARTH, 10000).add(Aspect.ORDER, 15000);

    public ItemPurityFocus() {
        this.func_77655_b("blightbuster_purityFocus");
        GameRegistry.registerItem((Item)this, (String)"purityFocus");
        this.func_77637_a(Thaumcraft.tabTC);
        this.func_111206_d("blightbuster:purityFocus");
    }

    public String getSortingHelper(ItemStack itemstack) {
        return "PU" + super.getSortingHelper(itemstack);
    }

    public boolean isVisCostPerTick() {
        return false;
    }

    public ItemStack onFocusRightClick(ItemStack itemstack, World world, EntityPlayer p, MovingObjectPosition mop) {
        int potency;
        ItemWandCasting wand = (ItemWandCasting)itemstack.func_77973_b();
        if (!wand.consumeAllVis(itemstack, p, this.getBigVisCost(potency = wand.getFocusEnlarge(itemstack) + 1), false, false)) {
            return itemstack;
        }
        Entity pointedEntity = EntityUtils.getPointedEntity((World)p.field_70170_p, (Entity)p, (double)0.0, (double)32.0, (float)32.0f);
        if (pointedEntity != null && !world.field_72995_K) {
            if (pointedEntity instanceof EntityTaintSheep) {
                EntityTaintSheep entityTaintSheep = (EntityTaintSheep)pointedEntity;
                EntitySheep entitysheep = new EntitySheep(entityTaintSheep.field_70170_p);
                this.convertFromTo((Entity)entityTaintSheep, (EntityLivingBase)entitysheep);
                wand.consumeAllVis(itemstack, p, this.getVisCost(itemstack), true, false);
            }
            if (pointedEntity instanceof EntityTaintCow) {
                EntityTaintCow entityTaintCow = (EntityTaintCow)pointedEntity;
                EntityCow entityCow = new EntityCow(entityTaintCow.field_70170_p);
                this.convertFromTo((Entity)entityTaintCow, (EntityLivingBase)entityCow);
                wand.consumeAllVis(itemstack, p, this.getVisCost(itemstack), true, false);
            }
            if (pointedEntity instanceof EntityTaintChicken) {
                EntityTaintChicken entityTaintChicken = (EntityTaintChicken)pointedEntity;
                EntityChicken chicken = new EntityChicken(entityTaintChicken.field_70170_p);
                this.convertFromTo((Entity)entityTaintChicken, (EntityLivingBase)chicken);
                wand.consumeAllVis(itemstack, p, this.getVisCost(itemstack), true, false);
            }
            if (pointedEntity instanceof EntityTaintVillager) {
                EntityTaintVillager entityTaintVillager = (EntityTaintVillager)pointedEntity;
                EntityVillager villager = new EntityVillager(entityTaintVillager.field_70170_p);
                this.convertFromTo((Entity)entityTaintVillager, (EntityLivingBase)villager);
                wand.consumeAllVis(itemstack, p, this.getVisCost(itemstack), true, false);
            }
            if (pointedEntity instanceof EntityTaintPig) {
                EntityTaintPig entityTaintPig = (EntityTaintPig)pointedEntity;
                EntityPig pig = new EntityPig(entityTaintPig.field_70170_p);
                this.convertFromTo((Entity)entityTaintPig, (EntityLivingBase)pig);
                wand.consumeAllVis(itemstack, p, this.getVisCost(itemstack), true, false);
            }
            if (pointedEntity instanceof EntityTaintCreeper) {
                EntityTaintCreeper entityTaintCreeper = (EntityTaintCreeper)pointedEntity;
                EntityCreeper creeper = new EntityCreeper(entityTaintCreeper.field_70170_p);
                this.convertFromTo((Entity)entityTaintCreeper, (EntityLivingBase)creeper);
                wand.consumeAllVis(itemstack, p, this.getVisCost(itemstack), true, false);
            }
            return itemstack;
        }
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            for (int xOffset = 0 - potency; xOffset < 1 + potency; ++xOffset) {
                for (int zOffset = 0 - potency; zOffset < 1 + potency; ++zOffset) {
                    this.cleanUpLand(mop.field_72311_b + xOffset, mop.field_72309_d + zOffset, world, itemstack, p);
                }
            }
        }
        return itemstack;
    }

    public boolean onFocusBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer player) {
        ItemWandCasting wand = (ItemWandCasting)itemstack.func_77973_b();
        TileEntity tile = player.func_130014_f_().func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileNode) {
            TileNode node = (TileNode)tile;
            if (node.getNodeType() == NodeType.TAINTED && wand.consumeAllVis(itemstack, player, this.getNodeVisCost(itemstack), true, false)) {
                node.setNodeType(NodeType.NORMAL);
                node.func_70296_d();
                player.func_130014_f_().func_147471_g(x, y, z);
            }
            return true;
        }
        return false;
    }

    public void convertFromTo(Entity original, EntityLivingBase convertTo) {
        convertTo.func_82149_j(original);
        if (!original.field_70170_p.field_72995_K) {
            original.field_70170_p.func_72838_d((Entity)convertTo);
        }
        convertTo.field_70170_p.func_72900_e(original);
    }

    private AspectList getBigVisCost(int potency) {
        AspectList toReturn = new AspectList().add(Aspect.EARTH, 10 * (potency * 2 + 1) * (potency * 2 + 1)).add(Aspect.ORDER, 15 * (potency * 2 + 1) * (potency * 2 + 1));
        return toReturn;
    }

    private void cleanUpLand(int x, int z, World world, ItemStack itemStack, EntityPlayer p) {
        if (!(p.field_70170_p.field_72995_K || world.func_72807_a((int)x, (int)z).field_76756_M != Config.biomeTaintID && world.func_72807_a((int)x, (int)z).field_76756_M != Config.biomeEerieID && world.func_72807_a((int)x, (int)z).field_76756_M != Config.biomeMagicalForestID)) {
            ItemWandCasting wand = (ItemWandCasting)itemStack.func_77973_b();
            wand.consumeAllVis(itemStack, p, this.getVisCost(itemStack), true, false);
            BiomeGenBase[] biomesForGeneration = null;
            biomesForGeneration = world.func_72959_q().func_76933_b(biomesForGeneration, x, z, 1, 1);
            if (biomesForGeneration != null && biomesForGeneration[0] != null) {
                BlightbusterNetwork.setBiomeAt(world, x, z, biomesForGeneration[0]);
            }
        }
        for (int y = 0; y < 256; ++y) {
            if (world.func_147439_a(x, y, z) == ConfigBlocks.blockTaintFibres) {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
            }
            if (world.func_147439_a(x, y, z) != ConfigBlocks.blockTaint) continue;
            if (world.func_72805_g(x, y, z) == 0) {
                world.func_147465_d(x, y, z, ConfigBlocks.blockFluxGoo, ((BlockFluxGoo)ConfigBlocks.blockFluxGoo).getQuanta(), 3);
                continue;
            }
            if (world.func_72805_g(x, y, z) == 1) {
                world.func_147449_b(x, y, z, Blocks.field_150346_d);
                continue;
            }
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.func_111208_A());
        this.icon = register.func_94245_a(this.func_111208_A());
    }

    public int getFocusColor(ItemStack arg0) {
        return 3340485;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
        }
        return null;
    }

    public AspectList getVisCost(ItemStack arg0) {
        return cost;
    }

    public AspectList getNodeVisCost(ItemStack arg0) {
        return auraCost;
    }
}

