/*
 * Decompiled with CFR 0.152.
 */
package talonos.blightbuster.client;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import talonos.blightbuster.tileentity.DawnMachineSpoutTileEntity;
import talonos.blightbuster.tileentity.dawnmachine.DawnMachineResource;
import thaumcraft.api.aspects.Aspect;

public class DawnMachineSpoutRenderer
extends TileEntitySpecialRenderer {
    private ResourceLocation normalTexture = new ResourceLocation("blightbuster:textures/aspects/rawAspects.png");
    private ResourceLocation glowTexture = new ResourceLocation("blightbuster:textures/aspects/glowAspects.png");
    private boolean initializedTexFilters = false;

    private void initializeTexFilters() {
        this.func_147499_a(this.normalTexture);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        this.func_147499_a(this.glowTexture);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float f) {
        DawnMachineSpoutTileEntity te = (DawnMachineSpoutTileEntity)tile;
        if (!this.initializedTexFilters) {
            this.initializeTexFilters();
        }
        GL11.glPushMatrix();
        ForgeDirection dir = ForgeDirection.NORTH;
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        for (int i = 0; i < 4; ++i) {
            GL11.glPushMatrix();
            Aspect dirAspect = te.getEssentiaType(dir);
            float minU = 0.1f;
            float maxU = 0.4f;
            float minV = -0.4f;
            float maxV = -0.1f;
            if (dirAspect != null) {
                int value = te.getEssentiaAmount(dir);
                if (value > 0) {
                    this.func_147499_a(this.glowTexture);
                    GL11.glDisable((int)2896);
                    minU = 0.0625f;
                    maxU = 0.4375f;
                    minV = -0.4375f;
                    maxV = -0.0625f;
                } else {
                    this.func_147499_a(this.normalTexture);
                    GL11.glEnable((int)2896);
                }
                if (this.isRightSide(dirAspect)) {
                    float tmpMinU = minU;
                    minU = maxU * -1.0f;
                    maxU = tmpMinU * -1.0f;
                }
                GL11.glEnable((int)3042);
                GL11.glDisable((int)3008);
                GL11.glBlendFunc((int)770, (int)771);
                DawnMachineResource resource = DawnMachineResource.getResourceFromAspect(dirAspect);
                GL11.glBegin((int)7);
                GL11.glTexCoord2f((float)resource.getU(), (float)(resource.getV() + 0.5f));
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glVertex3f((float)minU, (float)minV, (float)-0.5001f);
                GL11.glTexCoord2f((float)resource.getU(), (float)resource.getV());
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glVertex3f((float)minU, (float)maxV, (float)-0.5001f);
                GL11.glTexCoord2f((float)(resource.getU() + 0.2f), (float)resource.getV());
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glVertex3f((float)maxU, (float)maxV, (float)-0.5001f);
                GL11.glTexCoord2f((float)(resource.getU() + 0.2f), (float)(resource.getV() + 0.5f));
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glVertex3f((float)maxU, (float)minV, (float)-0.5001f);
                GL11.glEnd();
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            dir = dir.getRotation(ForgeDirection.DOWN);
        }
        GL11.glPopMatrix();
    }

    private boolean isRightSide(Aspect aspect) {
        return aspect == Aspect.MIND || aspect == Aspect.MECHANISM || aspect == Aspect.TREE || aspect == Aspect.PLANT;
    }
}

