/*
 * Decompiled with CFR 0.152.
 */
package talonos.biomescanner.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import talonos.biomescanner.map.Zone;

public class ItemBadge
extends Item {
    private IIcon[] zoneIcons = new IIcon[Zone.values().length * 3];
    private IIcon completionIcon;
    private IIcon beginnerIcon;
    private IIcon zoneSilhouette;
    private IIcon beginnerSilhouette;
    private IIcon completionSilhouette;

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.completionIcon = iconRegister.func_94245_a("biomescanner:completionBadge");
        this.beginnerIcon = iconRegister.func_94245_a("biomescanner:beginnerBadge");
        this.zoneSilhouette = iconRegister.func_94245_a("biomescanner:zoneBadgeSilhouette");
        this.beginnerSilhouette = iconRegister.func_94245_a("biomescanner:beginnerSilhouette");
        this.completionSilhouette = iconRegister.func_94245_a("biomescanner:completionSilhouette");
        for (Zone zone : Zone.values()) {
            this.zoneIcons[zone.ordinal() * 3] = iconRegister.func_94245_a("biomescanner:zoneBadge-" + zone.toString() + "-bronze");
            this.zoneIcons[zone.ordinal() * 3 + 1] = iconRegister.func_94245_a("biomescanner:zoneBadge-" + zone.toString() + "-silver");
            this.zoneIcons[zone.ordinal() * 3 + 2] = iconRegister.func_94245_a("biomescanner:zoneBadge-" + zone.toString() + "-gold");
        }
    }

    public IIcon getZoneSilhouette() {
        return this.zoneSilhouette;
    }

    public IIcon getCompletionSilhouette() {
        return this.completionSilhouette;
    }

    public IIcon getBeginnerSilhouette() {
        return this.beginnerSilhouette;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return pass == 0 && this.zoneIcons.length == stack.func_77960_j();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        if (damage < this.zoneIcons.length) {
            return this.zoneIcons[damage];
        }
        if (this.zoneIcons.length == damage) {
            return this.completionIcon;
        }
        return this.beginnerIcon;
    }

    public String func_77653_i(ItemStack stack) {
        String medalDisplay;
        int damage = stack.func_77960_j();
        if (damage == this.zoneIcons.length) {
            return StatCollector.func_74838_a((String)"item.completionBadge.name");
        }
        if (damage > this.zoneIcons.length) {
            return StatCollector.func_74838_a((String)"item.beginnerBadge.name");
        }
        int medalType = damage % 3;
        String zoneName = StatCollector.func_74838_a((String)Zone.values()[damage / 3].getDisplay());
        switch (medalType) {
            case 0: {
                medalDisplay = StatCollector.func_74838_a((String)"item.zoneBronze.name");
                break;
            }
            case 1: {
                medalDisplay = StatCollector.func_74838_a((String)"item.zoneSilver.name");
                break;
            }
            default: {
                medalDisplay = StatCollector.func_74838_a((String)"item.zoneGold.name");
            }
        }
        return medalDisplay.replace("{0}", zoneName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean advanced) {
        int damage = itemStack.func_77960_j();
        if (damage < this.zoneIcons.length) {
            String zoneName = StatCollector.func_74838_a((String)Zone.values()[damage / 3].getDisplay());
            int medalType = damage % 3;
            switch (medalType) {
                case 0: {
                    this.addBadgeData("gui.bronzeInfo", zoneName, info);
                    break;
                }
                case 1: {
                    this.addBadgeData("gui.silverInfo", zoneName, info);
                    break;
                }
                case 2: {
                    this.addBadgeData("gui.goldInfo", zoneName, info);
                }
            }
            return;
        }
        if (damage == this.zoneIcons.length) {
            this.addBadgeData("gui.completionInfo", "", info);
            return;
        }
        this.addBadgeData("gui.beginnerInfo", "", info);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.zoneIcons.length; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
        list.add(new ItemStack((Item)this, 1, this.zoneIcons.length));
        list.add(new ItemStack((Item)this, 1, this.zoneIcons.length + 1));
    }

    private void addBadgeData(String value, String zoneName, List info) {
        for (int i = 0; i < 99 && StatCollector.func_94522_b((String)(value + Integer.toString(i))); ++i) {
            info.add("\u00a79" + StatCollector.func_74838_a((String)(value + Integer.toString(i))).replace("{0}", zoneName));
        }
    }
}

