/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.override;

import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import iguanaman.iguanatweakstconstruct.override.BlockOverride;
import iguanaman.iguanatweakstconstruct.override.ExtraHarvestLevelHandler;
import iguanaman.iguanatweakstconstruct.override.HarvestLevelNameOverride;
import iguanaman.iguanatweakstconstruct.override.IOverride;
import iguanaman.iguanatweakstconstruct.override.MaterialOverride;
import iguanaman.iguanatweakstconstruct.override.ModifierOverride;
import iguanaman.iguanatweakstconstruct.override.ToolOverride;
import iguanaman.iguanatweakstconstruct.reference.Reference;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import tconstruct.util.IMCHandler;

@Pulse(id="Override", description="This module allows to override about any values relevant for TConstruct or IguanaTinkerTweaks.", defaultEnable=false)
public class IguanaOverride {
    @Handler
    public void postInit(FMLPostInitializationEvent event) {
        new ForgeHooks();
        IguanaOverride.doOverride("Material", new MaterialOverride());
        IguanaOverride.doOverride("Tool", new ToolOverride());
        IguanaOverride.doOverride("Block", new BlockOverride());
        IguanaOverride.doOverride("BonusModifier", new ModifierOverride());
        IguanaOverride.doOverride("HarvestLevelNames", new HarvestLevelNameOverride());
        MinecraftForge.EVENT_BUS.register((Object)new ExtraHarvestLevelHandler());
    }

    public static void doOverride(String type, IOverride overrider) {
        String configFileName = type + "Override.cfg";
        String defaultFileName = type + "Defaults.cfg";
        try {
            Configuration defaultConfig = new Configuration(Reference.configFile(defaultFileName));
            overrider.createDefault(defaultConfig);
            defaultConfig.save();
        }
        catch (RuntimeException e) {
            IMCHandler.bigWarning((String)"An Error occurred while creating default files for the %s Override", (Object[])new Object[]{type});
            throw e;
        }
        try {
            Configuration config = new Configuration(Reference.configFile(configFileName));
            config.load();
            overrider.processConfig(config);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (RuntimeException e) {
            IMCHandler.bigWarning((String)"An Error occurred while processing the Override for %s", (Object[])new Object[]{type});
            throw e;
        }
    }
}

