/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.thermaldynamics.multiblock.IMultiBlockRoute;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.multiblock.RouteCache;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.world.World;

public abstract class MultiBlockGridWithRoutes
extends MultiBlockGrid {
    public HashMap<IMultiBlockRoute, RouteCache> routeCacheMap = new HashMap();
    public final LinkedList<RouteCache> calculatingRoutes = new LinkedList();

    public MultiBlockGridWithRoutes(World world) {
        super(world);
    }

    @Override
    public void doTickProcessing(long l) {
        while (!this.calculatingRoutes.isEmpty() && System.nanoTime() < l) {
            RouteCache routeCache = this.calculatingRoutes.peek();
            if (routeCache == null || routeCache.processStep()) continue;
            this.calculatingRoutes.remove(routeCache);
        }
    }

    @Override
    public boolean isTickProcessing() {
        return !this.calculatingRoutes.isEmpty();
    }

    @Override
    public void onMinorGridChange() {
        this.onMajorGridChange();
    }

    @Override
    public void onMajorGridChange() {
        if (!this.routeCacheMap.isEmpty()) {
            for (RouteCache routeCache : this.routeCacheMap.values()) {
                routeCache.invalidate();
            }
            this.routeCacheMap.clear();
        }
        if (!this.calculatingRoutes.isEmpty()) {
            this.calculatingRoutes.clear();
        }
    }

    public RouteCache getRoutesFromOutputNonUrgent(IMultiBlockRoute iMultiBlockRoute) {
        RouteCache routeCache = this.routeCacheMap.get(iMultiBlockRoute);
        if (routeCache != null) {
            return routeCache;
        }
        routeCache = new RouteCache(iMultiBlockRoute);
        this.calculatingRoutes.add(routeCache);
        this.routeCacheMap.put(iMultiBlockRoute, routeCache);
        return routeCache;
    }

    public RouteCache getRoutesFromOutputRange(IMultiBlockRoute iMultiBlockRoute, int n) {
        RouteCache routeCache = this.routeCacheMap.get(iMultiBlockRoute);
        if (routeCache == null) {
            routeCache = new RouteCache(iMultiBlockRoute, n);
            routeCache.generateCache();
            this.routeCacheMap.put(iMultiBlockRoute, routeCache);
        } else if (routeCache.maxPathLength < n) {
            routeCache.maxPathLength = n;
            routeCache.generateCache();
        }
        return routeCache;
    }

    public RouteCache getRoutesFromOutput(IMultiBlockRoute iMultiBlockRoute) {
        RouteCache routeCache = this.routeCacheMap.get(iMultiBlockRoute);
        if (routeCache == null) {
            routeCache = new RouteCache(iMultiBlockRoute);
            routeCache.generateCache();
            this.routeCacheMap.put(iMultiBlockRoute, routeCache);
        } else if (!routeCache.isFinishedGenerating() || routeCache.maxPathLength < Integer.MAX_VALUE) {
            routeCache.maxPathLength = Integer.MAX_VALUE;
            routeCache.generateCache();
        }
        return routeCache;
    }
}

