/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.item;

import cofh.core.network.PacketCoFHBase;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.BlockHelper;
import cofh.repack.codechicken.lib.vec.BlockCoord;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.core.TickHandlerClient;
import cofh.thermaldynamics.duct.item.StackMap;
import cofh.thermaldynamics.duct.item.TileItemDuct;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.multiblock.RouteCache;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TravelingItem {
    public ItemStack stack;
    public byte progress;
    public byte direction;
    public byte oldDirection;
    public Route myPath;
    public boolean goingToStuff = false;
    public int startX;
    public int startY;
    public int startZ;
    public int destX;
    public int destY;
    public int destZ;
    public boolean mustGoToDest = false;
    public boolean hasDest = false;
    public boolean reRoute = false;
    public StackMap.ItemEntry stackItemEntry;
    public boolean shouldDie = false;
    public int step = 1;

    public TravelingItem(ItemStack itemStack, IMultiBlock iMultiBlock, Route route, byte by, byte by2) {
        this(itemStack, iMultiBlock.x(), iMultiBlock.y(), iMultiBlock.z(), route, by, by2);
    }

    public TravelingItem(ItemStack itemStack, int n, int n2, int n3, Route route, byte by, byte by2) {
        this.progress = 0;
        this.direction = route.getNextDirection();
        this.myPath = route;
        this.startX = n;
        this.startY = n2;
        this.startZ = n3;
        this.stack = itemStack;
        this.oldDirection = by;
        this.step = by2;
        if (this.myPath != null && this.myPath.endPoint != null) {
            this.destX = this.myPath.endPoint.x();
            this.destY = this.myPath.endPoint.y();
            this.destZ = this.myPath.endPoint.z();
            this.hasDest = true;
        }
    }

    public TravelingItem(byte by, byte by2, byte by3, ItemStack itemStack, TileItemDuct tileItemDuct, byte by4) {
        this.progress = by;
        this.direction = by2;
        this.oldDirection = by3;
        this.stack = itemStack;
        this.step = by4;
    }

    public void tickForward(TileItemDuct tileItemDuct) {
        this.progress = (byte)(this.progress + this.step);
        if (this.myPath == null) {
            this.bounceItem(tileItemDuct);
        } else if (this.progress >= tileItemDuct.getPipeLength()) {
            this.progress = (byte)(this.progress % tileItemDuct.getPipeLength());
            this.advanceTile(tileItemDuct);
        } else if (this.progress >= tileItemDuct.getPipeHalfLength() && this.progress - this.step < tileItemDuct.getPipeHalfLength() && (this.reRoute || tileItemDuct.neighborTypes[this.direction] == TileTDBase.NeighborTypes.NONE)) {
            this.bounceItem(tileItemDuct);
        }
    }

    public void advanceTile(TileItemDuct tileItemDuct) {
        if (tileItemDuct.neighborTypes[this.direction] == TileTDBase.NeighborTypes.MULTIBLOCK && tileItemDuct.connectionTypes[this.direction] == TileTDBase.ConnectionTypes.NORMAL) {
            TileItemDuct tileItemDuct2 = (TileItemDuct)tileItemDuct.getConnectedSide(this.direction);
            if (tileItemDuct2 != null && tileItemDuct2.neighborTypes[this.direction ^ 1] == TileTDBase.NeighborTypes.MULTIBLOCK) {
                tileItemDuct.removeItem(this, false);
                tileItemDuct2.transferItem(this);
                if (this.myPath.hasNextDirection()) {
                    this.oldDirection = this.direction;
                    this.direction = this.myPath.getNextDirection();
                } else {
                    this.reRoute = true;
                }
            }
        } else if (tileItemDuct.neighborTypes[this.direction] == TileTDBase.NeighborTypes.OUTPUT && tileItemDuct.connectionTypes[this.direction] == TileTDBase.ConnectionTypes.NORMAL) {
            this.stack.field_77994_a = tileItemDuct.insertIntoInventory(this.stack, this.direction);
            if (this.stack.field_77994_a > 0) {
                this.bounceItem(tileItemDuct);
                return;
            }
            tileItemDuct.removeItem(this, true);
        } else if (tileItemDuct.neighborTypes[this.direction] == TileTDBase.NeighborTypes.INPUT && this.goingToStuff) {
            if (tileItemDuct.canStuffItem()) {
                this.goingToStuff = false;
                tileItemDuct.stuffItem(this);
                tileItemDuct.removeItem(this, true);
            } else {
                this.goingToStuff = false;
                this.bounceItem(tileItemDuct);
            }
        } else {
            this.bounceItem(tileItemDuct);
        }
    }

    public void bounceItem(TileItemDuct tileItemDuct) {
        TileItemDuct.RouteInfo routeInfo;
        RouteCache routeCache = tileItemDuct.getCache();
        if (this.hasDest) {
            for (Route route : routeCache.outputRoutes) {
                if (!route.endPoint.isNode() || route.endPoint.x() != this.destX || route.endPoint.y() != this.destY || route.endPoint.z() != this.destZ) continue;
                routeInfo = route.endPoint.canRouteItem(this.stack);
                if (!routeInfo.canRoute) continue;
                this.myPath = route.copy();
                this.myPath.pathDirections.add(routeInfo.side);
                this.oldDirection = (byte)(this.direction ^ 1);
                this.direction = this.myPath.getNextDirection();
                tileItemDuct.hasChanged = true;
                return;
            }
            if (tileItemDuct.ticksExisted < 2) {
                return;
            }
        }
        if (!this.hasDest || !this.mustGoToDest && this.hasDest) {
            for (Route route : routeCache.outputRoutes) {
                if (!route.endPoint.isNode()) continue;
                routeInfo = route.endPoint.canRouteItem(this.stack);
                if (!routeInfo.canRoute) continue;
                this.myPath = route.copy();
                this.myPath.pathDirections.add(routeInfo.side);
                this.oldDirection = (byte)(this.direction ^ 1);
                this.direction = this.myPath.getNextDirection();
                tileItemDuct.hasChanged = true;
                this.hasDest = true;
                this.destX = this.myPath.endPoint.x();
                this.destY = this.myPath.endPoint.y();
                this.destZ = this.myPath.endPoint.z();
                return;
            }
        }
        if (tileItemDuct.ticksExisted <= 6) {
            return;
        }
        if (tileItemDuct.acceptingStuff()) {
            byte by = tileItemDuct.getStuffedSide();
            if (by == this.direction) {
                tileItemDuct.stuffItem(this);
                tileItemDuct.removeItem(this, true);
            } else {
                this.myPath = new Route(tileItemDuct);
                this.myPath.pathDirections.add(this.myPath.endPoint.getStuffedSide());
                this.oldDirection = (byte)(this.direction ^ 1);
                this.direction = this.myPath.getNextDirection();
                tileItemDuct.hasChanged = true;
            }
        } else {
            Route route = this.getStuffedRoute(routeCache);
            if (route != null) {
                this.goingToStuff = true;
                this.myPath = route;
                this.myPath.pathDirections.add(this.myPath.endPoint.getStuffedSide());
                this.oldDirection = (byte)(this.direction ^ 1);
                this.direction = this.myPath.getNextDirection();
                tileItemDuct.hasChanged = true;
            } else if (tileItemDuct.ticksExisted == 10) {
                CoreUtils.dropItemStackIntoWorld((ItemStack)this.stack, (World)tileItemDuct.func_145831_w(), (double)tileItemDuct.x(), (double)tileItemDuct.y(), (double)tileItemDuct.z());
                tileItemDuct.removeItem(this, true);
            }
        }
    }

    public Route getStuffedRoute(RouteCache routeCache) {
        if (routeCache.stuffableRoutes.isEmpty()) {
            return null;
        }
        Route route = null;
        for (Route route2 : routeCache.stuffableRoutes) {
            if (!route2.endPoint.acceptingStuff()) continue;
            if (route == null) {
                route = route2.copy();
            }
            if (route2.endPoint.x() != this.startX || route2.endPoint.y() != this.startY || route2.endPoint.z() != this.startZ) continue;
            return route2.copy();
        }
        return route;
    }

    public void tickClientForward(TileItemDuct tileItemDuct) {
        this.progress = (byte)(this.progress + this.step);
        if (this.progress >= tileItemDuct.getPipeLength()) {
            this.progress = (byte)(this.progress % tileItemDuct.getPipeLength());
            if (this.shouldDie) {
                tileItemDuct.removeItem(this, true);
            } else {
                tileItemDuct.removeItem(this, false);
                this.shouldDie = true;
                TileEntity tileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)tileItemDuct, (int)this.direction);
                if (tileEntity instanceof TileItemDuct) {
                    TileItemDuct tileItemDuct2 = (TileItemDuct)tileEntity;
                    this.oldDirection = this.direction;
                    tileItemDuct2.myItems.add(this);
                    if (!TickHandlerClient.tickBlocks.contains(tileItemDuct2) && !TickHandlerClient.tickBlocksToAdd.contains(tileItemDuct2)) {
                        TickHandlerClient.tickBlocksToAdd.add(tileItemDuct2);
                    }
                }
            }
        }
    }

    public void writePacket(PacketCoFHBase packetCoFHBase) {
        packetCoFHBase.addByte(this.progress);
        packetCoFHBase.addByte(this.direction);
        packetCoFHBase.addByte(this.oldDirection);
        packetCoFHBase.addItemStack(this.stack);
        packetCoFHBase.addByte(this.step);
    }

    public static TravelingItem fromPacket(PacketCoFHBase packetCoFHBase, TileItemDuct tileItemDuct) {
        return new TravelingItem(packetCoFHBase.getByte(), packetCoFHBase.getByte(), packetCoFHBase.getByte(), packetCoFHBase.getItemStack(), tileItemDuct, packetCoFHBase.getByte());
    }

    public void toNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74782_a("stack", (NBTBase)new NBTTagCompound());
        this.stack.func_77955_b(nBTTagCompound.func_74775_l("stack"));
        nBTTagCompound.func_74774_a("progress", this.progress);
        nBTTagCompound.func_74774_a("direction", this.direction);
        nBTTagCompound.func_74774_a("oldDir", this.oldDirection);
        nBTTagCompound.func_74757_a("gts", this.goingToStuff);
        nBTTagCompound.func_74768_a("step", this.step);
        if (this.hasDest) {
            nBTTagCompound.func_74768_a("destX", this.destX);
            nBTTagCompound.func_74768_a("destY", this.destY);
            nBTTagCompound.func_74768_a("destZ", this.destZ);
            nBTTagCompound.func_74757_a("mustGo", this.mustGoToDest);
        }
        nBTTagCompound.func_74768_a("startX", this.startX);
        nBTTagCompound.func_74768_a("startY", this.startY);
        nBTTagCompound.func_74768_a("startZ", this.startZ);
        if (this.myPath != null) {
            nBTTagCompound.func_74773_a("route", this.myPath.toByteArray());
        }
    }

    public TravelingItem(NBTTagCompound nBTTagCompound) {
        this.stack = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound.func_74775_l("stack"));
        this.progress = nBTTagCompound.func_74771_c("progress");
        this.direction = nBTTagCompound.func_74771_c("direction");
        this.oldDirection = nBTTagCompound.func_74771_c("oldDir");
        this.goingToStuff = nBTTagCompound.func_74767_n("goingToStuff");
        if (nBTTagCompound.func_74764_b("destX")) {
            this.hasDest = true;
            this.destX = nBTTagCompound.func_74762_e("destX");
            this.destY = nBTTagCompound.func_74762_e("destY");
            this.destZ = nBTTagCompound.func_74762_e("destZ");
            this.mustGoToDest = nBTTagCompound.func_74767_n("mustGo");
        }
        this.step = nBTTagCompound.func_74771_c("step");
        this.startX = nBTTagCompound.func_74762_e("startX");
        this.startY = nBTTagCompound.func_74762_e("startY");
        this.startZ = nBTTagCompound.func_74762_e("startZ");
        if (nBTTagCompound.func_150297_b("route", 7)) {
            this.myPath = new Route(nBTTagCompound.func_74770_j("route"));
        }
    }

    public BlockCoord getDest() {
        if (this.myPath == null) {
            return null;
        }
        if (this.myPath.dest == null) {
            if (this.myPath.endPoint == null) {
                if (!this.hasDest) {
                    return null;
                }
                this.myPath.dest = new BlockCoord(this.destX, this.destY, this.destZ).offset(this.myPath.getLastSide());
            } else {
                this.myPath.dest = new BlockCoord(this.myPath.endPoint.x(), this.myPath.endPoint.y(), this.myPath.endPoint.z()).offset(this.myPath.getLastSide());
            }
        }
        return this.myPath.dest;
    }

    public StackMap.ItemEntry getStackEntry() {
        if (this.stackItemEntry == null) {
            this.stackItemEntry = new StackMap.ItemEntry(this.stack, 0);
        }
        this.stackItemEntry.side = this.myPath.getLastSide();
        return this.stackItemEntry;
    }
}

