/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.retriever;

import cofh.core.render.RenderUtils;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.fluid.TileFluidDuct;
import cofh.thermaldynamics.render.RenderDuct;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class RetrieverFluid
extends ServoFluid {
    public RetrieverFluid(TileTDBase tileTDBase, byte by) {
        super(tileTDBase, by);
    }

    public RetrieverFluid(TileTDBase tileTDBase, byte by, int n) {
        super(tileTDBase, by, n);
    }

    @Override
    public int getId() {
        return 5;
    }

    @Override
    public void tick(int n) {
        if (n != 1 || this.fluidDuct.fluidGrid == null || !this.isPowered || !this.isValidInput) {
            return;
        }
        int n2 = Math.min(this.fluidDuct.fluidGrid.myTank.getSpace(), (int)Math.ceil((float)this.fluidDuct.fluidGrid.myTank.fluidThroughput * ServoFluid.throttle[this.type]));
        if (n2 == 0) {
            return;
        }
        if (this.fluidDuct.fluidGrid.myTank.getFluid() != null && !this.fluidPassesFiltering(this.fluidDuct.fluidGrid.myTank.getFluid())) {
            return;
        }
        for (TileFluidDuct tileFluidDuct : this.fluidDuct.fluidGrid.nodeSet) {
            for (int i = 0; i < 6; ++i) {
                FluidStack fluidStack;
                int n3 = (i + tileFluidDuct.internalSideCounter) % 6;
                if (tileFluidDuct.cache[n3] == null || tileFluidDuct.neighborTypes[n3] != TileTDBase.NeighborTypes.OUTPUT && tileFluidDuct.neighborTypes[n3] != TileTDBase.NeighborTypes.INPUT || tileFluidDuct.attachments[n3] != null && tileFluidDuct.attachments[n3].getId() == this.getId() || (fluidStack = tileFluidDuct.cache[n3].drain(ForgeDirection.VALID_DIRECTIONS[n3 ^ 1], n2, false)) == null || fluidStack.amount <= 0 || !this.fluidPassesFiltering(fluidStack) || !tileFluidDuct.cache[n3].canDrain(ForgeDirection.VALID_DIRECTIONS[n3 ^ 1], fluidStack.getFluid())) continue;
                if (tileFluidDuct.fluidGrid.myTank.getFluid() == null || tileFluidDuct.fluidGrid.myTank.getFluid().fluidID == 0) {
                    tileFluidDuct.fluidGrid.myTank.setFluid(tileFluidDuct.cache[n3].drain(ForgeDirection.VALID_DIRECTIONS[n3 ^ 1], n2, true));
                } else if (tileFluidDuct.fluidGrid.myTank.getFluid().isFluidEqual(fluidStack)) {
                    tileFluidDuct.fluidGrid.myTank.getFluid().amount += tileFluidDuct.cache[n3].drain((ForgeDirection)ForgeDirection.VALID_DIRECTIONS[n3 ^ 1], (int)n2, (boolean)true).amount;
                }
                if (tileFluidDuct.fluidGrid.toDistribute > 0 && tileFluidDuct.fluidGrid.myTank.getFluid() != null) {
                    tileFluidDuct.transfer(this.side, Math.min(tileFluidDuct.fluidGrid.myTank.getFluid().amount, tileFluidDuct.fluidGrid.toDistribute));
                }
                return;
            }
        }
    }

    @Override
    public ItemStack getPickBlock() {
        return new ItemStack((Item)ThermalDynamics.itemRetriever, 1, this.type);
    }

    @Override
    public String getName() {
        return "item.thermaldynamics.retriever." + this.type + ".name";
    }

    @Override
    public boolean render(int n, RenderBlocks renderBlocks) {
        if (n == 1) {
            return false;
        }
        Translation translation = RenderUtils.getRenderVector((double)((double)((TileEntity)this.tile).field_145851_c + 0.5), (double)((double)((TileEntity)this.tile).field_145848_d + 0.5), (double)((double)((TileEntity)this.tile).field_145849_e + 0.5)).translation();
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)RenderDuct.retrieverTexture[this.type * 2 + (this.stuffed ? 1 : 0)])});
        return true;
    }

    @Override
    public TileTDBase.NeighborTypes getNeighborType() {
        return this.isValidInput ? TileTDBase.NeighborTypes.OUTPUT : TileTDBase.NeighborTypes.DUCT_ATTACHMENT;
    }
}

