/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.core;

import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import net.minecraft.world.World;

public class WorldGridList {
    public World worldObj;
    public LinkedHashSet<MultiBlockGrid> tickingGrids = new LinkedHashSet();
    public LinkedHashSet<IMultiBlock> tickingBlocks = new LinkedHashSet();
    public LinkedHashSet<MultiBlockGrid> gridsToRecreate = new LinkedHashSet();
    public LinkedHashSet<MultiBlockGrid> newGrids = new LinkedHashSet();
    public LinkedHashSet<MultiBlockGrid> oldGrids = new LinkedHashSet();

    public WorldGridList(World world) {
        this.worldObj = world;
    }

    public void tickStart() {
        if (!this.newGrids.isEmpty()) {
            this.tickingGrids.addAll(this.newGrids);
            this.newGrids.clear();
        }
        if (!this.oldGrids.isEmpty()) {
            this.tickingGrids.removeAll(this.oldGrids);
            this.oldGrids.clear();
        }
    }

    public void tickEnd() {
        if (!this.gridsToRecreate.isEmpty()) {
            this.tickingGrids.removeAll(this.gridsToRecreate);
            for (MultiBlockGrid object : this.gridsToRecreate) {
                for (IMultiBlock iMultiBlock : object.idleSet) {
                    this.tickingBlocks.add(iMultiBlock);
                    object.destroyNode(iMultiBlock);
                }
                for (IMultiBlock iMultiBlock : object.nodeSet) {
                    this.tickingBlocks.add(iMultiBlock);
                    object.destroyNode(iMultiBlock);
                }
            }
            this.gridsToRecreate.clear();
        }
        LinkedList linkedList = new LinkedList();
        for (MultiBlockGrid multiBlockGrid : this.tickingGrids) {
            multiBlockGrid.tickGrid();
            if (!multiBlockGrid.isTickProcessing()) continue;
            linkedList.add(multiBlockGrid);
        }
        if (!linkedList.isEmpty()) {
            long iterator = System.nanoTime() + 100000L;
            Iterator iterator2 = linkedList.iterator();
            while (System.nanoTime() < iterator && iterator2.hasNext()) {
                ((MultiBlockGrid)iterator2.next()).doTickProcessing(iterator);
            }
        }
        if (!this.tickingBlocks.isEmpty()) {
            Iterator iterator = this.tickingBlocks.iterator();
            while (iterator.hasNext()) {
                IMultiBlock iMultiBlock = (IMultiBlock)iterator.next();
                if (!iMultiBlock.existsYet()) continue;
                iMultiBlock.tickMultiBlock();
                iterator.remove();
            }
        }
    }
}

