/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.tileentity.base;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityPoweredInventory
extends TileEntityInventory
implements IEnergyHandler {
    public static float energyPerRF = 1.0f;
    private int cycledTicks = -1;
    private EnergyStorage energyStorage = new EnergyStorage(this.getMaxEnergyStored());

    protected abstract int getMaxEnergyStored();

    public abstract int getCycleEnergyCost();

    public abstract int getCycleLength();

    public abstract boolean canBeginCycle();

    public abstract void onPoweredCycleBegin();

    public abstract void onPoweredCycleEnd();

    public int getCurrentCycleTicks() {
        return this.cycledTicks;
    }

    @Override
    public boolean isActive() {
        return this.cycledTicks >= 0;
    }

    public float getCycleCompletion() {
        if (this.cycledTicks < 0) {
            return 0.0f;
        }
        return (float)this.cycledTicks / (float)this.getCycleLength();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("energyStorage")) {
            this.energyStorage.readFromNBT(tag.func_74775_l("energyStorage"));
        }
        if (tag.func_74764_b("cycledTicks")) {
            this.cycledTicks = tag.func_74762_e("cycledTicks");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energyStorage.writeToNBT(energyTag);
        tag.func_74782_a("energyStorage", (NBTBase)energyTag);
        tag.func_74768_a("cycledTicks", this.cycledTicks);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.cycledTicks >= 0) {
                ++this.cycledTicks;
                if (!this.canBeginCycle()) {
                    this.cycledTicks = -1;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                } else if (this.cycledTicks >= this.getCycleLength()) {
                    this.onPoweredCycleEnd();
                    this.cycledTicks = -1;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            if (this.cycledTicks < 0 && this.getCycleEnergyCost() <= this.energyStorage.getEnergyStored() && this.canBeginCycle()) {
                this.energyStorage.extractEnergy(this.getCycleEnergyCost(), false);
                this.cycledTicks = 0;
                this.onPoweredCycleBegin();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    protected void onSendUpdate(NBTTagCompound updateTag) {
        super.onSendUpdate(updateTag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energyStorage.writeToNBT(energyTag);
        updateTag.func_74782_a("energyStorage", (NBTBase)energyTag);
        updateTag.func_74768_a("cycledTicks", this.cycledTicks);
    }

    @Override
    public void onReceiveUpdate(NBTTagCompound updateTag) {
        super.onReceiveUpdate(updateTag);
        this.energyStorage.readFromNBT(updateTag.func_74775_l("energyStorage"));
        this.cycledTicks = updateTag.func_74762_e("cycledTicks");
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }
}

