/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.api.registry;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class SteamRegistry {
    private static RangeMap<Integer, Fluid> m_SteamMappings = null;
    private static Map<Fluid, Range<Integer>> m_FluidMappings = new HashMap<Fluid, Range<Integer>>();

    public static boolean isInitialized() {
        return m_SteamMappings != null;
    }

    public static void setDefault(Fluid defaultSteam) {
        if (m_SteamMappings != null) {
            throw new IllegalStateException("Cannot call setDefault after initializing the map");
        }
        m_SteamMappings = TreeRangeMap.create();
        Range rangeAll = Range.all();
        m_SteamMappings.put(rangeAll, (Object)defaultSteam);
    }

    public static void register(int minExponent, int maxExponent, Fluid newSteam) {
        if (newSteam == null) {
            throw new IllegalArgumentException("newSteam cannot be null");
        }
        if (m_FluidMappings.containsKey(newSteam)) {
            throw new IllegalArgumentException("Fluid " + newSteam.getName() + "is already mapped");
        }
        if (maxExponent < minExponent) {
            int x = maxExponent;
            maxExponent = minExponent;
            minExponent = x;
        }
        Range range = maxExponent == minExponent ? Range.singleton((Comparable)Integer.valueOf(minExponent)) : Range.closed((Comparable)Integer.valueOf(minExponent), (Comparable)Integer.valueOf(maxExponent));
        m_SteamMappings.put(range, (Object)newSteam);
        m_FluidMappings.put(newSteam, (Range<Integer>)range);
    }

    public static Fluid get(int exponent) {
        return (Fluid)m_SteamMappings.get((Comparable)Integer.valueOf(exponent));
    }

    public static Fluid getFluidForRf(float rf) {
        if (rf <= 0.0f) {
            return (Fluid)m_SteamMappings.get((Comparable)Integer.valueOf(0));
        }
        return SteamRegistry.get((int)Math.log10(rf));
    }

    public static float getBaseRfAmountForFluid(Fluid f) {
        if (f == null || !m_FluidMappings.containsKey(f)) {
            return 1.0f;
        }
        Range<Integer> range = m_FluidMappings.get(f);
        if (!range.hasLowerBound()) {
            return 1.0f;
        }
        return ((Integer)range.lowerEndpoint()).intValue();
    }

    public static float getRfInStack(FluidStack stack) {
        if (stack == null) {
            return 0.0f;
        }
        Fluid f = stack.getFluid();
        if (f == null) {
            return 0.0f;
        }
        Range<Integer> range = m_FluidMappings.get(stack.getFluid());
        float baseAmount = 1.0f;
        if (range.hasLowerBound()) {
            baseAmount = (float)Math.pow(10.0, ((Integer)range.lowerEndpoint()).intValue());
        }
        return baseAmount * (float)stack.amount;
    }
}

