/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.api.registry;

import erogenousbeef.bigreactors.api.data.ReactorInteriorData;
import erogenousbeef.bigreactors.common.BRLog;
import java.util.HashMap;
import java.util.Map;

public class ReactorInterior {
    private static Map<String, ReactorInteriorData> _reactorModeratorBlocks = new HashMap<String, ReactorInteriorData>();
    private static Map<String, ReactorInteriorData> _reactorModeratorFluids = new HashMap<String, ReactorInteriorData>();

    public static void registerBlock(String oreDictName, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        if (_reactorModeratorBlocks.containsKey(oreDictName)) {
            BRLog.warning("Overriding existing radiation moderator block data for oredict name <%s>", oreDictName);
            ReactorInteriorData data = _reactorModeratorBlocks.get(oreDictName);
            data.absorption = absorption;
            data.heatEfficiency = heatEfficiency;
            data.moderation = moderation;
        } else {
            _reactorModeratorBlocks.put(oreDictName, new ReactorInteriorData(absorption, heatEfficiency, moderation, heatConductivity));
        }
    }

    public static void registerFluid(String fluidName, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        if (_reactorModeratorFluids.containsKey(fluidName)) {
            BRLog.warning("Overriding existing radiation moderator fluid data for fluid name <%s>", fluidName);
            ReactorInteriorData data = _reactorModeratorFluids.get(fluidName);
            data.absorption = absorption;
            data.heatEfficiency = heatEfficiency;
            data.moderation = moderation;
        } else {
            _reactorModeratorFluids.put(fluidName, new ReactorInteriorData(absorption, heatEfficiency, moderation, heatConductivity));
        }
    }

    public static ReactorInteriorData getBlockData(String oreDictName) {
        return _reactorModeratorBlocks.get(oreDictName);
    }

    public static ReactorInteriorData getFluidData(String fluidName) {
        return _reactorModeratorFluids.get(fluidName);
    }
}

