/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.common.items.dolly.api;

import java.util.HashMap;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.common.items.dolly.api.IDollyHandler;

public enum MovableRegistrar {
    INSTANCE;

    private HashMap<Class, IDollyHandler> handlers = new HashMap();

    public void registerHandler(String name, IDollyHandler handler) {
        try {
            Class<?> clazz = Class.forName(name);
            if (this.handlers.containsKey(clazz)) {
                BetterBarrels.log.warning(String.format("Handler already found for target %s. Overwritting %s with %s", clazz, this.handlers.get(clazz), handler));
            }
            this.handlers.put(clazz, handler);
        }
        catch (ClassNotFoundException e) {
            BetterBarrels.log.warning(String.format("Didn't find class %s to add to the dolly.", name));
        }
    }

    public void registerHandler(Class clazz, IDollyHandler handler) {
        if (this.handlers.containsKey(clazz)) {
            BetterBarrels.log.warning(String.format("Handler already found for target %s. Overwritting %s with %s", clazz, this.handlers.get(clazz), handler));
        }
        this.handlers.put(clazz, handler);
    }

    public IDollyHandler getHandler(Object obj) {
        IDollyHandler retVal = null;
        for (Class clazz : this.handlers.keySet()) {
            if (!clazz.isInstance(obj)) continue;
            if (retVal != null) {
                throw new RuntimeException(String.format("Multiple handlers to move object %s", obj));
            }
            retVal = this.handlers.get(clazz);
        }
        return retVal;
    }
}

