/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.common.blocks;

import java.util.Random;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.bspace.BSpaceStorageHandler;
import mcp.mobius.betterbarrels.common.JabbaCreativeTab;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import mcp.mobius.betterbarrels.common.items.upgrades.StructuralLevel;
import mcp.mobius.betterbarrels.common.items.upgrades.UpgradeCore;
import mcp.mobius.betterbarrels.common.items.upgrades.UpgradeSide;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBarrel
extends BlockContainer {
    public static IIcon text_sidehopper = null;
    public static IIcon text_siders = null;
    public static IIcon text_lock = null;
    public static IIcon text_linked = null;
    public static IIcon text_locklinked = null;

    public BlockBarrel() {
        super(new Material(MapColor.field_151663_o){
            {
                this.func_76226_g();
                this.func_85158_p();
            }
        });
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("axe", 1);
        this.func_149663_c("blockbarrel");
        this.func_149647_a(JabbaCreativeTab.tab);
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityBarrel();
    }

    public void func_149651_a(IIconRegister iconRegister) {
        text_sidehopper = iconRegister.func_94245_a("JABBA:facade_hopper");
        text_siders = iconRegister.func_94245_a("JABBA:facade_redstone");
        text_lock = iconRegister.func_94245_a("JABBA:overlay_locked");
        text_linked = iconRegister.func_94245_a("JABBA:overlay_linked");
        text_locklinked = iconRegister.func_94245_a("JABBA:overlay_lockedlinked");
        if (StructuralLevel.LEVELS == null) {
            StructuralLevel.createLevelArray();
        }
        for (int i = 0; i < StructuralLevel.LEVELS.length; ++i) {
            StructuralLevel.LEVELS[i].registerBlockIcons(iconRegister, i);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack par6ItemStack) {
        int barrelOrientation = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntityBarrel barrelEntity = (TileEntityBarrel)world.func_147438_o(x, y, z);
        if (barrelEntity != null) {
            switch (barrelOrientation) {
                case 0: {
                    barrelEntity.orientation = ForgeDirection.NORTH;
                    break;
                }
                case 1: {
                    barrelEntity.orientation = ForgeDirection.EAST;
                    break;
                }
                case 2: {
                    barrelEntity.orientation = ForgeDirection.SOUTH;
                    break;
                }
                case 3: {
                    barrelEntity.orientation = ForgeDirection.WEST;
                }
            }
            barrelEntity.sideUpgrades[barrelEntity.orientation.ordinal()] = UpgradeSide.FRONT;
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (player.field_71075_bZ.field_75098_d && !player.func_70093_af()) {
            this.func_149699_a(world, x, y, z, player);
            return false;
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            ((TileEntityBarrel)tileEntity).leftClick(player);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float var7, float var8, float var9) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            ((TileEntityBarrel)tileEntity).rightClick(player, side);
        }
        return true;
    }

    private void dropStack(World world, ItemStack stack, int x, int y, int z) {
        Random random = new Random();
        float var10 = random.nextFloat() * 0.8f + 0.1f;
        float var11 = random.nextFloat() * 0.8f + 0.1f;
        float var12 = random.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int var13 = random.nextInt(21) + 10;
            if (var13 > stack.field_77994_a) {
                var13 = stack.field_77994_a;
            }
            stack.field_77994_a -= var13;
            EntityItem items = new EntityItem(world, (double)((float)x + var10), (double)((float)y + var11), (double)((float)z + var12), new ItemStack(stack.func_77973_b(), var13, stack.func_77960_j()));
            float var15 = 0.05f;
            items.field_70159_w = (float)random.nextGaussian() * var15;
            items.field_70181_x = (float)random.nextGaussian() * var15 + 0.2f;
            items.field_70179_y = (float)random.nextGaussian() * var15;
            if (stack.func_77942_o()) {
                items.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)items);
        }
    }

    public void func_149664_b(World world, int x, int y, int z, int par5) {
        ItemStack droppedStack;
        TileEntityBarrel barrelEntity = (TileEntityBarrel)world.func_147438_o(x, y, z);
        if (barrelEntity != null && barrelEntity.coreUpgrades.levelStructural > 0) {
            for (int currentUpgrade = barrelEntity.coreUpgrades.levelStructural; currentUpgrade > 0; --currentUpgrade) {
                ItemStack droppedStack2 = new ItemStack(BetterBarrels.itemUpgradeStructural, 1, currentUpgrade - 1);
                this.dropStack(world, droppedStack2, x, y, z);
            }
        }
        if (barrelEntity != null) {
            for (UpgradeCore core : barrelEntity.coreUpgrades.upgradeList) {
                droppedStack = new ItemStack(BetterBarrels.itemUpgradeCore, 1, core.ordinal());
                this.dropStack(world, droppedStack, x, y, z);
            }
        }
        if (barrelEntity != null) {
            for (int i = 0; i < 6; ++i) {
                Item upgrade = UpgradeSide.mapItem[barrelEntity.sideUpgrades[i]];
                if (upgrade == null) continue;
                droppedStack = new ItemStack(upgrade, 1, UpgradeSide.mapMeta[barrelEntity.sideUpgrades[i]]);
                this.dropStack(world, droppedStack, x, y, z);
            }
        }
        if (barrelEntity != null && barrelEntity.getStorage().hasItem() && !barrelEntity.getLinked()) {
            barrelEntity.func_145845_h();
            int ndroppedstacks = 0;
            ItemStack droppedstack = barrelEntity.getStorage().getStack();
            while (droppedstack != null && ndroppedstacks <= 64) {
                ++ndroppedstacks;
                if (droppedstack != null) {
                    this.dropStack(world, droppedstack, x, y, z);
                }
                droppedstack = barrelEntity.getStorage().getStack();
            }
        }
        try {
            BSpaceStorageHandler.instance().unregisterEnderBarrel(barrelEntity.id);
        }
        catch (Exception e) {
            BetterBarrels.log.info("Tried to remove the barrel from the index without a valid entity");
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int par5, EntityPlayer par6EntityPlayer) {
        if (!par6EntityPlayer.field_71075_bZ.field_75098_d || par6EntityPlayer.field_71075_bZ.field_75098_d && par6EntityPlayer.func_70093_af()) {
            this.func_149664_b(world, x, y, z, par5);
        }
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149709_b(world, x, y, z, side);
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityBarrel barrel = (TileEntityBarrel)world.func_147438_o(x, y, z);
        return barrel.getRedstonePower(side);
    }

    public int func_149645_b() {
        BetterBarrels.proxy.checkRenderers();
        return BetterBarrels.blockBarrelRendererID;
    }
}

