/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.client.render;

import mcp.mobius.betterbarrels.common.blocks.logic.Coordinates;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class TileEntityBaseRenderer
extends TileEntitySpecialRenderer {
    protected float scale = 0.00390625f;
    protected RenderBlocks renderBlocks = new RenderBlocks();
    protected RenderItem renderItem = new RenderItem();
    protected Minecraft mc = Minecraft.func_71410_x();
    protected TextureManager texManager;
    protected FontRenderer renderFont;
    protected static ResourceLocation itemsSheetRes = new ResourceLocation("jabba", "textures/sheets/items.png");
    protected static ResourceLocation blocksSheetRes = new ResourceLocation("jabba", "textures/sheets/blocks.png");
    protected static ResourceLocation blocks32SheetRes = new ResourceLocation("jabba", "textures/sheets/blocks32.png");
    protected static ResourceLocation blankRes = new ResourceLocation("jabba", "blank.png");
    protected boolean hasBlending;
    protected boolean hasLight;
    protected int boundTexIndex;
    protected static byte ALIGNLEFT = 0;
    protected static byte ALIGNCENTER = 1;
    protected static byte ALIGNRIGHT = (byte)2;

    public TileEntityBaseRenderer() {
        this.texManager = this.mc.field_71446_o;
        this.renderFont = this.mc.field_71466_p;
    }

    protected void setLight(TileEntity tileEntity, ForgeDirection side) {
        int ambientLight = tileEntity.func_145831_w().func_72802_i(tileEntity.field_145851_c + side.offsetX, tileEntity.field_145848_d + side.offsetY, tileEntity.field_145849_e + side.offsetZ, 0);
        int var6 = ambientLight % 65536;
        int var7 = ambientLight / 65536;
        float var8 = 1.0f;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)var6 * var8), (float)((float)var7 * var8));
    }

    protected void renderTextOnBlock(String renderString, ForgeDirection side, ForgeDirection orientation, Coordinates barrelPos, float size, double posx, double posy, int red, int green, int blue, int alpha, byte align) {
        int color = alpha << 24 | red << 16 | blue << 8 | green;
        this.renderTextOnBlock(renderString, side, orientation, barrelPos, size, posx, posy, color, align);
    }

    protected void renderTextOnBlock(String renderString, ForgeDirection side, ForgeDirection orientation, Coordinates barrelPos, float size, double posx, double posy, int color, byte align) {
        this.renderTextOnBlock(renderString, side, orientation, barrelPos, size, posx, posy, 0.0f, color, align);
    }

    protected void renderTextOnBlock(String renderString, ForgeDirection side, ForgeDirection orientation, Coordinates barrelPos, float size, double posx, double posy, float angle, int color, byte align) {
        if (renderString == null || renderString.equals("")) {
            return;
        }
        int stringWidth = this.func_147498_b().func_78256_a(renderString);
        GL11.glPushMatrix();
        this.alignRendering(side, orientation, barrelPos);
        this.moveRendering(size, posx, posy, -0.01);
        GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2896);
        switch (align) {
            case 0: {
                this.func_147498_b().func_78276_b(renderString, 0, 0, color);
                break;
            }
            case 1: {
                this.func_147498_b().func_78276_b(renderString, -stringWidth / 2, 0, color);
                break;
            }
            case 2: {
                this.func_147498_b().func_78276_b(renderString, -stringWidth, 0, color);
            }
        }
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderStackOnBlock(ItemStack stack, ForgeDirection side, ForgeDirection orientation, Coordinates barrelPos, float size, double posx, double posy) {
        if (stack == null) {
            return;
        }
        GL11.glPushMatrix();
        this.alignRendering(side, orientation, barrelPos);
        this.moveRendering(size, posx, posy, -0.001);
        if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)this.renderBlocks, (TextureManager)this.texManager, (ItemStack)stack, (boolean)true, (float)0.0f, (float)0.0f, (float)0.0f)) {
            this.renderItem.func_77015_a(this.renderFont, this.texManager, stack, 0, 0);
        }
        GL11.glPopMatrix();
    }

    protected void renderIconOnBlock(int index, ForgeDirection side, ForgeDirection orientation, Coordinates barrelPos, float size, double posx, double posy, double zdepth) {
        GL11.glPushMatrix();
        this.alignRendering(side, orientation, barrelPos);
        this.moveRendering(size, posx, posy, zdepth);
        this.texManager.func_110577_a(itemsSheetRes);
        this.drawTexturedModalRect(0, 0, 16 * (index % 16), 16 * (index / 16), 16, 16);
        GL11.glPopMatrix();
    }

    protected void alignRendering(ForgeDirection side, ForgeDirection orientation, Coordinates position) {
        GL11.glTranslated((double)(position.x + 0.5), (double)(position.y + 0.5), (double)(position.z + 0.5));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)this.getRotationYForSide(side, orientation), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.getRotationXForSide(side), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
    }

    protected void moveRendering(float size, double posX, double posY, double posz) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)posz);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)-1.0E-4f);
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        GL11.glScalef((float)size, (float)size, (float)1.0f);
    }

    protected float getRotationYForSide(ForgeDirection side, ForgeDirection orientation) {
        int[] orientRotation = new int[]{0, 0, 0, 2, 3, 1, 0};
        int[] sideRotation = new int[]{orientRotation[orientation.ordinal()], orientRotation[orientation.ordinal()], 0, 2, 3, 1};
        return (float)sideRotation[side.ordinal()] * 90.0f;
    }

    protected float getRotationXForSide(ForgeDirection side) {
        int[] sideRotation = new int[]{1, 3, 0, 0, 0, 0};
        return (float)sideRotation[side.ordinal()] * 90.0f;
    }

    protected void drawTexturedModalRect(int posX, int posY, int textureX, int textureY, int sizeX, int sizeY) {
        float scaleX = 0.00390625f;
        float scaleY = 0.00390625f;
        float zLevel = 0.0f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)(posX + 0), (double)(posY + sizeY), (double)zLevel, (double)((float)(textureX + 0) * scaleX), (double)((float)(textureY + sizeY) * scaleY));
        var9.func_78374_a((double)(posX + sizeX), (double)(posY + sizeY), (double)zLevel, (double)((float)(textureX + sizeX) * scaleX), (double)((float)(textureY + sizeY) * scaleY));
        var9.func_78374_a((double)(posX + sizeX), (double)(posY + 0), (double)zLevel, (double)((float)(textureX + sizeX) * scaleX), (double)((float)(textureY + 0) * scaleY));
        var9.func_78374_a((double)(posX + 0), (double)(posY + 0), (double)zLevel, (double)((float)(textureX + 0) * scaleX), (double)((float)(textureY + 0) * scaleY));
        var9.func_78381_a();
    }

    protected void saveState() {
        this.hasBlending = GL11.glGetBoolean((int)3042);
        this.hasLight = GL11.glGetBoolean((int)2896);
        this.boundTexIndex = GL11.glGetInteger((int)32873);
    }

    protected void loadState() {
        if (this.hasBlending) {
            GL11.glEnable((int)3042);
        } else {
            GL11.glDisable((int)3042);
        }
        if (this.hasLight) {
            GL11.glEnable((int)2896);
        } else {
            GL11.glDisable((int)2896);
        }
        GL11.glBindTexture((int)3553, (int)this.boundTexIndex);
    }
}

