/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels;

import java.util.ArrayList;
import mcp.mobius.betterbarrels.BetterBarrels;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    public static void dropItemInWorld(TileEntity source, EntityPlayer player, ItemStack stack, double speedfactor) {
        int hitOrientation = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        double stackCoordX = 0.0;
        double stackCoordY = 0.0;
        double stackCoordZ = 0.0;
        switch (hitOrientation) {
            case 0: {
                stackCoordX = (double)source.field_145851_c + 0.5;
                stackCoordY = (double)source.field_145848_d + 0.5;
                stackCoordZ = (double)source.field_145849_e - 0.25;
                break;
            }
            case 1: {
                stackCoordX = (double)source.field_145851_c + 1.25;
                stackCoordY = (double)source.field_145848_d + 0.5;
                stackCoordZ = (double)source.field_145849_e + 0.5;
                break;
            }
            case 2: {
                stackCoordX = (double)source.field_145851_c + 0.5;
                stackCoordY = (double)source.field_145848_d + 0.5;
                stackCoordZ = (double)source.field_145849_e + 1.25;
                break;
            }
            case 3: {
                stackCoordX = (double)source.field_145851_c - 0.25;
                stackCoordY = (double)source.field_145848_d + 0.5;
                stackCoordZ = (double)source.field_145849_e + 0.5;
            }
        }
        EntityItem droppedEntity = new EntityItem(source.func_145831_w(), stackCoordX, stackCoordY, stackCoordZ, stack);
        if (player != null) {
            Vec3 motion = Vec3.func_72443_a((double)(player.field_70165_t - stackCoordX), (double)(player.field_70163_u - stackCoordY), (double)(player.field_70161_v - stackCoordZ));
            motion.func_72432_b();
            droppedEntity.field_70159_w = motion.field_72450_a;
            droppedEntity.field_70181_x = motion.field_72448_b;
            droppedEntity.field_70179_y = motion.field_72449_c;
            double offset = 0.25;
            droppedEntity.func_70091_d(motion.field_72450_a * offset, motion.field_72448_b * offset, motion.field_72449_c * offset);
        }
        droppedEntity.field_70159_w *= speedfactor;
        droppedEntity.field_70181_x *= speedfactor;
        droppedEntity.field_70179_y *= speedfactor;
        source.func_145831_w().func_72838_d((Entity)droppedEntity);
    }

    public static class Material {
        public String name;
        public String modDomain;
        public int meta = -1;

        public Material(String in) {
            if (in.contains("Ore.")) {
                this.name = in.split("\\.")[1];
            } else if (in.contains(":")) {
                int splitCh = in.indexOf(58);
                this.modDomain = in.substring(0, splitCh);
                String itemStr = in.substring(splitCh + 1, in.length());
                int metaCh = itemStr.indexOf(58);
                int wildCh = itemStr.indexOf(42);
                if (metaCh >= 0) {
                    this.meta = wildCh == metaCh + 1 ? Short.MAX_VALUE : Integer.parseInt(itemStr.substring(metaCh + 1, itemStr.length()));
                    this.name = itemStr.substring(0, metaCh);
                } else {
                    this.name = itemStr;
                    this.meta = 0;
                }
            } else {
                BetterBarrels.log.severe("Unable to parse input string into oreDict or item:" + in);
            }
        }

        public boolean isOreDict() {
            return this.name != null && this.modDomain == null;
        }

        public ItemStack getStack() {
            ItemStack ret = new ItemStack((Block)Blocks.field_150427_aO);
            if (this.isOreDict()) {
                ArrayList ores = OreDictionary.getOres((String)this.name);
                if (ores.size() > 0) {
                    ret = (ItemStack)ores.get(0);
                }
                BetterBarrels.debug("05 - Looking up [" + this.name + "] and found: " + ret.func_82833_r());
            } else {
                try {
                    ret = new ItemStack((Item)Item.field_150901_e.func_82594_a(this.modDomain + ":" + this.name), 1, this.meta);
                    BetterBarrels.debug("05 - Looking up [" + this.modDomain + ":" + this.name + ":" + this.meta + "] and found: " + ret.func_82833_r());
                }
                catch (Throwable t) {
                    BetterBarrels.log.severe("Error while trying to initialize material with name " + this.modDomain + ":" + this.name + ":" + this.meta);
                }
            }
            return ret;
        }
    }
}

