/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.lexicon.page;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lexicon.page.PageRecipe;

public class PagePetalRecipe<T extends RecipePetals>
extends PageRecipe {
    private static final ResourceLocation petalOverlay = new ResourceLocation("botania:textures/gui/petalOverlay.png");
    List<T> recipes;
    int ticksElapsed = 0;
    int recipeAt = 0;

    public PagePetalRecipe(String unlocalizedName, List<T> recipes) {
        super(unlocalizedName);
        this.recipes = recipes;
    }

    public PagePetalRecipe(String unlocalizedName, T recipe) {
        this(unlocalizedName, Arrays.asList(recipe));
    }

    @Override
    public void onPageAdded(LexiconEntry entry, int index) {
        for (RecipePetals recipe : this.recipes) {
            LexiconRecipeMappings.map(recipe.getOutput(), entry, index);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderRecipe(IGuiLexiconEntry gui, int mx, int my) {
        RecipePetals recipe = (RecipePetals)this.recipes.get(this.recipeAt);
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        this.renderItemAtGridPos(gui, 3, 0, recipe.getOutput(), false);
        this.renderItemAtGridPos(gui, 2, 1, this.getMiddleStack(), false);
        List<Object> inputs = recipe.getInputs();
        int degreePerInput = (int)(360.0f / (float)inputs.size());
        int currentDegree = ConfigHandler.lexiconRotatingItems ? ClientTickHandler.ticksInGame : 0;
        for (Object obj : inputs) {
            Object input = obj;
            if (input instanceof String) {
                input = OreDictionary.getOres((String)((String)input)).get(0);
            }
            this.renderItemAtAngle(gui, currentDegree, (ItemStack)input);
            currentDegree += degreePerInput;
        }
        this.renderManaBar(gui, recipe, mx, my);
        render.func_110577_a(petalOverlay);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)gui).func_73729_b(gui.getLeft(), gui.getTop(), 0, 0, gui.getWidth(), gui.getHeight());
        GL11.glDisable((int)3042);
    }

    ItemStack getMiddleStack() {
        return new ItemStack(ModBlocks.altar);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderManaBar(IGuiLexiconEntry gui, T recipe, int mx, int my) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        if (this.ticksElapsed % 20 == 0) {
            ++this.recipeAt;
            if (this.recipeAt == this.recipes.size()) {
                this.recipeAt = 0;
            }
        }
        ++this.ticksElapsed;
    }
}

