/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemFlugelEye
extends ItemRelic {
    private static final ResourceLocation glowTexture = new ResourceLocation("botania:textures/misc/glow1.png");
    private static final int SEGMENTS = 12;
    private static final MultiversePosition FALLBACK_POSITION = new MultiversePosition(0.0, -1.0, 0.0, 0);
    private static final String TAG_EQUIPPED = "equipped";
    private static final String TAG_ROTATION_BASE = "rotationBase";
    private static final String TAG_WARP_PREFIX = "warp";
    private static final String TAG_POS_X = "posX";
    private static final String TAG_POS_Y = "posY";
    private static final String TAG_POS_Z = "posZ";
    private static final String TAG_DIMENSION = "dim";
    private static final String TAG_FIRST_TICK = "firstTick";
    IIcon[] signs;

    public ItemFlugelEye() {
        super("flugelEye");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        super.func_94581_a(par1IconRegister);
        this.signs = new IIcon[12];
        for (int i = 0; i < 12; ++i) {
            this.signs[i] = IconHelper.forName(par1IconRegister, "sign" + i);
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (ItemFlugelEye.isRightPlayer(player, stack)) {
            int segment = ItemFlugelEye.getSegmentLookedAt(stack, (EntityLivingBase)player);
            MultiversePosition pos = ItemFlugelEye.getWarpPoint(stack, segment);
            if (pos.isValid()) {
                if (pos.dim == world.field_73011_w.field_76574_g && player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).field_71135_a.func_147364_a(pos.x, pos.y, pos.z, player.field_70177_z, player.field_70125_A);
                    world.func_72956_a((Entity)player, "mob.endermen.portal", 1.0f, 1.0f);
                }
            } else {
                ItemFlugelEye.setWarpPoint(stack, segment, player.field_70165_t, player.field_70163_u, player.field_70161_v, world.field_73011_w.field_76574_g);
            }
        }
        return stack;
    }

    public boolean onEntitySwing(EntityLivingBase player, ItemStack stack) {
        int segment;
        MultiversePosition pos;
        if (player.func_70093_af() && player instanceof EntityPlayer && ItemFlugelEye.isRightPlayer((EntityPlayer)player, stack) && (pos = ItemFlugelEye.getWarpPoint(stack, segment = ItemFlugelEye.getSegmentLookedAt(stack, player))).isValid()) {
            ItemFlugelEye.setWarpPoint(stack, segment, 0.0, -1.0, 0.0, 0);
            return true;
        }
        return false;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int pos, boolean equipped) {
        super.func_77663_a(stack, world, entity, pos, equipped);
        boolean eqLastTick = ItemFlugelEye.wasEquipped(stack);
        boolean firstTick = ItemFlugelEye.isFirstTick(stack);
        if (eqLastTick != equipped) {
            ItemFlugelEye.setEquipped(stack, equipped);
        }
        if ((!equipped || firstTick) && entity instanceof EntityLivingBase) {
            int angles = 360;
            int segAngles = angles / 12;
            float shift = segAngles / 2;
            ItemFlugelEye.setRotationBase(stack, ItemFlugelEye.getCheckingAngle((EntityLivingBase)entity) - shift);
            if (firstTick) {
                ItemFlugelEye.tickFirst(stack);
            }
        }
    }

    private static int getSegmentLookedAt(ItemStack stack, EntityLivingBase player) {
        float yaw = ItemFlugelEye.getCheckingAngle(player, ItemFlugelEye.getRotationBase(stack));
        int angles = 360;
        int segAngles = angles / 12;
        for (int seg = 0; seg < 12; ++seg) {
            float calcAngle = (float)seg * (float)segAngles;
            if (!(yaw >= calcAngle) || !(yaw < calcAngle + (float)segAngles)) continue;
            return seg;
        }
        return -1;
    }

    private static float getCheckingAngle(EntityLivingBase player) {
        return ItemFlugelEye.getCheckingAngle(player, 0.0f);
    }

    private static float getCheckingAngle(EntityLivingBase player, float base) {
        float angle;
        float yaw = MathHelper.func_76142_g((float)player.field_70177_z) + 90.0f;
        int angles = 360;
        int segAngles = angles / 12;
        float shift = segAngles / 2;
        if (yaw < 0.0f) {
            yaw = 180.0f + (180.0f + yaw);
        }
        if ((angle = 360.0f - (yaw -= 360.0f - base) + shift) < 0.0f) {
            angle = 360.0f + angle;
        }
        return angle;
    }

    public static boolean isFirstTick(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_FIRST_TICK, true);
    }

    public static void tickFirst(ItemStack stack) {
        ItemNBTHelper.setBoolean(stack, TAG_FIRST_TICK, false);
    }

    public static boolean wasEquipped(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_EQUIPPED, false);
    }

    public static void setEquipped(ItemStack stack, boolean equipped) {
        ItemNBTHelper.setBoolean(stack, TAG_EQUIPPED, equipped);
    }

    public static float getRotationBase(ItemStack stack) {
        return ItemNBTHelper.getFloat(stack, TAG_ROTATION_BASE, 0.0f);
    }

    public static void setRotationBase(ItemStack stack, float rotation) {
        ItemNBTHelper.setFloat(stack, TAG_ROTATION_BASE, rotation);
    }

    public static void setWarpPoint(ItemStack stack, int warp, double x, double y, double z, int dim) {
        NBTTagCompound cmp = new NBTTagCompound();
        cmp.func_74780_a(TAG_POS_X, x);
        cmp.func_74780_a(TAG_POS_Y, y);
        cmp.func_74780_a(TAG_POS_Z, z);
        cmp.func_74768_a(TAG_DIMENSION, dim);
        ItemNBTHelper.setCompound(stack, TAG_WARP_PREFIX + warp, cmp);
    }

    public static MultiversePosition getWarpPoint(ItemStack stack, int warp) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound(stack, TAG_WARP_PREFIX + warp, true);
        if (cmp == null) {
            return FALLBACK_POSITION;
        }
        double x = cmp.func_74769_h(TAG_POS_X);
        double y = cmp.func_74769_h(TAG_POS_Y);
        double z = cmp.func_74769_h(TAG_POS_Z);
        int dim = cmp.func_74762_e(TAG_DIMENSION);
        return new MultiversePosition(x, y, z, dim);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b() == this) {
            this.render(stack, (EntityPlayer)player, event.partialTicks);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(ItemStack stack, EntityPlayer player, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tess = Tessellator.field_78398_a;
        Tessellator.renderingWorldRenderer = false;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float alpha = ((float)Math.sin(((float)ClientTickHandler.ticksInGame + partialTicks) * 0.2f) * 0.5f + 0.5f) * 0.4f + 0.3f;
        double posX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double posY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double posZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        GL11.glTranslated((double)(posX - RenderManager.field_78725_b), (double)(posY - RenderManager.field_78726_c), (double)(posZ - RenderManager.field_78723_d));
        float base = ItemFlugelEye.getRotationBase(stack);
        int angles = 360;
        int segAngles = angles / 12;
        float shift = base - (float)(segAngles / 2);
        float u = 1.0f;
        float v = 0.25f;
        float s = 3.0f;
        float m = 0.8f;
        float y = v * s * 2.0f;
        float y0 = 0.0f;
        int segmentLookedAt = ItemFlugelEye.getSegmentLookedAt(stack, (EntityLivingBase)player);
        for (int seg = 0; seg < 12; ++seg) {
            boolean inside = false;
            float rotationAngle = ((float)seg + 0.5f) * (float)segAngles + shift;
            if (segmentLookedAt == seg) {
                inside = true;
            }
            GL11.glPushMatrix();
            GL11.glRotatef((float)rotationAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)(s * m), (float)-0.75f, (float)0.0f);
            mc.field_71446_o.func_110577_a(TextureMap.field_110576_c);
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.5f);
            IIcon icon = this.signs[seg];
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(ItemFlugelEye.getWarpPoint(stack, seg).isValid() ? 1.0f : 0.2f));
            float f = icon.func_94209_e();
            float f1 = icon.func_94212_f();
            float f2 = icon.func_94206_g();
            float f3 = icon.func_94210_h();
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)f1, (float)f2, (float)f, (float)f3, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float a = alpha;
            if (inside) {
                a += 0.3f;
                y0 = -y;
            }
            if (seg % 2 == 0) {
                GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)a);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            }
            mc.field_71446_o.func_110577_a(glowTexture);
            tess.func_78382_b();
            for (int i = 0; i < segAngles; ++i) {
                float ang = (float)(i + seg * segAngles) + shift;
                double xp = Math.cos((double)ang * Math.PI / 180.0) * (double)s;
                double zp = Math.sin((double)ang * Math.PI / 180.0) * (double)s;
                tess.func_78374_a(xp * (double)m, (double)y, zp * (double)m, (double)u, (double)v);
                tess.func_78374_a(xp, (double)y0, zp, (double)u, 0.0);
                xp = Math.cos((double)(ang + 1.0f) * Math.PI / 180.0) * (double)s;
                zp = Math.sin((double)(ang + 1.0f) * Math.PI / 180.0) * (double)s;
                tess.func_78374_a(xp, (double)y0, zp, 0.0, 0.0);
                tess.func_78374_a(xp * (double)m, (double)y, zp * (double)m, 0.0, (double)v);
            }
            y0 = 0.0f;
            tess.func_78381_a();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderHUD(ScaledResolution resolution, EntityPlayer player, ItemStack stack) {
        Minecraft.func_71410_x();
        int slot = ItemFlugelEye.getSegmentLookedAt(stack, (EntityLivingBase)player);
        MultiversePosition pos = ItemFlugelEye.getWarpPoint(stack, slot);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String s = StatCollector.func_74838_a((String)("botania.sign" + slot));
        font.func_78261_a(s, resolution.func_78326_a() / 2 - font.func_78256_a(s) / 2, resolution.func_78328_b() / 2 - 55, 16765961);
        if (pos.isValid()) {
            int dist = (int)vazkii.botania.common.core.helper.MathHelper.pointDistanceSpace(pos.x, pos.y, pos.z, player.field_70165_t, player.field_70163_u - 1.6, player.field_70161_v);
            s = dist == 1 ? StatCollector.func_74838_a((String)"botaniamisc.blockAway") : String.format(StatCollector.func_74838_a((String)"botaniamisc.blocksAway"), dist);
            font.func_78261_a(s, resolution.func_78326_a() / 2 - font.func_78256_a(s) / 2, resolution.func_78328_b() / 2 - 40, 0x9999FF);
            s = StatCollector.func_74838_a((String)"botaniamisc.clickToTeleport");
            font.func_78261_a(s, resolution.func_78326_a() / 2 - font.func_78256_a(s) / 2, resolution.func_78328_b() / 2 - 30, 0xFFFFFF);
            s = StatCollector.func_74838_a((String)"botaniamisc.clickToRemoveWarp");
            font.func_78261_a(s, resolution.func_78326_a() / 2 - font.func_78256_a(s) / 2, resolution.func_78328_b() / 2 - 20, 0xFFFFFF);
        } else {
            s = StatCollector.func_74838_a((String)"botaniamisc.unboundWarp");
            font.func_78261_a(s, resolution.func_78326_a() / 2 - font.func_78256_a(s) / 2, resolution.func_78328_b() / 2 - 40, 0xFFFFFF);
            s = StatCollector.func_74838_a((String)"botaniamisc.clickToAddWarp");
            font.func_78261_a(s, resolution.func_78326_a() / 2 - font.func_78256_a(s) / 2, resolution.func_78328_b() / 2 - 30, 0xFFFFFF);
        }
    }

    private static class MultiversePosition {
        public final double x;
        public final double y;
        public final double z;
        public final int dim;

        public MultiversePosition(double x, double y, double z, int dim) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dim = dim;
        }

        boolean isValid() {
            return this.y > 0.0;
        }
    }
}

