/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import cpw.mods.fml.common.FMLLog;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.nodes.INode;
import thaumcraft.common.items.baubles.ItemAmuletVis;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.tiles.TileAlembic;
import thaumcraft.common.tiles.TileCentrifuge;
import thaumcraft.common.tiles.TileJarFillable;
import thaumcraft.common.tiles.TileTubeBuffer;
import thaumcraft.common.tiles.TileWandPedestal;
import tuhljin.automagy.api.essentia.IAspectContainerWithMax;
import tuhljin.automagy.lib.NeighborNotifier;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.tiles.ModTileEntityWithInventory;
import tuhljin.automagy.tiles.TileEntityEssentiaLocus;
import tuhljin.automagy.tiles.TileEntityRemoteComparator;

public class TileEntityVisReader
extends ModTileEntityWithInventory
implements IAspectContainer {
    protected final int COOLDOWN_TIME = 4;
    public static final int NUM_CONFIGURATIONS = 4;
    public static final int ALL_DIR = 6;
    public static final int modeDISABLED = 0;
    public static final int modeTOTAL = 1;
    public static final int modeANYHIGH = 2;
    public static final int modeANYLOW = 3;
    public static final int modeASPECTCOUNT = 4;
    public int targetX;
    public int targetY = -1;
    public int targetZ;
    public int[] modes = new int[]{1, 0, 0, 0};
    public int[] capacities = new int[4];
    public int[] outputDirs = new int[]{6, 6, 6, 6};
    public boolean[] inverseSignals = new boolean[4];
    protected int[] redstoneSignalStrength = new int[5];
    private boolean antiloopIsChecking = false;
    protected int cooldown = 0;
    private String lastAspects = "";

    public TileEntityVisReader() {
        super("blockVisReader", 4, false);
        this.accessibleSlots = new int[0];
        this.notifyOnInventoryChanged = true;
    }

    public boolean hasActiveRedstoneSignal() {
        for (int i = 0; i < 5; ++i) {
            if (this.redstoneSignalStrength[i] <= 0) continue;
            return true;
        }
        return false;
    }

    public int getRedstoneSignalStrength(int side) {
        if (side == 0) {
            return this.redstoneSignalStrength[4];
        }
        return (side = TjUtil.getSWNESide(side)) == -1 ? 0 : this.redstoneSignalStrength[side];
    }

    protected boolean setRedstoneSignalStrength(int side, int strength) {
        if ((side = side == 0 ? 4 : TjUtil.getSWNESide(side)) != -1 && this.redstoneSignalStrength[side] != strength) {
            this.redstoneSignalStrength[side] = strength;
            return true;
        }
        return false;
    }

    public void findNewTarget(boolean neighborMayBeRemoteComparator) {
        int x = this.field_145851_c;
        int y = this.field_145848_d + 1;
        int z = this.field_145849_e;
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof TileEntityRemoteComparator) {
            if (!neighborMayBeRemoteComparator) {
                return;
            }
            WorldSpecificCoordinates coord = ((TileEntityRemoteComparator)te).getLinkLocation();
            if (((TileEntityRemoteComparator)te).coordinatesAreInRange(coord) && coord != null) {
                if (coord.x != this.targetX || coord.y != this.targetY || coord.z != this.targetZ) {
                    this.targetX = coord.x;
                    this.targetY = coord.y;
                    this.targetZ = coord.z;
                    this.lastAspects = "";
                    this.calculateRedstoneSignalStrength();
                    this.func_70296_d();
                }
                return;
            }
        } else if (TileEntityEssentiaLocus.blockIsWater((IBlockAccess)this.field_145850_b, x, y, z, false)) {
            ForgeDirection[] dirs;
            block0: for (ForgeDirection dir : dirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST}) {
                int x2 = x + dir.offsetX;
                int y2 = y + 2;
                int z2 = z + dir.offsetZ;
                if (this.field_145850_b.func_147438_o(x2, y2, z2) instanceof TileEntityEssentiaLocus) {
                    x = x2;
                    y = y2;
                    z = z2;
                    break;
                }
                for (ForgeDirection subdir : dirs) {
                    int x3 = x2 + subdir.offsetX;
                    int z3 = z2 + subdir.offsetZ;
                    if (!(this.field_145850_b.func_147438_o(x3, y2, z3) instanceof TileEntityEssentiaLocus)) continue;
                    x = x3;
                    y = y2;
                    z = z3;
                    break block0;
                }
            }
        }
        if (x != this.targetX || y != this.targetY || z != this.targetZ) {
            this.targetX = x;
            this.targetY = y;
            this.targetZ = z;
            this.lastAspects = "";
            this.calculateRedstoneSignalStrength();
            this.func_70296_d();
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.cooldown = 4;
        this.calculateRedstoneSignalStrength();
    }

    private void calculateRedstoneSignalStrength() {
        AspectList aspects = this.getAspects();
        boolean changed = false;
        if (aspects != null) {
            int total = 0;
            int highestAmt = 0;
            int lowestAmt = Integer.MAX_VALUE;
            StringBuilder strAspects = new StringBuilder(",");
            for (Aspect a : aspects.getAspects()) {
                if (a == null) continue;
                int amt = aspects.getAmount(a);
                total += amt;
                highestAmt = Math.max(amt, highestAmt);
                lowestAmt = Math.min(amt, lowestAmt);
                strAspects.append(a.getTag() + ":" + amt + ",");
            }
            String newAspects = strAspects.toString();
            if (this.lastAspects.equals(newAspects)) {
                return;
            }
            this.lastAspects = newAspects;
            if (lowestAmt > highestAmt) {
                lowestAmt = highestAmt;
            }
            int detectedCapacity = -1;
            int detectedIndividualCapacity = 0;
            Aspect detectedIndividualAspectHighest = null;
            Aspect detectedIndividualAspectLowest = null;
            AspectList aspectsKnownCapacity = null;
            int[] strengths = new int[]{0, 0, 0, 0, 0, 0};
            for (int i = 0; i < 4; ++i) {
                int side;
                int strength;
                if (this.modes[i] == 0) continue;
                if (this.modes[i] == 4) {
                    strength = aspects.size();
                    if (strength > 15) {
                        if (this.inverseSignals[i]) {
                            strength = 15;
                        } else if (strength > 99) {
                            strength = 99;
                        }
                    }
                } else {
                    int capacity = this.capacities[i];
                    int individualCapacity = -1;
                    if (capacity < 1) {
                        if (detectedCapacity == -1) {
                            IAspectContainer target = this.getUltimateTarget();
                            if (target != null) {
                                detectedCapacity = 64;
                                if (target instanceof TileWandPedestal) {
                                    detectedCapacity = 25;
                                    ItemStack stack = ThaumcraftExtension.getStackInRechargePedestal((TileEntity)((TileWandPedestal)target));
                                    if (stack != null) {
                                        Item item = stack.func_77973_b();
                                        if (item instanceof ItemWandCasting) {
                                            ItemWandCasting wand = (ItemWandCasting)item;
                                            detectedIndividualCapacity = wand.getMaxVis(stack) / 100;
                                            detectedCapacity = detectedIndividualCapacity * 6;
                                        } else if (item instanceof ItemAmuletVis) {
                                            ItemAmuletVis amulet = (ItemAmuletVis)item;
                                            detectedIndividualCapacity = amulet.getMaxVis(stack) / 100;
                                            detectedCapacity = detectedIndividualCapacity * 6;
                                        }
                                    }
                                } else if (target instanceof INode || target instanceof IAspectContainerWithMax) {
                                    aspectsKnownCapacity = target instanceof INode ? ((INode)target).getAspectsBase() : ((IAspectContainerWithMax)target).getAspectsBase();
                                    if (aspectsKnownCapacity != null) {
                                        int count = 0;
                                        float highest = 0.0f;
                                        float lowest = Float.MAX_VALUE;
                                        for (Aspect a : aspectsKnownCapacity.getAspects()) {
                                            int amt;
                                            if (a == null || !aspects.aspects.containsKey(a) || (amt = aspectsKnownCapacity.getAmount(a)) <= 0) continue;
                                            count += amt;
                                            float f = (float)aspects.getAmount(a) / (float)amt;
                                            if (f > highest) {
                                                highest = f;
                                                detectedIndividualAspectHighest = a;
                                            }
                                            if (!(f < lowest)) continue;
                                            lowest = f;
                                            detectedIndividualAspectLowest = a;
                                        }
                                        detectedCapacity = count;
                                    }
                                } else {
                                    if (target instanceof TileJarFillable) {
                                        detectedCapacity = ((TileJarFillable)target).maxAmount;
                                    } else if (target instanceof TileAlembic) {
                                        detectedCapacity = 32;
                                    } else if (target instanceof TileTubeBuffer) {
                                        detectedCapacity = 8;
                                    } else if (target instanceof TileCentrifuge) {
                                        detectedCapacity = 1;
                                    } else if (ThaumcraftExtension.objectIsEssentiaReservoir(target)) {
                                        detectedCapacity = 256;
                                    }
                                    detectedIndividualCapacity = detectedCapacity;
                                }
                            } else {
                                detectedCapacity = 0;
                            }
                        }
                        capacity = detectedCapacity;
                        individualCapacity = detectedIndividualCapacity;
                    }
                    if (individualCapacity < 1) {
                        individualCapacity = capacity;
                    }
                    if (this.inventorySlots[i] != null) {
                        AspectList stackAspects = ThaumcraftExtension.getAspectsFromItem(this.inventorySlots[i]);
                        if (stackAspects == null) {
                            strength = 0;
                        } else {
                            Aspect a = stackAspects.getAspects()[0];
                            int aspectCapacity = this.capacities[i] < 1 && aspectsKnownCapacity != null ? aspectsKnownCapacity.getAmount(a) : (this.modes[i] == 1 ? capacity : individualCapacity);
                            strength = RedstoneCalc.getRedstoneSignalStrengthFromValues(aspects.getAmount(a), aspectCapacity);
                        }
                    } else {
                        strength = this.modes[i] == 1 ? RedstoneCalc.getRedstoneSignalStrengthFromValues(total, capacity) : (this.modes[i] == 2 ? (detectedIndividualAspectHighest == null ? RedstoneCalc.getRedstoneSignalStrengthFromValues(highestAmt, individualCapacity) : RedstoneCalc.getRedstoneSignalStrengthFromValues(aspects.getAmount(detectedIndividualAspectHighest), aspectsKnownCapacity.getAmount(detectedIndividualAspectHighest))) : (this.modes[i] == 3 ? (detectedIndividualAspectLowest == null ? RedstoneCalc.getRedstoneSignalStrengthFromValues(lowestAmt, individualCapacity) : RedstoneCalc.getRedstoneSignalStrengthFromValues(aspects.getAmount(detectedIndividualAspectLowest), aspectsKnownCapacity.getAmount(detectedIndividualAspectLowest))) : 0));
                    }
                }
                if (this.inverseSignals[i]) {
                    strength = 15 - strength;
                }
                if ((side = this.outputDirs[i]) == 6) {
                    strengths[0] = Math.max(strengths[0], strength);
                    strengths[2] = Math.max(strengths[2], strength);
                    strengths[3] = Math.max(strengths[3], strength);
                    strengths[4] = Math.max(strengths[4], strength);
                    strengths[5] = Math.max(strengths[5], strength);
                    continue;
                }
                strengths[side] = Math.max(strengths[side], strength);
            }
            for (int side = 0; side < strengths.length; ++side) {
                if (!this.setRedstoneSignalStrength(side, strengths[side])) continue;
                changed = true;
            }
        } else {
            if (this.setRedstoneSignalStrength(0, 0)) {
                changed = true;
            }
            if (this.setRedstoneSignalStrength(2, 0)) {
                changed = true;
            }
            if (this.setRedstoneSignalStrength(3, 0)) {
                changed = true;
            }
            if (this.setRedstoneSignalStrength(4, 0)) {
                changed = true;
            }
            if (this.setRedstoneSignalStrength(5, 0)) {
                changed = true;
            }
            this.lastAspects = "";
        }
        if (changed) {
            this.func_70296_d();
            NeighborNotifier.notifyBlocksOfExtendedNeighborChange(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public IAspectContainer getUltimateTarget() {
        if (this.antiloopIsChecking) {
            return null;
        }
        IAspectContainer target = this.getTarget();
        if (target instanceof TileEntityVisReader) {
            this.antiloopIsChecking = true;
            target = ((TileEntityVisReader)target).getUltimateTarget();
            this.antiloopIsChecking = false;
        }
        return target;
    }

    public IAspectContainer getTarget() {
        TileEntity target = this.field_145850_b.func_147438_o(this.targetX, this.targetY, this.targetZ);
        if (target instanceof IAspectContainer) {
            return (IAspectContainer)target;
        }
        return null;
    }

    public void receiveGUIMessage(int configNum, int type, int data) {
        if (configNum < 0 || configNum >= 4) {
            FMLLog.warning((String)("[Automagy] TileEntityVisReader received invalid packet data. Ignoring. (configNum=" + configNum + ")"), (Object[])new Object[0]);
            return;
        }
        switch (type) {
            case 0: {
                this.modes[configNum] = data;
                break;
            }
            case 1: {
                this.capacities[configNum] = data;
                break;
            }
            case 2: {
                this.outputDirs[configNum] = data;
                break;
            }
            case 3: {
                this.inverseSignals[configNum] = data == 1;
                break;
            }
            default: {
                FMLLog.warning((String)("[Automagy] TileEntityVisReader received invalid packet data. Ignoring. (type=" + type + ")"), (Object[])new Object[0]);
                return;
            }
        }
        this.lastAspects = "";
        this.markDirty(false);
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack prevStack) {
        this.lastAspects = "";
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (ThaumcraftExtension.itemIsJarLabel(stack)) {
            return ThaumcraftExtension.getAspectsFromItem(stack) != null;
        }
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public AspectList getAspects() {
        if (this.antiloopIsChecking) {
            return null;
        }
        IAspectContainer target = this.getTarget();
        if (target != null) {
            this.antiloopIsChecking = true;
            AspectList aspects = target.getAspects();
            this.antiloopIsChecking = false;
            return aspects;
        }
        return null;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    public int addToContainer(Aspect tag, int amount) {
        return amount;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    public int containerContains(Aspect tag) {
        return 0;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side > 1 && side < 6) {
            return new int[]{side - 2};
        }
        return this.accessibleSlots;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.targetX = nbttagcompound.func_74762_e("targetX");
        this.targetY = nbttagcompound.func_74762_e("targetY");
        this.targetZ = nbttagcompound.func_74762_e("targetZ");
        this.redstoneSignalStrength = TileEntityVisReader.getIntArrayFromNbtOrDefault(nbttagcompound, "strength", 0, 5);
        this.modes = TileEntityVisReader.getIntArrayFromNbtOrDefault(nbttagcompound, "modes", 1, 4);
        this.capacities = TileEntityVisReader.getIntArrayFromNbtOrDefault(nbttagcompound, "capacity", 0, 4);
        this.outputDirs = TileEntityVisReader.getIntArrayFromNbtOrDefault(nbttagcompound, "outputDir", 6, 4);
        this.inverseSignals = TileEntityVisReader.getBooleanArrayFromNbtOrDefault(nbttagcompound, "inverse", false, 4);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.func_74768_a("targetX", this.targetX);
        nbttagcompound.func_74768_a("targetY", this.targetY);
        nbttagcompound.func_74768_a("targetZ", this.targetZ);
        nbttagcompound.func_74783_a("strength", this.redstoneSignalStrength);
        nbttagcompound.func_74783_a("modes", this.modes);
        nbttagcompound.func_74783_a("capacity", this.capacities);
        nbttagcompound.func_74783_a("outputDir", this.outputDirs);
        TileEntityVisReader.setBooleanArrayInNbt(nbttagcompound, "inverse", this.inverseSignals);
    }
}

