/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.visnet.VisNetHandler;
import thaumcraft.common.Thaumcraft;
import tuhljin.automagy.api.AutomagyAPI;
import tuhljin.automagy.api.inventarium.IInventariumContentsProvider;
import tuhljin.automagy.codechicken.lib.math.MathHelper;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.gui.GUIScribe;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.FilteringItemList;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.inventory.MappedItemsOrderedByTimeAdded;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.network.MessageGUIInventariumBookPref;
import tuhljin.automagy.tiles.IInventariumBook;
import tuhljin.automagy.tiles.IReceivesItemListPacket;
import tuhljin.automagy.tiles.ModTileEntity;
import tuhljin.automagy.tiles.TileEntityInventarium;
import tuhljin.automagy.tiles.TileEntityScribePointer;

public class TileEntityUnseenScribe
extends ModTileEntity
implements IReceivesItemListPacket,
IInventariumBook {
    public static int RANGE = 3;
    public int linkX;
    public int linkY = -1;
    public int linkZ;
    public static double QUILL_IDLE_MAXY = 0.1;
    public static double QUILL_IDLE_MINY = 0.05;
    public static double QUILL_POWERED_MAXY = 0.2;
    public static double QUILL_POWERED_MINY = 0.15;
    public static double QUILL_POWERED_HORIZ = -0.5;
    public static double BOOK_MAXY = 0.01;
    public double quillY;
    public double quillHoriz;
    public double quillR;
    private boolean quillGoingUp = false;
    public boolean someSlotsOmitted = false;
    public double bookY = BOOK_MAXY / 2.0;
    private boolean bookGoingUp = true;
    public float page;
    protected int poweredTime = 0;
    private FilteringItemList itemList = null;
    public HashSet<String> localViewUsers = new HashSet();
    public HashSet<String> sortByNameUsers = new HashSet();

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.itemList = null;
            int prevPower = this.poweredTime;
            if (this.poweredTime > 0) {
                --this.poweredTime;
            }
            if (this.poweredTime < 1) {
                int amt;
                int n = amt = this.linkY != -1 ? VisNetHandler.drainVis((World)this.field_145850_b, (int)this.field_145851_c, (int)(this.field_145848_d + 1), (int)this.field_145849_e, (Aspect)Aspect.ORDER, (int)10) : 0;
                if (amt > 0) {
                    this.poweredTime = amt * 2;
                    if (prevPower < 1) {
                        this.markDirty(true);
                    } else {
                        this.markDirty(false);
                    }
                } else if (prevPower > 0) {
                    this.markDirty(true);
                }
            }
        } else {
            if (this.poweredTime < 1) {
                if (this.quillHoriz < 0.0) {
                    this.quillHoriz = MathHelper.approachLinear(this.quillHoriz, 0.0, 0.01);
                    if (this.quillY >= QUILL_IDLE_MAXY) {
                        this.quillY = MathHelper.approachExp(this.quillY, QUILL_IDLE_MAXY, 0.1);
                    }
                } else if (this.quillGoingUp) {
                    if (this.quillY >= QUILL_IDLE_MAXY) {
                        this.quillGoingUp = false;
                    } else {
                        this.quillY = MathHelper.retreatExp(this.quillY, QUILL_IDLE_MAXY, QUILL_IDLE_MINY, 0.01, 0.025);
                    }
                } else if (this.quillY <= QUILL_IDLE_MINY) {
                    if (this.poweredTime > 0) {
                        this.quillGoingUp = true;
                    } else {
                        this.quillY = MathHelper.retreatExp(this.quillY, 0.0, QUILL_IDLE_MINY, 0.02, 0.025);
                    }
                } else {
                    this.quillY = MathHelper.retreatExp(this.quillY, QUILL_IDLE_MINY, QUILL_IDLE_MAXY, 0.01, 0.025);
                }
                if (this.quillR < 0.0) {
                    this.quillR = MathHelper.approachLinear(this.quillR, 0.0, 1.0);
                }
            } else if (this.quillHoriz > QUILL_POWERED_HORIZ) {
                if (this.quillY < QUILL_POWERED_MINY) {
                    this.quillGoingUp = true;
                    this.quillY = MathHelper.approachLinear(this.quillY, QUILL_POWERED_MINY, 0.01);
                }
                this.quillHoriz = MathHelper.approachLinear(this.quillHoriz, QUILL_POWERED_HORIZ, 0.01);
                if (this.quillY >= QUILL_IDLE_MINY * 0.5 && this.quillR > -20.0) {
                    this.quillR = MathHelper.approachLinear(this.quillR, -20.0, 0.3);
                }
            } else if (this.quillGoingUp) {
                if (this.quillY >= QUILL_POWERED_MAXY) {
                    this.quillGoingUp = false;
                } else {
                    this.quillY = MathHelper.retreatExp(this.quillY, QUILL_POWERED_MAXY, QUILL_POWERED_MINY, 0.01, 0.025);
                }
            } else if (this.quillY <= QUILL_POWERED_MINY) {
                if (this.poweredTime > 0) {
                    this.quillGoingUp = true;
                } else {
                    this.quillY = MathHelper.retreatExp(this.quillY, 0.0, QUILL_POWERED_MINY, 0.02, 0.025);
                }
            } else {
                this.quillY = MathHelper.retreatExp(this.quillY, QUILL_POWERED_MINY, QUILL_POWERED_MAXY, 0.01, 0.025);
            }
            if (this.bookGoingUp) {
                if (this.bookY >= BOOK_MAXY) {
                    this.bookGoingUp = false;
                } else {
                    this.bookY = MathHelper.retreatExp(this.bookY, BOOK_MAXY, 0.0, 0.005, 0.025);
                }
            } else if (this.bookY <= 0.0) {
                this.bookGoingUp = true;
            } else {
                this.bookY = MathHelper.retreatExp(this.bookY, 0.0, BOOK_MAXY, 0.005, 0.025);
            }
            if (this.page > 0.0f) {
                this.page += 0.1f;
                if (this.page > 1.0f) {
                    this.page = this.poweredTime > 0 && this.field_145850_b.field_73012_v.nextInt(4) == 0 ? 0.1f : 0.0f;
                }
            } else if (this.poweredTime >= 1) {
                if (this.field_145850_b.field_73012_v.nextInt(100) == 0) {
                    this.page = 0.1f;
                    if (this.field_145850_b.field_73012_v.nextInt(8) == 0) {
                        this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5, "thaumcraft:page", 0.1f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                    }
                } else if (this.field_145850_b.field_73012_v.nextInt(600) == 0) {
                    this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5, "thaumcraft:write", 0.1f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                }
            }
            if (this.someSlotsOmitted && this.poweredTime > 0 && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                int color = 5;
                Thaumcraft.proxy.sparkle((float)this.field_145851_c + 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.6f, (float)this.field_145848_d + 1.2f, (float)this.field_145849_e + 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.6f, 1.0f, color, -0.1f);
            }
        }
    }

    public SelectedContainers getSelectedContainers() {
        ForgeDirection dir;
        TileEntity teAbove = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (teAbove instanceof TileEntityScribePointer) {
            return ((TileEntityScribePointer)teAbove).getSelectedContainers();
        }
        switch (this.func_145832_p()) {
            case 0: {
                dir = ForgeDirection.NORTH;
                break;
            }
            case 1: {
                dir = ForgeDirection.EAST;
                break;
            }
            case 2: {
                dir = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                dir = ForgeDirection.WEST;
                break;
            }
            default: {
                return null;
            }
        }
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        int d = RANGE;
        SelectedContainers sc = new SelectedContainers();
        do {
            if (!sc.add(this.field_145850_b, x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ)) continue;
            return sc;
        } while (--d > 0);
        return null;
    }

    public ArrayList<BlockCoord> getInventoryCoords() {
        if (this.poweredTime < 1) {
            return null;
        }
        SelectedContainers sc = this.getSelectedContainers();
        if (sc == null || sc.size() < 1) {
            return null;
        }
        ArrayList<BlockCoord> bcs = new ArrayList<BlockCoord>();
        for (int ox = -RANGE; ox <= RANGE; ++ox) {
            for (int oy = -RANGE; oy <= RANGE; ++oy) {
                for (int oz = -RANGE; oz <= RANGE; ++oz) {
                    int x = this.field_145851_c + ox;
                    int y = this.field_145848_d + oy;
                    int z = this.field_145849_e + oz;
                    if (!sc.containsBlockAt(this.field_145850_b, x, y, z)) continue;
                    bcs.add(new BlockCoord(x, y, z));
                }
            }
        }
        return bcs.size() > 0 ? bcs : null;
    }

    public void breakLink() {
        this.linkY = -1;
        this.quillGoingUp = false;
        this.flagSlotsOmitted(false);
    }

    @Override
    public FilteringItemList getLocalItemList() {
        if (this.itemList == null) {
            ++TileEntityInventarium.getContentsIdentifier;
            if (this.field_145850_b.field_72995_K) {
                return new FilteringItemList();
            }
            ArrayList<TileEntityInventarium.PairedContentsProvider> invs = new ArrayList<TileEntityInventarium.PairedContentsProvider>();
            ArrayList<BlockCoord> bcs = this.getInventoryCoords();
            if (bcs != null) {
                for (BlockCoord bc : bcs) {
                    TileEntity te2 = this.field_145850_b.func_147438_o(bc.x, bc.y, bc.z);
                    IInventariumContentsProvider provider = TileEntityInventarium.getContentsProvider(te2);
                    if (provider == null || provider.getSlotCount(te2, TileEntityInventarium.getContentsIdentifier) <= 0) continue;
                    invs.add(new TileEntityInventarium.PairedContentsProvider(provider, te2));
                }
                this.itemList = new FilteringItemList().populateFromInventariumContentsProviders(invs, TileEntityInventarium.getContentsIdentifier);
            }
        }
        return this.itemList;
    }

    @Override
    public FilteringItemList getInventariumItemList() {
        TileEntity te = this.field_145850_b.func_147438_o(this.linkX, this.linkY, this.linkZ);
        if (te instanceof TileEntityInventarium) {
            return ((TileEntityInventarium)te).getItemList();
        }
        return null;
    }

    @Override
    public MappedItemsOrderedByTimeAdded getInventariumRequestedItemList() {
        TileEntity te = this.field_145850_b.func_147438_o(this.linkX, this.linkY, this.linkZ);
        if (te instanceof TileEntityInventarium) {
            return ((TileEntityInventarium)te).getRequestedItems();
        }
        return null;
    }

    @Override
    public WorldSpecificCoordinates getLinkCoord() {
        return new WorldSpecificCoordinates(this.field_145850_b, this.linkX, this.linkY, this.linkZ);
    }

    @Override
    public boolean hasLocalItems() {
        return true;
    }

    @Override
    public boolean canRequestItems() {
        return false;
    }

    @Override
    public void receiveItemListPacket(ArrayList<ItemStack> list, boolean partial) {
        if (!partial || this.itemList == null) {
            this.itemList = new FilteringItemList(list, false);
        } else {
            for (ItemStack stack : list) {
                this.itemList.set(new HashableItemWithoutSize(stack), stack.field_77994_a > 0 ? stack.field_77994_a : 0);
            }
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui instanceof GUIScribe) {
                ((GUIScribe)gui).setStacks(this.getLocalItemList(), true);
            }
        }
    }

    @Override
    public boolean isInventariumLoaded() {
        return this.linkY != -1 && TjUtil.isChunkLoaded(this.field_145850_b, this.linkX, this.linkZ);
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.linkY == -1 || this.poweredTime < 1) {
            return false;
        }
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void flagSlotsOmitted(boolean b) {
        this.someSlotsOmitted = b;
        this.func_70296_d();
    }

    @Override
    public void setPlayerLocalViewPreference(EntityPlayer player, boolean local) {
        if (this.field_145850_b.field_72995_K) {
            MessageGUIInventariumBookPref.sendToServer(0, local);
        } else {
            String name = player.func_70005_c_();
            if (local) {
                if (name != "Rcon") {
                    this.localViewUsers.add(name);
                }
            } else if (this.localViewUsers.contains(name)) {
                this.localViewUsers.remove(name);
            }
            this.func_70296_d();
        }
    }

    @Override
    public void setPlayerSortingPreference(EntityPlayer player, boolean byName) {
        if (this.field_145850_b.field_72995_K) {
            MessageGUIInventariumBookPref.sendToServer(1, byName);
        } else {
            String name = player.func_70005_c_();
            if (byName) {
                if (name != "Rcon") {
                    this.sortByNameUsers.add(name);
                }
            } else if (this.sortByNameUsers.contains(name)) {
                this.sortByNameUsers.remove(name);
            }
            this.func_70296_d();
        }
    }

    @Override
    public boolean doesPlayerPreferLocalView(EntityPlayer player) {
        return this.localViewUsers.contains(player.func_70005_c_());
    }

    @Override
    public boolean doesPlayerPreferSortByName(EntityPlayer player) {
        return this.sortByNameUsers.contains(player.func_70005_c_());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
        return bb;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound tagList;
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.func_74768_a("poweredTime", this.poweredTime);
        nbttagcompound.func_74768_a("linkX", this.linkX);
        nbttagcompound.func_74768_a("linkY", this.linkY);
        nbttagcompound.func_74768_a("linkZ", this.linkZ);
        nbttagcompound.func_74757_a("someSlotsOmitted", this.someSlotsOmitted);
        NBTTagList nbttaglist = new NBTTagList();
        for (String name : this.localViewUsers) {
            if (name == null || name.isEmpty()) continue;
            tagList = new NBTTagCompound();
            tagList.func_74778_a("User", name);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        nbttagcompound.func_74782_a("localViewUsers", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (String name : this.sortByNameUsers) {
            if (name == null || name.isEmpty()) continue;
            tagList = new NBTTagCompound();
            tagList.func_74778_a("User", name);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        nbttagcompound.func_74782_a("sortByNameUsers", (NBTBase)nbttaglist);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        String name;
        NBTTagCompound tagList;
        int i;
        super.readCustomNBT(nbttagcompound);
        this.poweredTime = nbttagcompound.func_74762_e("poweredTime");
        this.linkX = nbttagcompound.func_74762_e("linkX");
        this.linkY = nbttagcompound.func_74762_e("linkY");
        this.linkZ = nbttagcompound.func_74762_e("linkZ");
        this.someSlotsOmitted = nbttagcompound.func_74767_n("someSlotsOmitted");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("localViewUsers", 10);
        this.localViewUsers.clear();
        int size = nbttaglist.func_74745_c();
        for (i = 0; i < size; ++i) {
            tagList = nbttaglist.func_150305_b(i);
            name = tagList.func_74779_i("User");
            if (name == null || name.isEmpty()) continue;
            this.localViewUsers.add(name);
        }
        nbttaglist = nbttagcompound.func_150295_c("sortByNameUsers", 10);
        this.sortByNameUsers.clear();
        size = nbttaglist.func_74745_c();
        for (i = 0; i < size; ++i) {
            tagList = nbttaglist.func_150305_b(i);
            name = tagList.func_74779_i("User");
            if (name == null || name.isEmpty()) continue;
            this.sortByNameUsers.add(name);
        }
    }

    public static class SelectedContainers {
        private List<Block> blocks = new ArrayList<Block>();
        private List<Integer> mds = new ArrayList<Integer>();
        private List<BlockCoord> coords = new ArrayList<BlockCoord>();
        private Map<Integer, String> names = new HashMap<Integer, String>();

        private int getIndex(Block block, int metadata) {
            for (int i = 0; i < this.blocks.size(); ++i) {
                if (this.blocks.get(i) != block || this.mds.get(i) != metadata) continue;
                return i;
            }
            return -1;
        }

        public boolean contains(Block block, int metadata) {
            return this.getIndex(block, metadata) != -1;
        }

        public boolean containsBlockAt(World world, int x, int y, int z) {
            Block block = world.func_147439_a(x, y, z);
            int md = -1;
            for (int i = 0; i < this.blocks.size(); ++i) {
                String nameStored;
                int mdStored;
                if (this.blocks.get(i) != block) continue;
                if (md == -1) {
                    md = world.func_72805_g(x, y, z);
                }
                if ((mdStored = this.mds.get(i).intValue()) == md) {
                    return true;
                }
                String name = TjUtil.getBlockUnlocalizedName(block, world, x, y, z);
                if (!name.equals(nameStored = this.getName(block, mdStored, world))) continue;
                return true;
            }
            return false;
        }

        public boolean add(World world, int x, int y, int z) {
            int md;
            TileEntity te;
            Block block = world.func_147439_a(x, y, z);
            if (block != null && !AutomagyAPI.invContainerBlacklist.contains(block) && TileEntityInventarium.getContentsProvider(te = world.func_147438_o(x, y, z)) != null && !this.contains(block, md = world.func_72805_g(x, y, z))) {
                this.blocks.add(block);
                this.mds.add(md);
                this.coords.add(new BlockCoord(x, y, z));
                return true;
            }
            return false;
        }

        public String getName(Block block, int metadata, World world) {
            int i = this.getIndex(block, metadata);
            if (i == -1) {
                return null;
            }
            String name = this.names.get(i);
            if (name == null) {
                BlockCoord pos = this.coords.get(i);
                name = TjUtil.getBlockUnlocalizedName(block, world, pos.x, pos.y, pos.z);
                this.names.put(i, name);
            }
            return name;
        }

        public int size() {
            return this.blocks.size();
        }

        public BlockCoord getBlockCoord(int i) {
            return this.coords.get(i);
        }
    }
}

