/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import thaumcraft.common.tiles.TileJarBrain;
import tuhljin.automagy.blocks.BlockAmnesiac;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.entities.EntityXPOrbSuppressFollow;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.tiles.ModTileEntity;

public class TileEntityAmnesiacStone
extends ModTileEntity {
    public static int MAX_XP_PER_JAR = 2000;
    public static int MAX_BOTTLES_PER_DRAIN = 5;
    public int comparatorStrength = 0;
    private int ticks = 0;
    private int jarXP = 0;

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.ticks;
            if (this.ticks % 2 == 0 && !this.calcComparatorStrength(this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e))) {
                AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 1.5), (double)(this.field_145849_e + 1));
                for (EntityPlayer player : this.getPlayersInArea(bb)) {
                    if (player.field_70128_L) continue;
                    ModBlocks.amnesiacBlock.drainExperience(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, player, BlockAmnesiac.DRAIN_WALK, true);
                }
                int bottlesDrained = 0;
                for (EntityItem xpBottle : this.getEnchantingBottlesInArea(bb)) {
                    ItemStack stack = xpBottle.func_92059_d();
                    int consume = Math.min(stack.field_77994_a, MAX_BOTTLES_PER_DRAIN - bottlesDrained);
                    bottlesDrained += consume;
                    int left = stack.field_77994_a - consume;
                    EntityItem bottle = new EntityItem(this.field_145850_b, xpBottle.field_70165_t, xpBottle.field_70163_u, xpBottle.field_70161_v, new ItemStack(Items.field_151069_bo, consume));
                    this.field_145850_b.func_72838_d((Entity)bottle);
                    if (left < 1) {
                        xpBottle.func_70106_y();
                    } else {
                        stack = stack.func_77946_l();
                        stack.field_77994_a = left;
                        xpBottle.func_92058_a(stack);
                    }
                    for (int i = 0; i < consume; ++i) {
                        EntityXPOrbSuppressFollow orb = new EntityXPOrbSuppressFollow(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.25, (double)this.field_145849_e + 0.5, BlockAmnesiac.XP_PER_BOTTLE, BlockAmnesiac.XP_ORB_SUPPRESS_FOLLOW_TIME);
                        orb.field_70159_w *= 0.2;
                        orb.field_70181_x *= 0.5;
                        orb.field_70179_y *= 0.2;
                        this.field_145850_b.func_72838_d((Entity)orb);
                    }
                    if (bottlesDrained < MAX_BOTTLES_PER_DRAIN) continue;
                    break;
                }
                if (bottlesDrained > 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.25, (double)this.field_145849_e + 0.5, "random.fizz", 1.0f, 2.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
                }
            }
        }
    }

    public List<EntityPlayer> getPlayersInArea(AxisAlignedBB bb) {
        return this.field_145850_b.func_72872_a(EntityPlayer.class, bb);
    }

    public List<EntityItem> getEnchantingBottlesInArea(AxisAlignedBB bb) {
        List entities = this.field_145850_b.func_72872_a(EntityItem.class, bb);
        ArrayList<EntityItem> list = new ArrayList<EntityItem>();
        for (EntityItem item : entities) {
            ItemStack stack;
            if (item.field_70128_L || (stack = item.func_92059_d()) == null || stack.field_77994_a <= 0 || stack.func_77973_b() != Items.field_151062_by) continue;
            list.add(item);
        }
        return list;
    }

    public boolean calcComparatorStrength(TileEntity te) {
        boolean hasBrain = false;
        int xp = 0;
        if (te instanceof TileJarBrain) {
            hasBrain = true;
            xp = ((TileJarBrain)te).xp;
        }
        if (this.jarXP != xp) {
            this.jarXP = xp;
            int strength = RedstoneCalc.getRedstoneSignalStrengthFromValues(this.jarXP, MAX_XP_PER_JAR);
            if (this.comparatorStrength != strength) {
                this.comparatorStrength = strength;
                this.markDirty(false);
            }
        }
        return hasBrain;
    }
}

