/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.renderers;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import tuhljin.automagy.codechicken.lib.math.MathHelper;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.items.ModItems;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.models.ModelScribePointer;
import tuhljin.automagy.tiles.TileEntityScribePointer;
import tuhljin.automagy.tiles.TileEntityUnseenScribe;

public class BlockScribePointerRenderer
extends TileEntitySpecialRenderer {
    public static final String TEXTURE_SCRIBETABLE = "textures/models/scribePointer.png";
    public static int renderPass = 0;
    public static int TICKS_PER_BLOCK_VIEW = 60;
    public static float ROTATION_SPEED = 0.3f;
    private final ModelScribePointer model = new ModelScribePointer();
    private ItemStack eyeStack = new ItemStack((Item)ModItems.crystalEye);

    public BlockScribePointerRenderer() {
        this.eyeStack.field_77990_d = new NBTTagCompound();
        this.eyeStack.field_77990_d.func_74768_a("lookX", 1);
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float scale) {
        boolean inWorld;
        TileEntityScribePointer teP = (TileEntityScribePointer)te;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        boolean bl = inWorld = te.func_145831_w() != null;
        if (!inWorld) {
            GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
            GL11.glScalef((float)1.2f, (float)1.2f, (float)1.2f);
        } else {
            switch (te.func_145832_p()) {
                case 0: {
                    GL11.glTranslatef((float)-0.35f, (float)0.75f, (float)-0.35f);
                    break;
                }
                case 1: {
                    GL11.glTranslatef((float)-0.35f, (float)0.75f, (float)0.35f);
                    break;
                }
                case 2: {
                    GL11.glTranslatef((float)0.35f, (float)0.75f, (float)0.35f);
                    break;
                }
                case 3: {
                    GL11.glTranslatef((float)0.35f, (float)0.75f, (float)-0.35f);
                }
            }
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        if (!inWorld) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("Automagy".toLowerCase(), TEXTURE_SCRIBETABLE));
            this.model.renderBase(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
            this.model.renderCrystalBall();
        } else if (renderPass == 0) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("Automagy".toLowerCase(), TEXTURE_SCRIBETABLE));
            this.model.renderBase(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            this.renderItem(teP);
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("Automagy".toLowerCase(), TEXTURE_SCRIBETABLE));
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            float interpolationFactor = (float)teP.ticks % 100.0f / 100.0f;
            float transp = TjUtil.dualInterpolate(0.9f, 0.7f, interpolationFactor);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)transp);
            this.model.renderCrystalBall();
        }
        GL11.glPopMatrix();
    }

    private void renderItem(TileEntityScribePointer teP) {
        int count = teP.getEyeCount();
        if (count > 0) {
            if (teP.displayChangedTick == -1 || teP.displayChangedTick != teP.ticks && teP.ticks % TICKS_PER_BLOCK_VIEW == 0) {
                teP.displayStack = this.getNextDisplayTarget(teP);
                teP.displayChangedTick = teP.ticks;
            }
            if (teP.displayStack != null) {
                GL11.glPushMatrix();
                float interpolationFactorRotate = (float)teP.ticks * ROTATION_SPEED % 100.0f / 100.0f;
                GL11.glTranslatef((float)0.0f, (float)1.3f, (float)0.0f);
                GL11.glRotatef((float)MathHelper.interpolate(0.0f, 360.0f, interpolationFactorRotate), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                boolean item3D = this.itemDisplaysIn3D(teP.displayStack);
                if (!item3D) {
                    GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
                }
                EntityItem entityitem = new EntityItem(teP.func_145831_w(), 0.0, 0.0, 0.0, teP.displayStack);
                entityitem.field_70290_d = 0.0f;
                RenderManager.field_78727_a.func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                if (!item3D && !Minecraft.func_71375_t()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    RenderManager.field_78727_a.func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                }
                GL11.glPopMatrix();
            } else {
                IIcon icon = this.eyeStack.func_77973_b().getIcon(this.eyeStack, 0);
                if (icon != null) {
                    GL11.glPushMatrix();
                    float interpolationFactorRotate = (float)teP.ticks * ROTATION_SPEED % 100.0f / 100.0f;
                    GL11.glTranslatef((float)0.0f, (float)1.3f, (float)0.0f);
                    GL11.glRotatef((float)MathHelper.interpolate(0.0f, 360.0f, interpolationFactorRotate), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
                    GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
                    GL11.glTranslated((double)-0.5, (double)0.0, (double)0.0);
                    float f = icon.func_94209_e();
                    float f1 = icon.func_94212_f();
                    float f2 = icon.func_94206_g();
                    float f3 = icon.func_94210_h();
                    ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)f1, (float)f2, (float)f, (float)f3, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    private ItemStack getNextDisplayTarget(TileEntityScribePointer teP) {
        int size;
        TileEntityUnseenScribe.SelectedContainers sc = teP.getSelectedContainers();
        if (sc != null && (size = sc.size()) > 0) {
            if (teP.getEyeCount() > size && teP.ticks % (TICKS_PER_BLOCK_VIEW * 2) == 0) {
                return null;
            }
            ++teP.currentDisplayIndex;
            if (teP.currentDisplayIndex >= size) {
                teP.currentDisplayIndex = 0;
            }
            BlockCoord pos = sc.getBlockCoord(teP.currentDisplayIndex);
            ItemStack stack = TjUtil.getStackFromBlock(teP.func_145831_w(), pos.x, pos.y, pos.z);
            if (stack != null) {
                return stack;
            }
        }
        return null;
    }

    private boolean itemDisplaysIn3D(ItemStack stack) {
        return stack.func_94608_d() == 0 && stack.func_77973_b() instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)stack.func_77973_b()).func_149645_b());
    }
}

