/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib.compat;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.BlockFluidBase;
import org.apache.logging.log4j.Level;
import thaumcraft.api.aspects.Aspect;
import tuhljin.automagy.api.AutomagyAPI;
import tuhljin.automagy.api.example.betterstorage.ProviderForConnectable;
import tuhljin.automagy.api.example.betterstorage.ProviderForCrate;
import tuhljin.automagy.api.example.minefactoryreloaded.ProviderForDeepStorage;
import tuhljin.automagy.api.example.storagedrawers.ProviderForStorageDrawers;
import tuhljin.automagy.api.inventarium.DefaultInventariumContentsProvider;
import tuhljin.automagy.api.inventarium.SidedInventariumContentsProvider;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.config.ModRecipes;
import tuhljin.automagy.items.ModItems;
import tuhljin.automagy.lib.AutomagyConfig;
import tuhljin.automagy.lib.compat.BotaniaHandler;
import tuhljin.automagy.lib.compat.nei.NEIProviders;

public class CompatibilityManager {
    public static boolean modLoadedNEI = false;
    public static boolean modLoadedBotania = false;
    public static BlockFluidBase milkBlock;
    public static BlockFluidBase mushroomSoupBlock;

    public static void init() {
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"tuhljin.automagy.lib.compat.waila.WailaProviders.wailaCallbackRegister");
    }

    public static void postInit() {
        AutomagyAPI.registerInventariumContentsProvider(new DefaultInventariumContentsProvider(), 500);
        AutomagyAPI.registerInventariumContentsProvider(new SidedInventariumContentsProvider(), 499);
        if (Loader.isModLoaded((String)"betterstorage")) {
            AutomagyAPI.registerInventariumContentsProvider(new ProviderForCrate(), 100);
            AutomagyAPI.registerInventariumContentsProvider(new ProviderForConnectable(), 101);
            FMLLog.info((String)"[Automagy] Integrated with BetterStorage.", (Object[])new Object[0]);
        }
        if (Loader.isModLoaded((String)"StorageDrawers")) {
            FMLLog.info((String)"[Automagy] Attempting integration with Storage Drawers. IF THIS FAILS, be sure you have the latest version of Storage Drawers installed!", (Object[])new Object[0]);
            AutomagyAPI.registerInventariumContentsProvider(new ProviderForStorageDrawers(), 120);
            FMLLog.info((String)"[Automagy] Integrated with Storage Drawers.", (Object[])new Object[0]);
        }
        try {
            Class<?> c = Class.forName("powercrystals.minefactoryreloaded.api.IDeepStorageUnit");
            AutomagyAPI.registerInventariumContentsProvider(new ProviderForDeepStorage(), 400);
            FMLLog.info((String)"[Automagy] Integrated with MineFactoryReloaded's IDeepStorageUnit.", (Object[])new Object[0]);
        }
        catch (Exception c) {
            // empty catch block
        }
        if (Loader.isModLoaded((String)"Botania")) {
            modLoadedBotania = true;
        }
        Method methodNEIHideItem = null;
        try {
            methodNEIHideItem = Class.forName("codechicken.nei.api.API").getMethod("hideItem", ItemStack.class);
        }
        catch (Exception ex) {
            FMLLog.info((String)"[Automagy] No NEI integration because mod \"NotEnoughItems\" was not found.", (Object[])new Object[0]);
        }
        if (methodNEIHideItem != null) {
            boolean ok = true;
            try {
                methodNEIHideItem.invoke(null, new ItemStack(ModBlocks.torchInversion_off));
                methodNEIHideItem.invoke(null, new ItemStack((Block)ModBlocks.specialProcessBlock));
                methodNEIHideItem.invoke(null, new ItemStack((Block)ModBlocks.thaumostaticSpire));
                methodNEIHideItem.invoke(null, new ItemStack((Block)ModBlocks.tallyBlockWorld));
                methodNEIHideItem.invoke(null, new ItemStack((Block)ModBlocks.tallyBlockDrops));
                if (!AutomagyConfig.listCreativeJar) {
                    methodNEIHideItem.invoke(null, new ItemStack((Block)ModBlocks.creativeJar, 1, 3));
                }
                if (!AutomagyConfig.listThinkingCap) {
                    methodNEIHideItem.invoke(null, new ItemStack((Item)ModItems.creativeTool, 1, 0));
                }
            }
            catch (Exception ex) {
                FMLLog.info((String)"[Automagy] Error while attempting NEI integration: Failed to hide items.", (Object[])new Object[0]);
                ok = false;
            }
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            if (side == Side.CLIENT) {
                NEIProviders.register();
            }
            modLoadedNEI = true;
            if (ok) {
                FMLLog.info((String)"[Automagy] NEI integration was successful.", (Object[])new Object[0]);
            }
        }
    }

    public static void onLoadComplete() {
        if (AutomagyConfig.useMFRMilk || AutomagyConfig.useMFRMushroomSoup || AutomagyConfig.overrideMFRMilkAspects || AutomagyConfig.overrideMFRMushroomSoupAspects) {
            boolean noErrors = true;
            Class<?> mfrThings = null;
            try {
                mfrThings = Class.forName("powercrystals.minefactoryreloaded.setup.MFRThings");
            }
            catch (Exception e) {
                noErrors = false;
                FMLLog.info((String)"[Automagy] No MFR integration because mod \"MineFactoryReloaded\" was not found.", (Object[])new Object[0]);
            }
            if (mfrThings != null) {
                Object o;
                Field f;
                if (AutomagyConfig.useMFRMilk || AutomagyConfig.overrideMFRMilkAspects) {
                    try {
                        f = mfrThings.getField("milkLiquid");
                        o = f.get(null);
                        if (o instanceof BlockFluidBase) {
                            if (AutomagyConfig.useMFRMilk) {
                                milkBlock = (BlockFluidBase)o;
                            }
                            if (AutomagyConfig.overrideMFRMilkAspects) {
                                ModRecipes.copyObjectAspects((Block)ModBlocks.milk, (Block)o);
                            }
                        }
                    }
                    catch (Exception e) {
                        noErrors = false;
                        FMLLog.info((String)"[Automagy] MineFactoryReloaded failure: Could not find milkLiquid.", (Object[])new Object[0]);
                    }
                }
                if (AutomagyConfig.useMFRMushroomSoup || AutomagyConfig.overrideMFRMushroomSoupAspects) {
                    try {
                        f = mfrThings.getField("mushroomSoupLiquid");
                        o = f.get(null);
                        if (o instanceof BlockFluidBase) {
                            if (AutomagyConfig.useMFRMushroomSoup) {
                                mushroomSoupBlock = (BlockFluidBase)o;
                            }
                            if (AutomagyConfig.overrideMFRMushroomSoupAspects) {
                                ModRecipes.copyObjectAspects((Block)ModBlocks.mushroomFluid, (Block)o);
                            }
                        }
                    }
                    catch (Exception e) {
                        noErrors = false;
                        FMLLog.info((String)"[Automagy] MineFactoryReloaded failure: Could not find mushroomSoupLiquid.", (Object[])new Object[0]);
                    }
                }
            }
            if (noErrors) {
                FMLLog.info((String)"[Automagy] Successfully integrated with MineFactoryReloaded fluids.", (Object[])new Object[0]);
            }
        }
        if (milkBlock == null) {
            milkBlock = ModBlocks.milk;
        }
        if (mushroomSoupBlock == null) {
            mushroomSoupBlock = ModBlocks.mushroomFluid;
        }
        if (Loader.isModLoaded((String)"ForbiddenMagic")) {
            Class<?> darkAspects = null;
            try {
                darkAspects = Class.forName("fox.spiteful.forbidden.DarkAspects");
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (String)"[Automagy] Failed to integrate with \"Forbidden Magic\" aspects.", (Object[])new Object[0]);
            }
            if (darkAspects != null) {
                ForbiddenMagicAspect.NETHER = CompatibilityManager.getAddonAspect(darkAspects, "NETHER");
                ForbiddenMagicAspect.WRATH = CompatibilityManager.getAddonAspect(darkAspects, "WRATH");
                ForbiddenMagicAspect.ENVY = CompatibilityManager.getAddonAspect(darkAspects, "ENVY");
                ForbiddenMagicAspect.GLUTTONY = CompatibilityManager.getAddonAspect(darkAspects, "GLUTTONY");
                ForbiddenMagicAspect.PRIDE = CompatibilityManager.getAddonAspect(darkAspects, "PRIDE");
                ForbiddenMagicAspect.LUST = CompatibilityManager.getAddonAspect(darkAspects, "LUST");
                ForbiddenMagicAspect.SLOTH = CompatibilityManager.getAddonAspect(darkAspects, "SLOTH");
                FMLLog.info((String)"[Automagy] Finished integrating with Forbidden Magic aspects.", (Object[])new Object[0]);
            }
        }
    }

    public static boolean fillBotaniaPetalApothecary(TileEntity te, boolean doFill) {
        if (!modLoadedBotania) {
            return false;
        }
        return BotaniaHandler.fillBotaniaPetalApothecary(te, doFill);
    }

    private static Aspect getAddonAspect(Class clazz, String fieldName) {
        try {
            Field f = clazz.getField(fieldName);
            Object o = f.get(null);
            return o instanceof Aspect ? (Aspect)o : null;
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (String)("[Automagy] Failed to find \"Forbidden Magic\" aspect " + fieldName + "."), (Object[])new Object[0]);
            return null;
        }
    }

    public static class ForbiddenMagicAspect {
        public static Aspect NETHER;
        public static Aspect WRATH;
        public static Aspect ENVY;
        public static Aspect GLUTTONY;
        public static Aspect PRIDE;
        public static Aspect LUST;
        public static Aspect SLOTH;
    }
}

