/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.gregtech.machines;

import gregtech.api.GregTech_API;
import java.util.Arrays;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Electrolyzer")
@ModOnly(value={"gregtech"})
public class Electrolyzer {
    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IItemStack input, int cells, int durationTicks, int euPerTick) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError("Electrolyzer recipe requires at least 1 output");
        } else {
            MineTweakerAPI.apply(new AddRecipeAction(outputs, input, cells, durationTicks, euPerTick));
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack[] output;
        private final IItemStack input;
        private final int cells;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(IItemStack[] output, IItemStack input, int cells, int duration, int euPerTick) {
            this.output = output;
            this.input = input;
            this.cells = cells;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        @Override
        public void apply() {
            GregTech_API.sRecipeAdder.addElectrolyzerRecipe(MineTweakerMC.getItemStack(this.input), this.cells, MineTweakerMC.getItemStack(this.output[0]), this.output.length > 1 ? MineTweakerMC.getItemStack(this.output[1]) : null, this.output.length > 2 ? MineTweakerMC.getItemStack(this.output[2]) : null, this.output.length > 3 ? MineTweakerMC.getItemStack(this.output[3]) : null, this.output.length > 4 ? MineTweakerMC.getItemStack(this.output[4]) : null, this.output.length > 5 ? MineTweakerMC.getItemStack(this.output[5]) : null, this.duration, this.cells);
        }

        @Override
        public String describe() {
            return "Adding electrolyzer recipe with input " + this.input;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Arrays.deepHashCode(this.output);
            hash = 97 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 97 * hash + this.cells;
            hash = 97 * hash + this.duration;
            hash = 97 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)obj;
            if (!Arrays.deepEquals(this.output, other.output)) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (this.cells != other.cells) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

