/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.server;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public final class CoordinateBlock {
    public final int dim;
    public final int x;
    public final int y;
    public final int z;

    public CoordinateBlock(int d, int x, int y, int z) {
        this.dim = d;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public CoordinateBlock(int d, double x, double y, double z) {
        this.dim = d;
        this.x = MathHelper.func_76143_f((double)x);
        this.y = MathHelper.func_76143_f((double)y);
        this.z = MathHelper.func_76143_f((double)z);
    }

    public CoordinateBlock(NBTTagCompound tag) {
        this.dim = tag.func_74762_e("dim");
        this.x = tag.func_74762_e("x");
        this.y = tag.func_74762_e("y");
        this.z = tag.func_74762_e("z");
    }

    public String toString() {
        return String.format("[%d %d %d %d]", this.dim, this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        CoordinateBlock c = (CoordinateBlock)o;
        return this.dim == c.dim && this.x == c.x && this.y == c.y && this.z == c.z;
    }

    public int hashCode() {
        return this.dim + 31 * this.x + 877 * this.y + 3187 * this.z;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound coords = new NBTTagCompound();
        coords.func_74768_a("dim", this.dim);
        coords.func_74768_a("x", this.x);
        coords.func_74768_a("y", this.y);
        coords.func_74768_a("z", this.z);
        return coords;
    }

    public double distanceTo(CoordinateBlock target) {
        if (this.dim != target.dim) {
            return -1.0;
        }
        return (this.x - target.x) * (this.x - target.x) + (this.y - target.y) * (this.y - target.y) + (this.z - target.z) * (this.z - target.z);
    }
}

