/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.ArrayList;
import mcp.mobius.ram.RPGAdvMod;
import mcp.mobius.ram.client.ClientUtils;
import mcp.mobius.ram.common.LocalizedChat;
import mcp.mobius.ram.network.PacketBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class Packet0x0BLocalizedChat
extends PacketBase {
    public int messageID;
    public int extraCount;
    ArrayList<SupportedExtraTypes> extraTypesList = new ArrayList();
    ArrayList<Object> extraValuesList = new ArrayList();

    public Packet0x0BLocalizedChat() {
    }

    public Packet0x0BLocalizedChat(LocalizedChat message, Object ... extraItems) {
        this.messageID = message.ordinal();
        this.extraCount = extraItems.length;
        int invalidTypesCount = 0;
        for (int i = 0; i < this.extraCount; ++i) {
            SupportedExtraTypes type = SupportedExtraTypes.getTypeFromObject(extraItems[i]);
            if (type == null) {
                RPGAdvMod.log.warning("Localized Chat Packet has no support for : " + extraItems[i].getClass().getCanonicalName());
                ++invalidTypesCount;
                continue;
            }
            this.extraTypesList.add(type);
            this.extraValuesList.add(extraItems[i]);
        }
        this.extraCount -= invalidTypesCount;
    }

    @Override
    public void encode(ByteArrayDataOutput output) {
        output.writeInt(this.messageID);
        output.writeInt(this.extraCount);
        block5: for (int i = 0; i < this.extraCount; ++i) {
            SupportedExtraTypes type = this.extraTypesList.get(i);
            output.writeByte(type.ordinal());
            switch (type) {
                case INT: {
                    output.writeInt(((Integer)this.extraValuesList.get(i)).intValue());
                    continue block5;
                }
                case STR: {
                    output.writeUTF((String)this.extraValuesList.get(i));
                    continue block5;
                }
                case FLT: {
                    output.writeFloat(((Float)this.extraValuesList.get(i)).floatValue());
                }
            }
        }
    }

    @Override
    public void decode(ByteArrayDataInput input) {
        this.messageID = input.readInt();
        this.extraCount = input.readInt();
        block5: for (int i = 0; i < this.extraCount; ++i) {
            SupportedExtraTypes type = SupportedExtraTypes.getType(input.readByte());
            this.extraTypesList.add(type);
            switch (type) {
                case INT: {
                    this.extraValuesList.add(input.readInt());
                    continue block5;
                }
                case STR: {
                    this.extraValuesList.add(input.readUTF());
                    continue block5;
                }
                case FLT: {
                    this.extraValuesList.add(Float.valueOf(input.readFloat()));
                }
            }
        }
    }

    @Override
    public void actionClient(World world, EntityPlayer player) {
        ClientUtils.printLocalizedMessage(LocalizedChat.values()[this.messageID].localizationKey, this.extraValuesList.toArray());
    }

    static enum SupportedExtraTypes {
        INT(Integer.TYPE),
        STR(String.class),
        FLT(Float.TYPE);

        Class clazz;

        private SupportedExtraTypes(Class clazz) {
            this.clazz = clazz;
        }

        public static SupportedExtraTypes getType(int i) {
            return SupportedExtraTypes.values()[i];
        }

        public static SupportedExtraTypes getTypeFromObject(Object o) {
            for (SupportedExtraTypes supportedType : SupportedExtraTypes.values()) {
                if (!o.getClass().isAssignableFrom(supportedType.clazz)) continue;
                return supportedType;
            }
            return null;
        }
    }
}

