/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.network;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.ArrayList;
import mcp.mobius.ram.network.PacketBase;
import mcp.mobius.ram.network.PacketManager;
import mcp.mobius.ram.server.BreadcrumbManager;
import mcp.mobius.ram.server.WaypointManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class Packet0x08FullCrumbUpdate
extends PacketBase {
    ArrayList<BreadcrumbManager.BreadCrumb> crumbs;
    HashBasedTable<WaypointManager.Waypoint, WaypointManager.Waypoint, ArrayList<BreadcrumbManager.BreadCrumb>> linkedCrumbs;

    public Packet0x08FullCrumbUpdate() {
    }

    public Packet0x08FullCrumbUpdate(ArrayList<BreadcrumbManager.BreadCrumb> crumbs, HashBasedTable<WaypointManager.Waypoint, WaypointManager.Waypoint, ArrayList<BreadcrumbManager.BreadCrumb>> linkedCrumbs) {
        this.crumbs = crumbs;
        this.linkedCrumbs = linkedCrumbs;
    }

    @Override
    public void encode(ByteArrayDataOutput output) {
        output.writeInt(this.crumbs.size());
        output.writeInt(this.linkedCrumbs.size());
        try {
            for (BreadcrumbManager.BreadCrumb crumb : this.crumbs) {
                PacketManager.writeNBTTagCompoundToBuffer(output, crumb.toNBT());
            }
            for (Table.Cell cell : this.linkedCrumbs.cellSet()) {
                PacketManager.writeNBTTagCompoundToBuffer(output, ((WaypointManager.Waypoint)cell.getRowKey()).toNBT());
                PacketManager.writeNBTTagCompoundToBuffer(output, ((WaypointManager.Waypoint)cell.getColumnKey()).toNBT());
                output.writeInt(((ArrayList)cell.getValue()).size());
                for (BreadcrumbManager.BreadCrumb crumb : (ArrayList)cell.getValue()) {
                    PacketManager.writeNBTTagCompoundToBuffer(output, crumb.toNBT());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void decode(ByteArrayDataInput input) {
        this.crumbs = new ArrayList();
        this.linkedCrumbs = HashBasedTable.create();
        int ncrumbs = input.readInt();
        int nlinked = input.readInt();
        try {
            int i;
            for (i = 0; i < ncrumbs; ++i) {
                BreadcrumbManager breadcrumbManager = BreadcrumbManager.INSTANCE;
                breadcrumbManager.getClass();
                this.crumbs.add(new BreadcrumbManager.BreadCrumb(breadcrumbManager, PacketManager.readNBTTagCompoundFromBuffer(input)));
            }
            for (i = 0; i < nlinked; ++i) {
                WaypointManager waypointManager = WaypointManager.INSTANCE;
                waypointManager.getClass();
                WaypointManager.Waypoint wpStart = new WaypointManager.Waypoint(waypointManager, PacketManager.readNBTTagCompoundFromBuffer(input));
                WaypointManager waypointManager2 = WaypointManager.INSTANCE;
                waypointManager2.getClass();
                WaypointManager.Waypoint wpEnd = new WaypointManager.Waypoint(waypointManager2, PacketManager.readNBTTagCompoundFromBuffer(input));
                ArrayList<BreadcrumbManager.BreadCrumb> lc = new ArrayList<BreadcrumbManager.BreadCrumb>();
                int nlc = input.readInt();
                for (int j = 0; j < nlc; ++j) {
                    BreadcrumbManager breadcrumbManager = BreadcrumbManager.INSTANCE;
                    breadcrumbManager.getClass();
                    lc.add(new BreadcrumbManager.BreadCrumb(breadcrumbManager, PacketManager.readNBTTagCompoundFromBuffer(input)));
                }
                this.linkedCrumbs.put((Object)wpStart, (Object)wpEnd, lc);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        BreadcrumbManager.INSTANCE.setClientCrumbs(this.crumbs);
        BreadcrumbManager.INSTANCE.setLinkedCrumbs(this.linkedCrumbs);
    }
}

