/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.ArrayList;
import mcp.mobius.ram.common.Sign;
import mcp.mobius.ram.events.ClientEventHandler;
import mcp.mobius.ram.network.PacketBase;
import mcp.mobius.ram.network.PacketManager;
import mcp.mobius.ram.server.CoordinateBlock;
import mcp.mobius.ram.server.PathManager;
import mcp.mobius.ram.server.WaypointManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class Packet0x07CustomPath
extends PacketBase {
    Sign sign;
    WaypointManager.Waypoint wpStart;
    WaypointManager.Waypoint wpEnd;
    ArrayList<CoordinateBlock> coords;

    public Packet0x07CustomPath() {
    }

    public Packet0x07CustomPath(WaypointManager.Waypoint start, WaypointManager.Waypoint end, Sign sign_) {
        this.sign = sign_;
        this.wpStart = start;
        this.wpEnd = end;
        this.coords = PathManager.INSTANCE.getPath(start, end);
    }

    @Override
    public void encode(ByteArrayDataOutput output) {
        try {
            PacketManager.writeNBTTagCompoundToBuffer(output, this.sign.toNBT());
            PacketManager.writeNBTTagCompoundToBuffer(output, this.wpStart.toNBT());
            PacketManager.writeNBTTagCompoundToBuffer(output, this.wpEnd.toNBT());
            if (this.coords == null) {
                output.writeInt(0);
            } else {
                output.writeInt(this.coords.size());
                for (CoordinateBlock c : this.coords) {
                    PacketManager.writeNBTTagCompoundToBuffer(output, c.toNBT());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void decode(ByteArrayDataInput input) {
        this.coords = new ArrayList();
        try {
            this.sign = new Sign(PacketManager.readNBTTagCompoundFromBuffer(input));
            WaypointManager waypointManager = WaypointManager.INSTANCE;
            waypointManager.getClass();
            this.wpStart = new WaypointManager.Waypoint(waypointManager, PacketManager.readNBTTagCompoundFromBuffer(input));
            WaypointManager waypointManager2 = WaypointManager.INSTANCE;
            waypointManager2.getClass();
            this.wpEnd = new WaypointManager.Waypoint(waypointManager2, PacketManager.readNBTTagCompoundFromBuffer(input));
            int ncoords = input.readInt();
            for (int i = 0; i < ncoords; ++i) {
                this.coords.add(new CoordinateBlock(PacketManager.readNBTTagCompoundFromBuffer(input)));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        ClientEventHandler.INSTANCE.setPath(this.wpStart, this.wpEnd, this.coords, this.sign);
    }
}

