/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.events;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import mcp.mobius.ram.RPGAdvMod;
import mcp.mobius.ram.client.ClientUtils;
import mcp.mobius.ram.client.models.ModelArrow;
import mcp.mobius.ram.client.models.ModelInterface;
import mcp.mobius.ram.client.models.Modelcrumbs;
import mcp.mobius.ram.common.LocalizedChat;
import mcp.mobius.ram.common.Sign;
import mcp.mobius.ram.common.SignModels;
import mcp.mobius.ram.events.ClientTickHandler;
import mcp.mobius.ram.server.BreadcrumbManager;
import mcp.mobius.ram.server.CoordinateBlock;
import mcp.mobius.ram.server.WaypointManager;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import org.lwjgl.opengl.GL11;

public enum ClientEventHandler {
    INSTANCE;

    private Minecraft mc = Minecraft.func_71410_x();
    public CoordinateBlock start;
    public CoordinateBlock end;
    public Vec3 pathVector;
    public float angle;
    public double length;
    public long frame;
    public ModelInterface arrow = new ModelArrow();
    public ModelInterface crumb = new Modelcrumbs();
    public ArrayList<CoordinateBlock> path = new ArrayList();
    public boolean showCrumbs = true;
    public float removePathDistance = 1.25f;
    public AxisAlignedBB destinationBox;
    private boolean haspath;
    private boolean setupNEI = true;

    @SubscribeEvent
    public void onRenderTick(RenderWorldLastEvent event) {
        ArrayList<BreadcrumbManager.BreadCrumb> crumbs = BreadcrumbManager.INSTANCE.getCrumbs();
        HashBasedTable<WaypointManager.Waypoint, WaypointManager.Waypoint, ArrayList<BreadcrumbManager.BreadCrumb>> linkedCrumbs = BreadcrumbManager.INSTANCE.getLinkedCrumbs();
        if (this.mc.field_71441_e != null) {
            int playerDim = this.mc.field_71441_e.field_73011_w.field_76574_g;
            if (this.showCrumbs) {
                for (BreadcrumbManager.BreadCrumb crumb : crumbs) {
                    if (crumb.coord.dim != playerDim) continue;
                    this.renderCrumb(crumb.coord, event.partialTicks);
                }
                for (Table.Cell crumbCell : linkedCrumbs.cellSet()) {
                    for (BreadcrumbManager.BreadCrumb crumb : (ArrayList)crumbCell.getValue()) {
                        if (crumb.coord.dim != playerDim) continue;
                        this.renderLinkedCrumb(crumb.coord, event.partialTicks);
                    }
                }
            }
            if (this.start != null && this.pathVector != null) {
                if (this.path.size() == 0) {
                    this.renderFlyPath(event.partialTicks);
                } else {
                    this.renderPath(event.partialTicks);
                }
                if (this.destinationBox != null && this.mc.field_71439_g.field_70165_t > this.destinationBox.field_72340_a && this.mc.field_71439_g.field_70165_t < this.destinationBox.field_72336_d && this.mc.field_71439_g.field_70163_u > this.destinationBox.field_72338_b && this.mc.field_71439_g.field_70163_u < this.destinationBox.field_72337_e && this.mc.field_71439_g.field_70161_v > this.destinationBox.field_72339_c && this.mc.field_71439_g.field_70161_v < this.destinationBox.field_72334_f) {
                    this.destinationBox = null;
                    this.start = null;
                    this.end = null;
                }
            }
        }
    }

    public void renderCrumb(CoordinateBlock block, double partialTicks) {
        this.renderModel(this.crumb, (double)block.x + 0.5, block.y, (double)block.z + 0.5, 0.25f, 0.0f, partialTicks);
    }

    public void renderLinkedCrumb(CoordinateBlock block, double partialTicks) {
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModel(this.crumb, (double)block.x + 0.5, block.y, (double)block.z + 0.5, 0.25f, 0.0f, partialTicks);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderFlyPath(double partialTicks) {
        double spacing = 2.0;
        int nmarkers = MathHelper.func_76143_f((double)(this.length / spacing));
        this.frame = ClientTickHandler.INSTANCE.nticks / 3L % (long)nmarkers;
        for (double i = 0.0; i < this.length; i += spacing) {
            double frac = i / this.length;
            int index = MathHelper.func_76143_f((double)(i / spacing));
            if ((long)index == this.frame && index != 0) {
                this.renderModel(this.arrow, (float)((double)this.start.x + 0.5 + this.pathVector.field_72450_a * frac), (float)((double)this.start.y + 0.5 + this.pathVector.field_72448_b * frac), (float)((double)this.start.z + 0.5 + this.pathVector.field_72449_c * frac), 0.7f, this.angle, partialTicks);
                continue;
            }
            this.renderModel(this.arrow, (float)((double)this.start.x + 0.5 + this.pathVector.field_72450_a * frac), (float)((double)this.start.y + 0.5 + this.pathVector.field_72448_b * frac), (float)((double)this.start.z + 0.5 + this.pathVector.field_72449_c * frac), 0.3f, this.angle, partialTicks);
        }
    }

    public void renderPath(double partialTicks) {
        for (int i = 0; i < this.path.size() - 1; ++i) {
            CoordinateBlock e = this.path.get(i + 1);
            CoordinateBlock s = this.path.get(i);
            double dist = Math.sqrt(e.distanceTo(s));
            Vec3 delta = Vec3.func_72443_a((double)(e.x - s.x), (double)(e.y - s.y), (double)(e.z - s.z)).func_72432_b();
            for (double j = 0.0; j < dist; j += 1.0) {
                this.renderPlane((double)s.x + delta.field_72450_a * j + 0.5, (double)s.y + delta.field_72448_b * j + 0.01, (double)s.z + delta.field_72449_c * j + 0.5, 0.3, partialTicks, 11900416, 75);
            }
        }
    }

    public void setPath(WaypointManager.Waypoint wpStart, WaypointManager.Waypoint wpEnd, ArrayList<CoordinateBlock> coords, Sign sign) {
        if (this.end != null && this.end.equals(sign.destination.coord) && coords.size() > 0 == this.haspath) {
            this.start = null;
            this.end = null;
            this.destinationBox = null;
            this.haspath = false;
            ClientUtils.printLocalizedMessage(LocalizedChat.PATH_DESELECTED.localizationKey, sign.text);
        } else {
            this.start = wpStart.coord;
            this.end = wpEnd.coord;
            this.pathVector = Vec3.func_72443_a((double)(this.end.x - this.start.x), (double)(this.end.y - this.start.y), (double)(this.end.z - this.start.z));
            this.length = ClientEventHandler.INSTANCE.pathVector.func_72433_c();
            this.path = coords;
            this.angle = sign.angleDegrees - 90.0f;
            if (this.path.size() > 0) {
                this.path.add(0, this.start);
                this.path.add(this.end);
                this.haspath = true;
            }
            boolean drawLeft = sign.flipped;
            if (SignModels.values()[sign.type].orientation == SignModels.SignOrientation.Either) {
                boolean bl = drawLeft = sign.arrowLocation == SignModels.SignOrientation.Left;
            }
            if (drawLeft) {
                this.angle += 180.0f;
            }
            this.destinationBox = AxisAlignedBB.func_72330_a((double)((float)this.end.x - this.removePathDistance), (double)((float)this.end.y - this.removePathDistance), (double)((float)this.end.z - this.removePathDistance), (double)((float)this.end.x + this.removePathDistance), (double)((float)this.end.y + this.removePathDistance), (double)((float)this.end.z + this.removePathDistance));
            ClientUtils.printLocalizedMessage(LocalizedChat.PATH_SELECTED.localizationKey, sign.text);
        }
    }

    public void renderPlane(double bx, double by, double bz, double size, double partialTicks, int color, int alpha) {
        EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
        double px = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
        double py = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
        double pz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
        double x = bx - px;
        double y = by - py;
        double z = bz - pz;
        GL11.glPushAttrib((int)16640);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthMask((boolean)false);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78384_a(color, alpha);
        tessellator.func_78377_a(x - size, y, z - size);
        tessellator.func_78377_a(x + size, y, z - size);
        tessellator.func_78377_a(x + size, y, z + size);
        tessellator.func_78377_a(x - size, y, z + size);
        tessellator.func_78377_a(x - size, y, z - size);
        tessellator.func_78377_a(x - size, y, z + size);
        tessellator.func_78377_a(x + size, y, z + size);
        tessellator.func_78377_a(x + size, y, z - size);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glPopAttrib();
    }

    public void renderBox(double bx, double by, double bz, double size, double partialTicks) {
        EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
        double px = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
        double py = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
        double pz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
        double x = bx - px;
        double y = by - py;
        double z = bz - pz;
        GL11.glPushAttrib((int)16640);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthMask((boolean)false);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78370_a(0, 0, 255, 150);
        tessellator.func_78377_a(x - size, y - size, z - size);
        tessellator.func_78377_a(x + size, y - size, z - size);
        tessellator.func_78377_a(x + size, y - size, z + size);
        tessellator.func_78377_a(x - size, y - size, z + size);
        tessellator.func_78377_a(x - size, y + size, z - size);
        tessellator.func_78377_a(x - size, y + size, z + size);
        tessellator.func_78377_a(x + size, y + size, z + size);
        tessellator.func_78377_a(x + size, y + size, z - size);
        tessellator.func_78377_a(x - size, y - size, z - size);
        tessellator.func_78377_a(x - size, y + size, z - size);
        tessellator.func_78377_a(x + size, y + size, z - size);
        tessellator.func_78377_a(x + size, y - size, z - size);
        tessellator.func_78377_a(x - size, y - size, z + size);
        tessellator.func_78377_a(x + size, y - size, z + size);
        tessellator.func_78377_a(x + size, y + size, z + size);
        tessellator.func_78377_a(x - size, y + size, z + size);
        tessellator.func_78377_a(x - size, y - size, z - size);
        tessellator.func_78377_a(x - size, y - size, z + size);
        tessellator.func_78377_a(x - size, y + size, z + size);
        tessellator.func_78377_a(x - size, y + size, z - size);
        tessellator.func_78377_a(x + size, y - size, z - size);
        tessellator.func_78377_a(x + size, y + size, z - size);
        tessellator.func_78377_a(x + size, y + size, z + size);
        tessellator.func_78377_a(x + size, y - size, z + size);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glPopAttrib();
    }

    public void renderModel(ModelInterface model, double bx, double by, double bz, float size, float rot, double partialTicks) {
        EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
        double px = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
        double py = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
        double pz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(bx - px)), (float)((float)(by - py)), (float)((float)(bz - pz)));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(model.resource);
        GL11.glScalef((float)size, (float)size, (float)size);
        GL11.glTranslatef((float)0.0f, (float)(1.5f * model.scaleY), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)model.rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)model.offsetX, (float)model.offsetY, (float)model.offsetZ);
        model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (this.setupNEI && Loader.isModLoaded((String)"NotEnoughItems")) {
            try {
                Class<?> neiAPI = Class.forName("codechicken.nei.api.API");
                Method hideItem = neiAPI.getDeclaredMethod("hideItem", ItemStack.class);
                hideItem.invoke(null, new ItemStack((Item)RPGAdvMod.itemCrumbLinked));
                hideItem.invoke(null, new ItemStack((Block)RPGAdvMod.blockWaySign));
                this.setupNEI = false;
            }
            catch (Throwable t) {
                RPGAdvMod.log.warning("There was a problem integrating with NEI. This is non critical.");
            }
        }
    }
}

