/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.common.blocks;

import mcp.mobius.ram.RPGAdvMod;
import mcp.mobius.ram.common.LocalizedChat;
import mcp.mobius.ram.common.Sign;
import mcp.mobius.ram.common.SignModels;
import mcp.mobius.ram.common.Utils;
import mcp.mobius.ram.common.blocks.ISignHolder;
import mcp.mobius.ram.common.items.ItemGlowCrumb;
import mcp.mobius.ram.common.items.ItemPoleSign;
import mcp.mobius.ram.network.Packet0x02FullTileEntityNBT;
import mcp.mobius.ram.network.Packet0x03WaypointList;
import mcp.mobius.ram.network.Packet0x07CustomPath;
import mcp.mobius.ram.network.Packet0x0CClearFlypath;
import mcp.mobius.ram.network.PacketManager;
import mcp.mobius.ram.server.CoordinateBlock;
import mcp.mobius.ram.server.PathManager;
import mcp.mobius.ram.server.WaypointManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPole
extends TileEntity
implements ISignHolder {
    public float poleRadius = -1.0f;
    public Sign[] topRow = new Sign[2];
    public Sign[] bottomRow = new Sign[2];
    int topEmptySignIndex = 0;
    int bottomEmptySignIndex = 0;

    public TileEntityPole() {
    }

    public TileEntityPole(int meta) {
    }

    public float getPoleRadius() {
        return this.getPoleRadius(-1);
    }

    public float getPoleRadius(int model) {
        if (model < 0) {
            model = this.func_145832_p();
        }
        if (this.poleRadius == -1.0f) {
            switch (model) {
                default: 
            }
            this.poleRadius = 0.18f;
        }
        return this.poleRadius;
    }

    @Override
    public int canPlaceSign(Sign sign, boolean top) {
        Sign[] row;
        int signIndex = top ? this.topEmptySignIndex : this.bottomEmptySignIndex;
        Sign[] signArray = row = top ? this.topRow : this.bottomRow;
        if (signIndex == 0) {
            return 1;
        }
        boolean useOldWorkingChecksThatReallyNeedToBeCleanedUp = true;
        if (useOldWorkingChecksThatReallyNeedToBeCleanedUp) {
            float minRot = row[0].angleDegrees - 139.0f;
            float maxRot = row[0].angleDegrees - 221.0f;
            if (sign.angleDegrees == row[0].angleDegrees) {
                return -1;
            }
            if (Utils.valueBetween(sign.angleDegrees + 180.0f, row[0].angleDegrees - 30.0f, row[0].angleDegrees + 30.0f)) {
                return 1;
            }
            if (Utils.valueBetween(sign.angleDegrees - 180.0f, row[0].angleDegrees - 30.0f, row[0].angleDegrees + 30.0f)) {
                return 1;
            }
            if (Utils.valueBetween(sign.angleDegrees, minRot, maxRot)) {
                return 1;
            }
            if (Utils.valueBetween(sign.angleDegrees + 180.0f, minRot, maxRot)) {
                return -1;
            }
            if (Utils.valueBetween(sign.angleDegrees - 180.0f, minRot, maxRot)) {
                return -1;
            }
            if (Utils.valueBetween(-sign.angleDegrees, minRot, maxRot)) {
                return -1;
            }
        } else {
            float zeroOffset = 0.0f - row[0].angleDegrees;
            float nextAvailableRotation = 139.0f;
            float maxAvailableRotation = 221.0f;
            if (Utils.valueBetween(sign.angleDegrees + zeroOffset, -30.0f, 30.0f)) {
                return -1;
            }
            if (Utils.valueBetween(sign.angleDegrees + zeroOffset, nextAvailableRotation, maxAvailableRotation)) {
                return 1;
            }
            if (Utils.valueBetween(sign.angleDegrees + 180.0f + zeroOffset, nextAvailableRotation, maxAvailableRotation)) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public boolean addSign(Sign sign, int side, boolean top) {
        int signIsFacing;
        int placementTest;
        int rowIndex;
        int n = rowIndex = top ? this.topEmptySignIndex : this.bottomEmptySignIndex;
        if (rowIndex == 2) {
            return false;
        }
        sign.calculateAngleToDestination(new CoordinateBlock(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e));
        int directionFacingToPlayer = Direction.field_71579_d[side];
        CoordinateBlock coord = new CoordinateBlock(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int directionOfWaypoint = Utils.mcDirectionTo(coord.x - sign.destination.coord.x, coord.z - sign.destination.coord.z);
        int directionFlatOfSignFaces = Direction.field_71578_g[directionOfWaypoint];
        sign.angleDegrees = MathHelper.func_76142_g((float)sign.angleDegrees);
        if (directionFlatOfSignFaces != directionFacingToPlayer) {
            sign.angleDegrees += 180.0f;
        }
        if ((placementTest = this.canPlaceSign(sign, top)) == 0) {
            return false;
        }
        if (placementTest < 0) {
            sign.angleDegrees += 180.0f;
        }
        sign.angleDegrees = MathHelper.func_76142_g((float)sign.angleDegrees);
        SignModels.SignOrientation pointingTo = SignModels.values()[sign.type].orientation;
        int leftOrientationMCDirection = MathHelper.func_76128_c((double)((double)((sign.angleDegrees + 90.0f) * 4.0f / 360.0f) + 0.5)) & 3;
        int rightOrientationMCDirection = Direction.field_71580_e[leftOrientationMCDirection];
        int n2 = signIsFacing = pointingTo == SignModels.SignOrientation.Right || pointingTo == SignModels.SignOrientation.Either ? rightOrientationMCDirection : leftOrientationMCDirection;
        if (directionOfWaypoint != signIsFacing) {
            if (pointingTo != SignModels.SignOrientation.Either && SignModels.values()[sign.type].reversible) {
                sign.flipped = true;
            }
            sign.arrowLocation = SignModels.SignOrientation.Left;
        }
        Sign[] row = top ? this.topRow : this.bottomRow;
        row[rowIndex] = sign;
        float f = sign.bottomHeight = top ? 0.5f : 0.0f;
        if (top) {
            ++this.topEmptySignIndex;
        } else {
            ++this.bottomEmptySignIndex;
        }
        return true;
    }

    public void func_145841_b(NBTTagCompound NBTTag) {
        super.func_145841_b(NBTTag);
        if (this.topRow[0] != null) {
            NBTTag.func_74782_a("sign1", (NBTBase)this.topRow[0].toNBT());
        }
        if (this.topRow[1] != null) {
            NBTTag.func_74782_a("sign2", (NBTBase)this.topRow[1].toNBT());
        }
        if (this.bottomRow[0] != null) {
            NBTTag.func_74782_a("sign3", (NBTBase)this.bottomRow[0].toNBT());
        }
        if (this.bottomRow[1] != null) {
            NBTTag.func_74782_a("sign4", (NBTBase)this.bottomRow[1].toNBT());
        }
    }

    public void func_145839_a(NBTTagCompound NBTTag) {
        super.func_145839_a(NBTTag);
        if (NBTTag.func_74764_b("sign1")) {
            this.topRow[0] = new Sign((NBTTagCompound)NBTTag.func_74781_a("sign1"));
            ++this.topEmptySignIndex;
        }
        if (NBTTag.func_74764_b("sign2")) {
            this.topRow[1] = new Sign((NBTTagCompound)NBTTag.func_74781_a("sign2"));
            ++this.topEmptySignIndex;
        }
        if (NBTTag.func_74764_b("sign3")) {
            this.bottomRow[0] = new Sign((NBTTagCompound)NBTTag.func_74781_a("sign3"));
            ++this.bottomEmptySignIndex;
        }
        if (NBTTag.func_74764_b("sign4")) {
            this.bottomRow[1] = new Sign((NBTTagCompound)NBTTag.func_74781_a("sign4"));
            ++this.bottomEmptySignIndex;
        }
    }

    public Packet func_145844_m() {
        return PacketManager.toMcPacket(new Packet0x02FullTileEntityNBT(this));
    }

    public CoordinateBlock getCoordinateBlock() {
        return new CoordinateBlock(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void leftClick(EntityPlayer player) {
    }

    public Sign getClickedSign(int side, float xHit, float yHit, float zHit) {
        if ((double)yHit > 0.5) {
            for (Sign sign : this.topRow) {
                if (sign == null || !sign.getSides().contains(ForgeDirection.values()[side])) continue;
                return sign;
            }
        } else {
            for (Sign sign : this.bottomRow) {
                if (sign == null || !sign.getSides().contains(ForgeDirection.values()[side])) continue;
                return sign;
            }
        }
        return null;
    }

    public WaypointManager.Waypoint getPoleWaypoint() {
        WaypointManager.Waypoint wp = null;
        int y = this.field_145848_d;
        while (wp == null && this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e) instanceof TileEntityPole) {
            wp = WaypointManager.INSTANCE.getWaypoint(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, y, this.field_145849_e);
            --y;
        }
        return wp;
    }

    public boolean rightClick(EntityPlayer player, int side, float xHit, float yHit, float zHit) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        ItemStack stack = player.func_70694_bm();
        if (stack == null || !(stack.func_77973_b() instanceof ItemPoleSign) && !(stack.func_77973_b() instanceof ItemGlowCrumb)) {
            Sign sign = this.getClickedSign(side, xHit, yHit, zHit);
            if (sign != null) {
                WaypointManager.Waypoint end = sign.destination;
                WaypointManager.Waypoint start = this.getPoleWaypoint();
                if (!player.func_70093_af()) {
                    PacketManager.sendToPlayer(new Packet0x07CustomPath(start, end, sign), player);
                    return true;
                }
                PathManager.INSTANCE.removePath(start, end);
                PacketManager.sendToPlayer(new Packet0x0CClearFlypath(sign.destination.coord), player);
                PacketManager.sendLocalizedChat(player, LocalizedChat.PATH_CLEARED, sign.text);
            }
        } else {
            if (stack.func_77973_b() instanceof ItemPoleSign) {
                PacketManager.sendToPlayer(new Packet0x03WaypointList(this, side, yHit > 0.5f, stack.func_77960_j()), player);
                return true;
            }
            if (stack.func_77973_b() instanceof ItemGlowCrumb) {
                Sign sign = this.getClickedSign(side, xHit, yHit, zHit);
                if (sign != null) {
                    WaypointManager.Waypoint start = this.getPoleWaypoint();
                    WaypointManager.Waypoint end = sign.destination;
                    if (start == null) {
                        return false;
                    }
                    ItemStack linked = new ItemStack((Item)RPGAdvMod.itemCrumbLinked, stack.field_77994_a);
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74782_a("wpStart", (NBTBase)start.toNBT());
                    tag.func_74782_a("wpEnd", (NBTBase)end.toNBT());
                    tag.func_74782_a("sign", (NBTBase)sign.toNBT());
                    linked.func_77982_d(tag);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, linked);
                    PacketManager.sendLocalizedChat(player, LocalizedChat.PATH_CREATE_START, sign.text);
                }
                return true;
            }
        }
        return false;
    }
}

