/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mantle.blocks.abstracts.InventoryLogic;
import mantle.blocks.abstracts.MultiServantLogic;
import mantle.blocks.iface.IActiveLogic;
import mantle.blocks.iface.IFacingLogic;
import mantle.blocks.iface.IMasterLogic;
import mantle.blocks.iface.IServantLogic;
import mantle.world.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import tconstruct.library.crafting.Smeltery;
import tconstruct.smeltery.SmelteryDamageSource;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.smeltery.inventory.SmelteryContainer;
import tconstruct.smeltery.logic.LavaTankLogic;
import tconstruct.util.config.PHConstruct;

public class SmelteryLogic
extends InventoryLogic
implements IActiveLogic,
IFacingLogic,
IFluidTank,
IMasterLogic {
    private static final int MAX_SMELTERY_SIZE = 7;
    public static final int MB_PER_BLOCK_CAPACITY = 1440;
    public boolean validStructure;
    public boolean tempValidStructure;
    protected byte direction;
    public CoordTuple minPos = new CoordTuple(0.0, 0.0, 0.0);
    public CoordTuple maxPos = new CoordTuple(0.0, 0.0, 0.0);
    public int layers;
    public int maxBlockCapacity;
    protected int internalTemp;
    public int useTime;
    public int fuelGague;
    public int fuelAmount;
    protected boolean inUse;
    protected ArrayList<CoordTuple> lavaTanks;
    protected CoordTuple activeLavaTank;
    public int[] activeTemps;
    public int[] meltingTemps;
    private int tick;
    public ArrayList<FluidStack> moltenMetal = new ArrayList();
    public int maxLiquid;
    public int currentLiquid;
    Random rand = new Random();
    boolean needsUpdate;

    public SmelteryLogic() {
        super(0);
        this.lavaTanks = new ArrayList();
        this.activeTemps = new int[0];
        this.meltingTemps = new int[0];
    }

    public int getBlocksPerLayer() {
        int xd = this.maxPos.x - this.minPos.x + 1;
        int zd = this.maxPos.z - this.minPos.z + 1;
        return xd * zd;
    }

    public int getCapacityPerLayer() {
        return this.getBlocksPerLayer() * 1440;
    }

    public int getBlockCapacity() {
        return this.maxBlockCapacity;
    }

    void adjustLayers(int lay, boolean forceAdjust) {
        if (lay != this.layers || forceAdjust) {
            int i;
            this.needsUpdate = true;
            this.layers = lay;
            this.maxBlockCapacity = this.getBlocksPerLayer() * this.layers;
            this.maxLiquid = this.maxBlockCapacity * 1440;
            int[] tempActive = this.activeTemps;
            this.activeTemps = new int[this.maxBlockCapacity];
            int activeLength = tempActive.length > this.activeTemps.length ? this.activeTemps.length : tempActive.length;
            System.arraycopy(tempActive, 0, this.activeTemps, 0, activeLength);
            int[] tempMelting = this.meltingTemps;
            this.meltingTemps = new int[this.maxBlockCapacity];
            int meltingLength = tempMelting.length > this.meltingTemps.length ? this.meltingTemps.length : tempMelting.length;
            System.arraycopy(tempMelting, 0, this.meltingTemps, 0, meltingLength);
            ItemStack[] tempInv = this.inventory;
            this.inventory = new ItemStack[this.maxBlockCapacity];
            int invLength = tempInv.length > this.inventory.length ? this.inventory.length : tempInv.length;
            System.arraycopy(tempInv, 0, this.inventory, 0, invLength);
            if (this.activeTemps.length > 0 && this.activeTemps.length > tempActive.length) {
                for (i = tempActive.length; i < this.activeTemps.length; ++i) {
                    this.activeTemps[i] = 200;
                    this.meltingTemps[i] = 200;
                }
            }
            if (tempInv.length > this.inventory.length) {
                for (i = this.inventory.length; i < tempInv.length; ++i) {
                    ItemStack stack = tempInv[i];
                    if (stack == null) continue;
                    float jumpX = this.rand.nextFloat() * 0.8f + 0.1f;
                    float jumpY = this.rand.nextFloat() * 0.8f + 0.1f;
                    float jumpZ = this.rand.nextFloat() * 0.8f + 0.1f;
                    int offsetX = 0;
                    int offsetZ = 0;
                    switch (this.getRenderDirection()) {
                        case 2: {
                            offsetZ = -1;
                            break;
                        }
                        case 3: {
                            offsetZ = 1;
                            break;
                        }
                        case 4: {
                            offsetX = -1;
                            break;
                        }
                        case 5: {
                            offsetX = 1;
                        }
                    }
                    while (stack.field_77994_a > 0) {
                        int itemSize = this.rand.nextInt(21) + 10;
                        if (itemSize > stack.field_77994_a) {
                            itemSize = stack.field_77994_a;
                        }
                        stack.field_77994_a -= itemSize;
                        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + jumpX + (float)offsetX), (double)((float)this.field_145848_d + jumpY), (double)((float)this.field_145849_e + jumpZ + (float)offsetZ), new ItemStack(stack.func_77973_b(), itemSize, stack.func_77960_j()));
                        if (stack.func_77942_o()) {
                            entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                        }
                        float offset = 0.05f;
                        entityitem.field_70159_w = (float)this.rand.nextGaussian() * offset;
                        entityitem.field_70181_x = (float)this.rand.nextGaussian() * offset + 0.2f;
                        entityitem.field_70179_y = (float)this.rand.nextGaussian() * offset;
                        this.field_145850_b.func_72838_d((Entity)entityitem);
                    }
                }
            }
        }
        this.updateCurrentLiquid();
    }

    public String getDefaultName() {
        return "crafters.Smeltery";
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new SmelteryContainer(inventoryplayer, this);
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
        switch (facing) {
            case 0: {
                this.direction = (byte)2;
                break;
            }
            case 1: {
                this.direction = (byte)5;
                break;
            }
            case 2: {
                this.direction = (byte)3;
                break;
            }
            case 3: {
                this.direction = (byte)4;
            }
        }
    }

    public boolean getActive() {
        return this.validStructure;
    }

    public void setActive(boolean flag) {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getScaledFuelGague(int scale) {
        int ret = this.fuelGague * scale / 52;
        if (ret < 1) {
            ret = 1;
        }
        return ret;
    }

    public int getInternalTemperature() {
        if (!this.validStructure) {
            return 20;
        }
        return this.internalTemp;
    }

    public int getTempForSlot(int slot) {
        return this.activeTemps[slot] / 10;
    }

    public int getMeltingPointForSlot(int slot) {
        return this.meltingTemps[slot] / 10;
    }

    public void func_145845_h() {
        ++this.tick;
        if (this.tick == 60) {
            this.tick = 0;
            this.detectEntities();
        }
        if (this.tick % 4 == 0) {
            if (this.useTime > 0) {
                this.useTime -= 4;
            }
            if (this.validStructure) {
                this.checkHasItems();
                if (this.useTime <= 0 && this.inUse) {
                    this.updateFuelGague();
                }
                this.heatItems();
            }
        }
        if (this.tick % 20 == 0) {
            if (!this.validStructure) {
                this.checkValidPlacement();
            }
            if (this.needsUpdate) {
                this.needsUpdate = false;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    void detectEntities() {
        if (this.minPos == null || this.maxPos == null) {
            return;
        }
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)this.minPos.x, (double)this.minPos.y, (double)this.minPos.z, (double)(this.maxPos.x + 1), (double)(this.minPos.y + this.layers), (double)(this.maxPos.z + 1));
        List list = this.field_145850_b.func_72872_a(Entity.class, box);
        for (Object o : list) {
            if (this.moltenMetal.size() >= 1) {
                EntityLivingBase living;
                int amount;
                EntityVillager villager;
                if (o instanceof EntityVillager && PHConstruct.meltableVillagers) {
                    villager = (EntityVillager)o;
                    if (!villager.func_70097_a((DamageSource)new SmelteryDamageSource(), 5.0f) || this.currentLiquid + 40 >= this.maxLiquid) continue;
                    amount = villager.func_70631_g_() ? 5 : 40;
                    this.fill(new FluidStack(TinkerSmeltery.moltenEmeraldFluid, amount), true);
                    continue;
                }
                if (o instanceof EntityEnderman) {
                    villager = (EntityEnderman)o;
                    if (!villager.func_70097_a((DamageSource)new SmelteryDamageSource(), 5.0f) || this.currentLiquid + 125 >= this.maxLiquid) continue;
                    this.fill(new FluidStack(TinkerSmeltery.moltenEnderFluid, 125), true);
                    continue;
                }
                if (o instanceof EntityIronGolem) {
                    EntityIronGolem golem = (EntityIronGolem)o;
                    if (!golem.func_70097_a((DamageSource)new SmelteryDamageSource(), 5.0f) || this.currentLiquid + 40 >= this.maxLiquid) continue;
                    this.fill(new FluidStack(TinkerSmeltery.moltenIronFluid, 40), true);
                    continue;
                }
                if (o instanceof EntityHorse && PHConstruct.meltableHorses) {
                    EntityHorse horse = (EntityHorse)o;
                    if (!horse.func_70097_a((DamageSource)new SmelteryDamageSource(), 5.0f) || this.currentLiquid + 108 >= this.maxLiquid) continue;
                    this.fill(new FluidStack(TinkerSmeltery.glueFluid, 108), true);
                    continue;
                }
                if (!(o instanceof EntityLivingBase) || !(living = (EntityLivingBase)o).func_70097_a((DamageSource)new SmelteryDamageSource(), 5.0f) || this.currentLiquid + 40 >= this.maxLiquid) continue;
                amount = living.func_70631_g_() || living instanceof EntityPlayer ? 5 : 40;
                this.fill(new FluidStack(TinkerSmeltery.bloodFluid, amount), true);
                continue;
            }
            if (!PHConstruct.throwableSmeltery || !(o instanceof EntityItem)) continue;
            this.handleItemEntity((EntityItem)o);
        }
    }

    private void handleItemEntity(EntityItem item) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        item.field_70292_b = 0;
        ItemStack istack = item.func_92059_d();
        if (istack == null || istack.field_77994_a <= 0) {
            return;
        }
        int maxSlot = this.func_70302_i_();
        boolean itemDestroyed = false;
        boolean itemAdded = false;
        for (int i = 0; i < maxSlot; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack != null || istack.field_77994_a <= 0) continue;
            ItemStack copy = istack.func_77979_a(1);
            this.func_70299_a(i, copy);
            itemAdded = true;
            if (istack.field_77994_a > 0) continue;
            item.func_70106_y();
            itemDestroyed = true;
            break;
        }
        if (!itemDestroyed) {
            item.func_92058_a(istack);
        }
        if (itemAdded) {
            this.needsUpdate = true;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void checkHasItems() {
        this.inUse = false;
        for (int i = 0; i < this.maxBlockCapacity; ++i) {
            if (!this.isStackInSlot(i) || this.meltingTemps[i] <= 200) continue;
            this.inUse = true;
            break;
        }
    }

    private void heatItems() {
        if (this.useTime > 0) {
            boolean hasUse = false;
            int temperature = this.getInternalTemperature();
            int speed = temperature / 100;
            int refTemp = temperature * 10;
            for (int i = 0; i < this.maxBlockCapacity; ++i) {
                if (this.meltingTemps[i] > 200 && this.isStackInSlot(i)) {
                    FluidStack result;
                    hasUse = true;
                    if (this.activeTemps[i] < refTemp && this.activeTemps[i] < this.meltingTemps[i]) {
                        int n = i;
                        this.activeTemps[n] = this.activeTemps[n] + speed;
                        continue;
                    }
                    if (this.activeTemps[i] < this.meltingTemps[i] || this.field_145850_b.field_72995_K || (result = this.getResultFor(this.inventory[i])) == null || !this.addMoltenMetal(result, false)) continue;
                    this.inventory[i] = null;
                    this.activeTemps[i] = 200;
                    ArrayList alloys = Smeltery.mixMetals(this.moltenMetal);
                    for (int al = 0; al < alloys.size(); ++al) {
                        FluidStack liquid = (FluidStack)alloys.get(al);
                        this.addMoltenMetal(liquid, true);
                    }
                    this.func_70296_d();
                    continue;
                }
                this.activeTemps[i] = 200;
            }
            this.inUse = hasUse;
        }
    }

    boolean addMoltenMetal(FluidStack liquid, boolean first) {
        this.needsUpdate = true;
        if (this.moltenMetal.size() == 0) {
            if (liquid.amount > this.getCapacity()) {
                return false;
            }
            this.moltenMetal.add(liquid.copy());
            this.updateCurrentLiquid();
            return true;
        }
        this.updateCurrentLiquid();
        if (liquid.amount + this.currentLiquid > this.maxLiquid) {
            return false;
        }
        this.currentLiquid += liquid.amount;
        boolean added = false;
        for (int i = 0; i < this.moltenMetal.size(); ++i) {
            FluidStack l = this.moltenMetal.get(i);
            if (l.isFluidEqual(liquid)) {
                l.amount += liquid.amount;
                added = true;
            }
            if (l.amount > 0) continue;
            this.moltenMetal.remove(l);
            --i;
        }
        if (!added) {
            if (first) {
                this.moltenMetal.add(0, liquid.copy());
            } else {
                this.moltenMetal.add(liquid.copy());
            }
        }
        return true;
    }

    private void updateCurrentLiquid() {
        this.currentLiquid = 0;
        for (FluidStack liquid : this.moltenMetal) {
            this.currentLiquid += liquid.amount;
        }
    }

    private void updateTemperatures() {
        for (int i = 0; i < this.maxBlockCapacity; ++i) {
            this.meltingTemps[i] = Smeltery.getLiquifyTemperature(this.inventory[i]) * 10;
        }
    }

    public void updateFuelDisplay() {
        this.verifyFuelTank();
        if (this.activeLavaTank == null) {
            this.fuelAmount = 0;
            this.fuelGague = 0;
            return;
        }
        IFluidHandler tankContainer = (IFluidHandler)this.field_145850_b.func_147438_o(this.activeLavaTank.x, this.activeLavaTank.y, this.activeLavaTank.z);
        FluidTankInfo[] info = tankContainer.getTankInfo(ForgeDirection.DOWN);
        int capacity = info[0].capacity;
        this.fuelAmount = info[0].fluid.amount;
        this.fuelGague = (int)((float)this.fuelAmount * 52.0f / (float)capacity);
    }

    public void updateFuelGague() {
        if (this.useTime > 0 || !this.inUse) {
            return;
        }
        this.verifyFuelTank();
        if (this.activeLavaTank == null) {
            return;
        }
        IFluidHandler tankContainer = (IFluidHandler)this.field_145850_b.func_147438_o(this.activeLavaTank.x, this.activeLavaTank.y, this.activeLavaTank.z);
        FluidStack liquid = tankContainer.drain(ForgeDirection.DOWN, 15, false);
        if (liquid != null && Smeltery.isSmelteryFuel(liquid.getFluid())) {
            while ((liquid = tankContainer.drain(ForgeDirection.DOWN, 15, true)) != null && liquid.amount != 0) {
                this.useTime += (int)((float)Smeltery.getFuelDuration(liquid.getFluid()) * (float)Math.round(15.0f / (float)liquid.amount));
                this.internalTemp = Smeltery.getFuelPower(liquid.getFluid());
                if (this.useTime < 0) continue;
            }
            this.updateFuelDisplay();
        }
    }

    protected void verifyFuelTank() {
        FluidStack liquid;
        TileEntity tankContainer;
        if (this.activeLavaTank != null && this.field_145850_b.func_72899_e(this.activeLavaTank.x, this.activeLavaTank.y, this.activeLavaTank.z) && (tankContainer = this.field_145850_b.func_147438_o(this.activeLavaTank.x, this.activeLavaTank.y, this.activeLavaTank.z)) instanceof IFluidHandler && (liquid = ((IFluidHandler)tankContainer).drain(ForgeDirection.DOWN, 15, false)) != null && Smeltery.isSmelteryFuel(liquid.getFluid())) {
            return;
        }
        this.activeLavaTank = null;
        for (CoordTuple tank : this.lavaTanks) {
            FluidTankInfo[] info;
            TileEntity tankContainer2;
            if (!this.field_145850_b.func_72899_e(tank.x, tank.y, tank.z) || !((tankContainer2 = this.field_145850_b.func_147438_o(tank.x, tank.y, tank.z)) instanceof IFluidHandler) || (info = ((IFluidHandler)tankContainer2).getTankInfo(ForgeDirection.DOWN)).length <= 0 || info[0].fluid == null || info[0].fluid.amount <= 0 || !Smeltery.isSmelteryFuel(info[0].fluid.getFluid())) continue;
            this.activeLavaTank = tank;
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public FluidStack getFuel() {
        if (this.activeLavaTank == null) {
            return new FluidStack(FluidRegistry.LAVA, 0);
        }
        TileEntity tankContainer = this.field_145850_b.func_147438_o(this.activeLavaTank.x, this.activeLavaTank.y, this.activeLavaTank.z);
        if (tankContainer instanceof IFluidHandler) {
            return ((IFluidHandler)tankContainer).getTankInfo((ForgeDirection)ForgeDirection.DOWN)[0].fluid;
        }
        return new FluidStack(FluidRegistry.LAVA, 0);
    }

    public FluidStack getResultFor(ItemStack stack) {
        return Smeltery.getSmelteryResult(stack);
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        this.updateTemperatures();
        this.func_145845_h();
        super.func_70296_d();
        this.needsUpdate = true;
    }

    public void notifyChange(IServantLogic servant, int x, int y, int z) {
        this.checkValidPlacement();
    }

    public void checkValidPlacement() {
        switch (this.getRenderDirection()) {
            case 2: {
                this.alignInitialPlacement(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                break;
            }
            case 3: {
                this.alignInitialPlacement(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                break;
            }
            case 4: {
                this.alignInitialPlacement(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 5: {
                this.alignInitialPlacement(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public void alignInitialPlacement(int x, int y, int z) {
        int xd1 = 1;
        int xd2 = 1;
        for (int i = 1; i < 7; ++i) {
            if (this.field_145850_b.func_147439_a(x - xd1, y, z) == null || this.field_145850_b.func_147437_c(x - xd1, y, z)) {
                ++xd1;
            } else if (this.field_145850_b.func_147439_a(x + xd2, y, z) == null || this.field_145850_b.func_147437_c(x + xd2, y, z)) {
                ++xd2;
            }
            if (xd1 - xd2 > 1) {
                --xd1;
                --x;
                ++xd2;
            }
            if (xd2 - xd1 <= 1) continue;
            --xd2;
            ++x;
            ++xd1;
        }
        int zd1 = 1;
        int zd2 = 1;
        for (int i = 1; i < 7; ++i) {
            if (this.field_145850_b.func_147439_a(x, y, z - zd1) == null || this.field_145850_b.func_147437_c(x, y, z - zd1)) {
                ++zd1;
            } else if (this.field_145850_b.func_147439_a(x, y, z + zd2) == null || this.field_145850_b.func_147437_c(x, y, z + zd2)) {
                ++zd2;
            }
            if (zd1 - zd2 > 1) {
                --zd1;
                --z;
                ++zd2;
            }
            if (zd2 - zd1 <= 1) continue;
            --zd2;
            ++z;
            ++zd1;
        }
        int[] sides = new int[]{xd1, xd2, zd1, zd2};
        this.checkValidStructure(x, y, z, sides);
    }

    public void checkValidStructure(int x, int y, int z, int[] sides) {
        int checkLayers = 0;
        this.tempValidStructure = false;
        if (this.checkSameLevel(x, y, z, sides)) {
            ++checkLayers;
            checkLayers += this.recurseStructureUp(x, y + 1, z, sides, 0);
            checkLayers += this.recurseStructureDown(x, y - 1, z, sides, 0);
        }
        if (this.tempValidStructure != this.validStructure || checkLayers != this.layers) {
            if (this.tempValidStructure) {
                this.activeLavaTank = null;
                for (CoordTuple tank : this.lavaTanks) {
                    FluidStack liquid;
                    TileEntity tankContainer = this.field_145850_b.func_147438_o(tank.x, tank.y, tank.z);
                    if (!(tankContainer instanceof IFluidHandler) || (liquid = ((IFluidHandler)tankContainer).getTankInfo((ForgeDirection)ForgeDirection.DOWN)[0].fluid) == null || !Smeltery.isSmelteryFuel(liquid.getFluid())) continue;
                    this.internalTemp = Smeltery.getFuelPower(liquid.getFluid());
                    this.activeLavaTank = tank;
                    break;
                }
                if (this.activeLavaTank == null) {
                    this.activeLavaTank = this.lavaTanks.get(0);
                }
                this.adjustLayers(checkLayers, true);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.validStructure = true;
            } else {
                this.internalTemp = 20;
                if (this.validStructure) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                this.validStructure = false;
            }
        }
    }

    public boolean checkBricksOnLevel(int x, int y, int z, int[] sides) {
        int xPos;
        int numBricks = 0;
        int xMin = x - sides[0];
        int xMax = x + sides[1];
        int zMin = z - sides[2];
        int zMax = z + sides[3];
        for (xPos = xMin + 1; xPos <= xMax - 1; ++xPos) {
            for (int zPos = zMin + 1; zPos <= zMax - 1; ++zPos) {
                Block block = this.field_145850_b.func_147439_a(xPos, y, zPos);
                if (block == null || this.field_145850_b.func_147437_c(xPos, y, zPos)) continue;
                return false;
            }
        }
        for (xPos = xMin + 1; xPos <= xMax - 1; ++xPos) {
            numBricks += this.checkBricks(xPos, y, zMin);
            numBricks += this.checkBricks(xPos, y, zMax);
        }
        for (int zPos = zMin + 1; zPos <= zMax - 1; ++zPos) {
            numBricks += this.checkBricks(xMin, y, zPos);
            numBricks += this.checkBricks(xMax, y, zPos);
        }
        int neededBricks = (xMax - xMin) * 2 + (zMax - zMin) * 2 - 4;
        return numBricks == neededBricks;
    }

    public boolean checkSameLevel(int x, int y, int z, int[] sides) {
        this.lavaTanks.clear();
        boolean check = this.checkBricksOnLevel(x, y, z, sides);
        return check && this.lavaTanks.size() > 0;
    }

    public int recurseStructureUp(int x, int y, int z, int[] sides, int count) {
        boolean check = this.checkBricksOnLevel(x, y, z, sides);
        if (!check) {
            return count;
        }
        return this.recurseStructureUp(x, y + 1, z, sides, ++count);
    }

    public int recurseStructureDown(int x, int y, int z, int[] sides, int count) {
        boolean check = this.checkBricksOnLevel(x, y, z, sides);
        if (!check) {
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            if (block != null && !this.field_145850_b.func_147437_c(x, y, z) && this.validBlockID(block)) {
                return this.validateBottom(x, y, z, sides, count);
            }
            return count;
        }
        return this.recurseStructureDown(x, y - 1, z, sides, ++count);
    }

    public int validateBottom(int x, int y, int z, int[] sides, int count) {
        int bottomBricks = 0;
        int xMin = x - sides[0] + 1;
        int xMax = x + sides[1] - 1;
        int zMin = z - sides[2] + 1;
        int zMax = z + sides[3] - 1;
        for (int xPos = xMin; xPos <= xMax; ++xPos) {
            for (int zPos = zMin; zPos <= zMax; ++zPos) {
                TileEntity te;
                if (!this.validBlockID(this.field_145850_b.func_147439_a(xPos, y, zPos)) || this.field_145850_b.func_72805_g(xPos, y, zPos) < 2 || !((te = this.field_145850_b.func_147438_o(xPos, y, zPos)) instanceof MultiServantLogic)) continue;
                MultiServantLogic servant = (MultiServantLogic)te;
                if (servant.hasValidMaster()) {
                    if (!servant.verifyMaster((IMasterLogic)this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) continue;
                    ++bottomBricks;
                    continue;
                }
                servant.overrideMaster(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                ++bottomBricks;
            }
        }
        int neededBricks = (xMax + 1 - xMin) * (zMax + 1 - zMin);
        if (bottomBricks == neededBricks) {
            this.tempValidStructure = true;
            this.minPos = new CoordTuple((double)xMin, (double)(y + 1), (double)zMin);
            this.maxPos = new CoordTuple((double)xMax, (double)(y + 1), (double)zMax);
        }
        return count;
    }

    int checkBricks(int x, int y, int z) {
        int tempBricks = 0;
        Block blockID = this.field_145850_b.func_147439_a(x, y, z);
        if (this.validBlockID(blockID) || this.validTankID(blockID)) {
            TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
            if (te == this) {
                ++tempBricks;
            } else if (te instanceof MultiServantLogic) {
                MultiServantLogic servant = (MultiServantLogic)te;
                if (servant.hasValidMaster()) {
                    if (servant.verifyMaster((IMasterLogic)this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                        ++tempBricks;
                    }
                } else {
                    servant.overrideMaster(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    ++tempBricks;
                }
                if (te instanceof LavaTankLogic) {
                    this.lavaTanks.add(new CoordTuple((double)x, (double)y, (double)z));
                }
            }
        }
        return tempBricks;
    }

    boolean validBlockID(Block blockID) {
        return blockID == TinkerSmeltery.smeltery || blockID == TinkerSmeltery.smelteryNether;
    }

    boolean validTankID(Block blockID) {
        return blockID == TinkerSmeltery.lavaTank || blockID == TinkerSmeltery.lavaTankNether;
    }

    public int getCapacity() {
        return this.maxLiquid;
    }

    public int getTotalLiquid() {
        return this.currentLiquid;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.validStructure) {
            return null;
        }
        if (this.moltenMetal.size() == 0) {
            return null;
        }
        FluidStack liquid = this.moltenMetal.get(0);
        if (liquid != null) {
            if (liquid.amount - maxDrain <= 0) {
                FluidStack liq = liquid.copy();
                if (doDrain) {
                    this.moltenMetal.remove(liquid);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.needsUpdate = true;
                    this.updateCurrentLiquid();
                }
                return liq;
            }
            if (doDrain && maxDrain > 0) {
                liquid.amount -= maxDrain;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.currentLiquid -= maxDrain;
                this.needsUpdate = true;
            }
            return new FluidStack(liquid.fluidID, maxDrain, liquid.tag);
        }
        return new FluidStack(0, 0);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!this.validStructure) {
            return 0;
        }
        if (resource != null && this.currentLiquid < this.maxLiquid) {
            int amount;
            if (resource.amount + this.currentLiquid > this.maxLiquid) {
                resource.amount = this.maxLiquid - this.currentLiquid;
            }
            if ((amount = resource.amount) > 0 && doFill) {
                if (this.addMoltenMetal(resource, false)) {
                    ArrayList alloys = Smeltery.mixMetals(this.moltenMetal);
                    for (int al = 0; al < alloys.size(); ++al) {
                        FluidStack liquid = (FluidStack)alloys.get(al);
                        this.addMoltenMetal(liquid, true);
                    }
                }
                this.needsUpdate = true;
                this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return amount;
        }
        return 0;
    }

    public FluidStack getFluid() {
        if (this.moltenMetal.size() == 0) {
            return null;
        }
        return this.moltenMetal.get(0);
    }

    public int getFluidAmount() {
        return this.currentLiquid;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public FluidTankInfo[] getMultiTankInfo() {
        FluidTankInfo[] info = new FluidTankInfo[this.moltenMetal.size() + 1];
        for (int i = 0; i < this.moltenMetal.size(); ++i) {
            FluidStack fluid = this.moltenMetal.get(i);
            info[i] = new FluidTankInfo(fluid.copy(), fluid.amount);
        }
        info[this.moltenMetal.size()] = new FluidTankInfo(null, this.maxLiquid - this.currentLiquid);
        return info;
    }

    public void func_145839_a(NBTTagCompound tags) {
        this.layers = tags.func_74762_e("Layers");
        int[] pos = tags.func_74759_k("MinPos");
        this.minPos = pos.length > 2 ? new CoordTuple((double)pos[0], (double)pos[1], (double)pos[2]) : new CoordTuple((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        pos = tags.func_74759_k("MaxPos");
        this.maxPos = pos.length > 2 ? new CoordTuple((double)pos[0], (double)pos[1], (double)pos[2]) : new CoordTuple((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        this.maxBlockCapacity = this.getBlocksPerLayer() * this.layers;
        this.inventory = new ItemStack[this.maxBlockCapacity];
        super.func_145839_a(tags);
        this.internalTemp = tags.func_74762_e("InternalTemp");
        this.inUse = tags.func_74767_n("InUse");
        this.direction = tags.func_74771_c("Direction");
        this.useTime = tags.func_74762_e("UseTime");
        this.currentLiquid = tags.func_74762_e("CurrentLiquid");
        this.maxLiquid = tags.func_74762_e("MaxLiquid");
        this.meltingTemps = tags.func_74759_k("MeltingTemps");
        this.activeTemps = tags.func_74759_k("ActiveTemps");
        NBTTagList liquidTag = tags.func_150295_c("Liquids", 10);
        this.moltenMetal.clear();
        for (int iter = 0; iter < liquidTag.func_74745_c(); ++iter) {
            NBTTagCompound nbt = liquidTag.func_150305_b(iter);
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            if (fluid == null) continue;
            this.moltenMetal.add(fluid);
        }
        if (!tags.func_74767_n("ValidStructure")) {
            this.validStructure = false;
        } else if (!this.validStructure && this.field_145850_b != null) {
            this.checkValidPlacement();
        }
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        tags.func_74757_a("ValidStructure", this.validStructure);
        tags.func_74768_a("InternalTemp", this.internalTemp);
        tags.func_74757_a("InUse", this.inUse);
        int[] pos = this.minPos == null ? new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e} : new int[]{this.minPos.x, this.minPos.y, this.minPos.z};
        tags.func_74783_a("MinPos", pos);
        pos = this.maxPos == null ? new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e} : new int[]{this.maxPos.x, this.maxPos.y, this.maxPos.z};
        tags.func_74783_a("MaxPos", pos);
        tags.func_74774_a("Direction", this.direction);
        tags.func_74768_a("UseTime", this.useTime);
        tags.func_74768_a("CurrentLiquid", this.currentLiquid);
        tags.func_74768_a("MaxLiquid", this.maxLiquid);
        tags.func_74768_a("Layers", this.layers);
        tags.func_74783_a("MeltingTemps", this.meltingTemps);
        tags.func_74783_a("ActiveTemps", this.activeTemps);
        NBTTagList taglist = new NBTTagList();
        for (FluidStack liquid : this.moltenMetal) {
            NBTTagCompound nbt = new NBTTagCompound();
            liquid.writeToNBT(nbt);
            taglist.func_74742_a((NBTBase)nbt);
        }
        tags.func_74782_a("Liquids", (NBTBase)taglist);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.func_70296_d();
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.needsUpdate = true;
    }

    public String func_145825_b() {
        return this.getDefaultName();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void func_70305_f() {
    }

    public void func_70295_k_() {
    }
}

