/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mantle.blocks.abstracts.InventoryBlock;
import mantle.blocks.abstracts.MultiServantLogic;
import mantle.blocks.iface.IFacingLogic;
import mantle.blocks.iface.IMasterLogic;
import mantle.blocks.iface.IServantLogic;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.smeltery.logic.SmelteryDrainLogic;
import tconstruct.smeltery.logic.SmelteryLogic;
import tconstruct.smeltery.model.SmelteryRender;

public class SmelteryBlock
extends InventoryBlock {
    Random rand;
    String texturePrefix = "";

    public SmelteryBlock() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(20.0f);
        this.func_149672_a(field_149777_j);
        this.rand = new Random();
        this.func_149647_a(TConstructRegistry.blockTab);
        this.func_149663_c("tconstruct.Smeltery");
    }

    public SmelteryBlock(String prefix) {
        this();
        this.texturePrefix = prefix;
    }

    public int func_149645_b() {
        return SmelteryRender.smelteryModel;
    }

    public String[] getTextureNames() {
        String[] textureNames = new String[]{"smeltery_side", "smeltery_inactive", "smeltery_active", "drain_side", "drain_out", "drain_basin", "searedbrick", "searedstone", "searedcobble", "searedpaver", "searedbrickcracked", "searedroad", "searedbrickfancy", "searedbricksquare", "searedcreeper"};
        if (!this.texturePrefix.equals("")) {
            for (int i = 0; i < textureNames.length; ++i) {
                textureNames[i] = this.texturePrefix + "_" + textureNames[i];
            }
        }
        return textureNames;
    }

    public String getTextureDomain(int textureNameIndex) {
        return "tinker";
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < 2) {
            int sideTex = side == 3 ? 1 : 0;
            return this.icons[sideTex + meta * 3];
        }
        if (meta == 2) {
            return this.icons[6];
        }
        if (meta == 11 && (side == 0 || side == 1)) {
            return this.icons[9];
        }
        return this.icons[3 + meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.func_147438_o(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            if (side == direction) {
                if (SmelteryBlock.isActive((IBlockAccess)world, (int)x, (int)y, (int)z)) {
                    return this.icons[2];
                }
                return this.icons[1];
            }
            return this.icons[0];
        }
        if (meta == 1) {
            if (side == direction) {
                return this.icons[5];
            }
            if (side / 2 == direction / 2) {
                return this.icons[4];
            }
            return this.icons[3];
        }
        if (meta == 2) {
            return this.icons[6];
        }
        if (meta == 11 && (side == 0 || side == 1)) {
            return this.icons[9];
        }
        return this.icons[3 + meta];
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return 7;
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (SmelteryBlock.isActive((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            TileEntity logic = world.func_147438_o(x, y, z);
            byte face = 0;
            if (logic instanceof IFacingLogic) {
                face = ((IFacingLogic)logic).getRenderDirection();
            }
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.5f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            switch (face) {
                case 4: {
                    world.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 5: {
                    world.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return !SmelteryBlock.isActive((IBlockAccess)world, (int)x, (int)y, (int)z) ? 0 : 9;
    }

    public Object getModInstance() {
        return TConstruct.instance;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        if (player.func_70093_af() || world.func_72805_g(x, y, z) != 0) {
            return false;
        }
        Integer integer = this.getGui(world, x, y, z, player);
        if (integer == null || integer == -1) {
            return false;
        }
        player.openGui(this.getModInstance(), integer.intValue(), world, x, y, z);
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new SmelteryLogic();
            }
            case 1: {
                return new SmelteryDrainLogic();
            }
            case 3: {
                return null;
            }
        }
        return new MultiServantLogic();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entityliving, stack);
        if (world.func_72805_g(x, y, z) == 0) {
            this.onBlockPlacedElsewhere(world, x, y, z, entityliving);
        }
    }

    public void onBlockPlacedElsewhere(World world, int x, int y, int z, EntityLivingBase entityliving) {
        SmelteryLogic logic = (SmelteryLogic)world.func_147438_o(x, y, z);
        logic.checkValidPlacement();
    }

    public void func_149666_a(Item id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 12; ++iter) {
            if (iter == 3) continue;
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity logic = world.func_147438_o(x, y, z);
        if (logic instanceof IServantLogic) {
            ((IServantLogic)logic).notifyMasterOfChange();
        } else if (logic instanceof IMasterLogic) {
            ((IMasterLogic)logic).notifyChange(null, x, y, z);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockID, int meta) {
        TileEntity logic = world.func_147438_o(x, y, z);
        if (logic instanceof IServantLogic) {
            ((IServantLogic)logic).notifyMasterOfChange();
        }
        super.func_149749_a(world, x, y, z, blockID, meta);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int comparatorSide) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            return Container.func_94526_b((IInventory)((SmelteryLogic)world.func_147438_o(x, y, z)));
        }
        if (meta == 1) {
            return ((SmelteryDrainLogic)world.func_147438_o(x, y, z)).comparatorStrength();
        }
        return 0;
    }
}

