/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingbook;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.blay09.mods.cookingbook.api.kitchen.IKitchenItemProvider;
import net.blay09.mods.cookingbook.api.kitchen.IKitchenSmeltingProvider;
import net.blay09.mods.cookingbook.api.kitchen.IKitchenStorageProvider;
import net.blay09.mods.cookingbook.api.kitchen.IMultiblockKitchen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class KitchenMultiBlock {
    private final Map<BlockPosition, IMultiblockKitchen> kitchenParts = new HashMap<BlockPosition, IMultiblockKitchen>();
    private final List<IKitchenStorageProvider> storageProviderList = new ArrayList<IKitchenStorageProvider>();
    private final List<IKitchenItemProvider> itemProviderList = new ArrayList<IKitchenItemProvider>();
    private final List<IKitchenSmeltingProvider> smeltingProviderList = new ArrayList<IKitchenSmeltingProvider>();
    private final List<IInventory> sourceInventories = new ArrayList<IInventory>();

    public KitchenMultiBlock(World world, int x, int y, int z) {
        this.findNeighbourKitchenBlocks(world, x, y, z);
    }

    private void findNeighbourKitchenBlocks(World world, int x, int y, int z) {
        for (int i = 1; i <= 5; ++i) {
            BlockPosition position;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            TileEntity tileEntity = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (!(tileEntity instanceof IMultiblockKitchen) || this.kitchenParts.containsKey(position = new BlockPosition(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ))) continue;
            this.kitchenParts.put(position, (IMultiblockKitchen)tileEntity);
            if (tileEntity instanceof IKitchenStorageProvider) {
                this.storageProviderList.add((IKitchenStorageProvider)tileEntity);
            }
            if (tileEntity instanceof IKitchenSmeltingProvider) {
                this.smeltingProviderList.add((IKitchenSmeltingProvider)tileEntity);
            }
            if (tileEntity instanceof IKitchenItemProvider) {
                this.itemProviderList.add((IKitchenItemProvider)tileEntity);
            }
            this.findNeighbourKitchenBlocks(world, position.x, position.y, position.z);
        }
    }

    public List<IInventory> getSourceInventories(InventoryPlayer playerInventory) {
        this.sourceInventories.clear();
        this.sourceInventories.add((IInventory)playerInventory);
        for (IKitchenStorageProvider provider : this.storageProviderList) {
            this.sourceInventories.add(provider.getInventory());
        }
        return this.sourceInventories;
    }

    public ItemStack smeltItem(ItemStack itemStack, int count) {
        IKitchenSmeltingProvider provider;
        ItemStack restStack = itemStack.func_77946_l().func_77979_a(count);
        Iterator<IKitchenSmeltingProvider> i$ = this.smeltingProviderList.iterator();
        while (i$.hasNext() && (restStack = (provider = i$.next()).smeltItem(restStack)) != null) {
        }
        itemStack.field_77994_a = itemStack.field_77994_a - (count - (restStack != null ? restStack.field_77994_a : 0));
        if (itemStack.field_77994_a <= 0) {
            return null;
        }
        return itemStack;
    }

    public boolean hasSmeltingProvider() {
        return this.smeltingProviderList.size() > 0;
    }

    public List<IKitchenItemProvider> getItemProviders() {
        return this.itemProviderList;
    }

    private class BlockPosition {
        public final int x;
        public final int y;
        public final int z;

        public BlockPosition(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockPosition that = (BlockPosition)o;
            if (this.x != that.x) {
                return false;
            }
            if (this.y != that.y) {
                return false;
            }
            return this.z == that.z;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            return result;
        }
    }
}

