/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy.world;

import com.teammetallurgy.metallurgycore.handlers.ConfigHandler;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGenMetals
implements IWorldGenerator {
    Block genBlock;
    int genMetaId;
    private int[] generation;
    private String dimensions;
    private WorldGenMinable mineable;
    private long blockSeed;
    private static ArrayList<WorldGenMetals> generators = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateAll(Random fmlRandom, int chunkXPos, int chunkZPos, WorldServer world, boolean b) {
        ArrayList<WorldGenMetals> arrayList = generators;
        synchronized (arrayList) {
            for (WorldGenMetals gen : generators) {
                gen.generate(fmlRandom, chunkXPos, chunkZPos, (World)world, b);
            }
        }
    }

    public WorldGenMetals(Block block, int metaId, int[] generationInfo, String dimensionsInfo) {
        this.genBlock = block;
        this.genMetaId = metaId;
        this.generation = generationInfo;
        this.dimensions = dimensionsInfo;
        Block targetId = Blocks.field_150348_b;
        if (this.vaildDimension(-1)) {
            targetId = Blocks.field_150424_aL;
        }
        if (this.vaildDimension(1)) {
            targetId = Blocks.field_150377_bs;
        }
        this.blockSeed = this.genBlockSeed(block, metaId);
        this.mineable = new WorldGenMinable(block, metaId, this.generation[1], targetId);
    }

    private long genBlockSeed(Block block, int meta) {
        long seed = 0L;
        String blockUName = block.func_149739_a();
        char[] name = blockUName.toCharArray();
        long hash = 0L;
        if (name.length > 0) {
            for (int i = 0; i < name.length; ++i) {
                hash = 31L * hash + (long)name[i];
            }
        }
        seed = hash * 31L;
        return seed += (long)meta;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, boolean firstGenerate) {
        if (firstGenerate || ConfigHandler.regen()) {
            Random chunkRand = this.getRandom(random, chunkX, chunkZ);
            int dimId = world.field_73011_w.field_76574_g;
            if (!this.vaildDimension(dimId)) {
                return;
            }
            if (chunkRand.nextInt(100) > this.generation[4]) {
                return;
            }
            for (int i = 0; i <= this.generation[0]; ++i) {
                int initX = chunkX * 16 + chunkRand.nextInt(16);
                int initY = this.generation[2] + chunkRand.nextInt(this.generation[3] - this.generation[2]);
                int initZ = chunkZ * 16 + chunkRand.nextInt(16);
                this.mineable.func_76484_a(world, chunkRand, initX, initY, initZ);
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        generators.add(this);
        this.generate(random, chunkX, chunkZ, world, true);
    }

    private Random getRandom(Random fmlRandom, int chunkX, int chunkZ) {
        long seed = fmlRandom.nextLong();
        seed = this.blockSeed * (long)this.genMetaId ^ fmlRandom.nextLong();
        seed = (long)(chunkX + chunkZ) * seed ^ (long)fmlRandom.nextInt(Integer.MAX_VALUE);
        return new Random(seed);
    }

    private boolean vaildDimension(int dimensionId) {
        boolean vaild = false;
        String[] dims = this.dimensions.split(" ");
        if (dims.length < 1) {
            return false;
        }
        for (String dim : dims) {
            if (dim.contains("-")) {
                String[] range = dim.split("-");
                if (range.length <= 1) continue;
                if (range[0].compareTo("") != 0) {
                    int low = Integer.parseInt(range[0]);
                    int high = Integer.parseInt(range[1]);
                    if (dimensionId < low || dimensionId > high) continue;
                    vaild = true;
                    break;
                }
                int canidateDim = -1 * Integer.parseInt(range[1]);
                if (canidateDim != dimensionId) continue;
                vaild = true;
                break;
            }
            int canidateDim = Integer.parseInt(dim);
            if (canidateDim != dimensionId) continue;
            vaild = true;
            break;
        }
        return vaild;
    }
}

