/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy.metals;

import com.google.gson.Gson;
import com.teammetallurgy.metallurgy.Utils;
import com.teammetallurgy.metallurgy.api.IMetalInfo;
import com.teammetallurgy.metallurgy.api.IMetalSet;
import com.teammetallurgy.metallurgy.api.MetalType;
import com.teammetallurgy.metallurgy.armor.ItemMetallurgyArmor;
import com.teammetallurgy.metallurgy.handlers.ConfigHandler;
import com.teammetallurgy.metallurgy.metals.ItemMetalBlock;
import com.teammetallurgy.metallurgy.metals.Metal;
import com.teammetallurgy.metallurgy.metals.MetalBlock;
import com.teammetallurgy.metallurgy.metals.MetalItem;
import com.teammetallurgy.metallurgy.metals.MoltenMetalBlock;
import com.teammetallurgy.metallurgy.tools.Axe;
import com.teammetallurgy.metallurgy.tools.Hoe;
import com.teammetallurgy.metallurgy.tools.Pickaxe;
import com.teammetallurgy.metallurgy.tools.Shovel;
import com.teammetallurgy.metallurgy.tools.Sword;
import com.teammetallurgy.metallurgy.world.WorldGenMetals;
import com.teammetallurgy.metallurgycore.handlers.LogHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class MetalSet
implements IMetalSet {
    private String name;
    private Metal[] metals = null;
    private String setTag;
    private MetalBlock defaultOre;
    private MetalBlock defaultBlock;
    private MetalBlock defaultBricks;
    private MetalItem defaultDust;
    private MetalItem defaultDrops;
    private HashMap<String, ItemStack> oreStacks = new HashMap();
    private HashMap<String, ItemStack> blockStacks = new HashMap();
    private HashMap<String, ItemStack> brickStacks = new HashMap();
    private HashMap<String, ItemStack> ingotStacks = new HashMap();
    private HashMap<String, ItemStack> dustStacks = new HashMap();
    private HashMap<String, ItemStack> dropStacks = new HashMap();
    private HashMap<String, ItemStack> axeStacks = new HashMap();
    private HashMap<String, ItemStack> hoeStacks = new HashMap();
    private HashMap<String, ItemStack> pickaxeStacks = new HashMap();
    private HashMap<String, ItemStack> shovelStacks = new HashMap();
    private HashMap<String, ItemStack> swordStacks = new HashMap();
    private HashMap<String, ItemStack> helmetStacks = new HashMap();
    private HashMap<String, ItemStack> chestplateStacks = new HashMap();
    private HashMap<String, ItemStack> leggingsStacks = new HashMap();
    private HashMap<String, ItemStack> bootsStacks = new HashMap();

    public MetalSet(String setName) {
        this.name = setName;
        this.setTag = this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
        this.initDefaults();
    }

    private MetalBlock createBlock(MetalBlock metalBlock, int meta, int harvestLvl, String metalTag, String identifier, boolean defaultOreDic, String[] oreDicAliases) {
        metalBlock.setHarvestLevel("pickaxe", harvestLvl, meta);
        if (meta == 0) {
            GameRegistry.registerBlock((Block)metalBlock, ItemMetalBlock.class, (String)(this.name + "." + identifier));
        }
        ItemStack blockStack = new ItemStack((Block)metalBlock, 1, meta);
        if (defaultOreDic) {
            OreDictionary.registerOre((String)(identifier + metalTag), (ItemStack)blockStack.func_77946_l());
        }
        if (oreDicAliases != null && oreDicAliases.length > 0) {
            for (int i = 0; i < oreDicAliases.length; ++i) {
                OreDictionary.registerOre((String)oreDicAliases[i], (ItemStack)blockStack.func_77946_l());
            }
        }
        return metalBlock;
    }

    private MetalItem createItem(MetalItem metalItem, int meta, String metalTag, String identifier, boolean defaultOreDic, String[] oreDicAliases) {
        if (meta == 0) {
            GameRegistry.registerItem((Item)metalItem, (String)(this.name + "." + identifier));
        }
        ItemStack itemStack = new ItemStack((Item)metalItem, 1, meta);
        if (defaultOreDic) {
            OreDictionary.registerOre((String)(identifier + metalTag), (ItemStack)itemStack.func_77946_l());
        }
        if (oreDicAliases != null && oreDicAliases.length > 0) {
            for (int i = 0; i < oreDicAliases.length; ++i) {
                OreDictionary.registerOre((String)oreDicAliases[i], (ItemStack)itemStack.func_77946_l());
            }
        }
        return metalItem;
    }

    public String[] createOreDicAliases(String identifier, String[] aliases) {
        String[] oreDicAliases = null;
        if (aliases != null && aliases.length > 0) {
            oreDicAliases = new String[aliases.length];
            for (int i = 0; i < aliases.length; ++i) {
                String alias = aliases[i];
                alias = alias.replace(" ", "");
                oreDicAliases[i] = identifier + alias;
            }
        }
        return oreDicAliases;
    }

    @Override
    public ItemStack getAxe(String metal) {
        return this.axeStacks.get(metal);
    }

    @Override
    public ItemStack getBlock(String metal) {
        return this.blockStacks.get(metal);
    }

    @Override
    public ItemStack getBoots(String metal) {
        return this.bootsStacks.get(metal);
    }

    @Override
    public ItemStack getBrick(String metal) {
        return this.brickStacks.get(metal);
    }

    @Override
    public ItemStack getChestplate(String metal) {
        return this.chestplateStacks.get(metal);
    }

    @Override
    public Block getDefaultOre() {
        return this.defaultOre;
    }

    @Override
    public Block getDefaultBlock() {
        return this.defaultBlock;
    }

    @Override
    public Block getDefaultBricks() {
        return this.defaultBricks;
    }

    @Override
    public ItemStack getDrop(String metal) {
        return this.dropStacks.get(metal);
    }

    @Override
    public ItemStack getDust(String metal) {
        return this.dustStacks.get(metal);
    }

    @Override
    public ItemStack getHelmet(String metal) {
        return this.helmetStacks.get(metal);
    }

    @Override
    public ItemStack getHoe(String metal) {
        return this.hoeStacks.get(metal);
    }

    @Override
    public ItemStack getIngot(String metal) {
        return this.ingotStacks.get(metal);
    }

    @Override
    public ItemStack getLeggings(String metal) {
        return this.leggingsStacks.get(metal);
    }

    @Override
    public IMetalInfo getMetal(String metal) {
        Metal metalInfo = null;
        for (int i = 0; i < this.metals.length; ++i) {
            if (this.metals[i].getType() == MetalType.Default || !metal.equalsIgnoreCase(this.metals[i].getName())) continue;
            metalInfo = this.metals[i];
            break;
        }
        return metalInfo;
    }

    @Override
    public String[] getMetalNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.metals.length; ++i) {
            if (this.metals[i].getType() == MetalType.Default) continue;
            names.add(this.metals[i].getName());
        }
        String[] outputNames = new String[names.size()];
        outputNames = names.toArray(outputNames);
        return outputNames;
    }

    @Override
    public ItemStack getOre(String metal) {
        return this.oreStacks.get(metal);
    }

    @Override
    public ItemStack getPickaxe(String metal) {
        return this.pickaxeStacks.get(metal);
    }

    @Override
    public ItemStack getShovel(String metal) {
        return this.shovelStacks.get(metal);
    }

    @Override
    public ItemStack getSword(String metal) {
        return this.swordStacks.get(metal);
    }

    private void initDefaults() {
        String postfix = this.name.toLowerCase();
        postfix = postfix.replace(" ", ".");
        this.defaultOre = new MetalBlock(postfix + ".ore");
        this.defaultBlock = new MetalBlock(postfix + ".block");
        this.defaultBricks = new MetalBlock(postfix + ".brick");
        this.defaultDust = new MetalItem(postfix + ".dust");
        this.defaultDrops = new MetalItem(postfix + ".item");
    }

    public void load(InputStream inputStream) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (IOException e) {
            LogHandler.log((String)e.getLocalizedMessage());
        }
        for (Metal metal : this.metals = (Metal[])new Gson().fromJson((Reader)reader, Metal[].class)) {
            String ingotOreDicName;
            int[] stats;
            String identifier;
            if (metal.type == MetalType.Default) continue;
            MetalBlock ore = null;
            MetalBlock block = null;
            MetalBlock brick = null;
            MetalItem dust = null;
            MetalItem ingot = null;
            MetalItem item = null;
            String texture = metal.getName().replace(" ", "_");
            texture = "Metallurgy:" + this.name + "/" + texture.toLowerCase();
            String tag = metal.getName().replace(" ", "");
            String configTag = tag.substring(0, 1).toUpperCase() + tag.substring(1);
            int metaId = metal.meta;
            String metalTag = metal.getName().trim().toLowerCase().replace(" ", "_");
            int blockLvl = ConfigHandler.blockHarvestLevel(metalTag, metal.blockLvl);
            if (metal.type != MetalType.Drop) {
                identifier = "dust";
                String[] oreDicAliases = this.createOreDicAliases(identifier, metal.getAliases());
                dust = this.createItem(this.defaultDust, metaId, tag, identifier, true, oreDicAliases);
                dust.addSubItem(metaId, metal.getName(), 0, texture + "_" + identifier);
                this.dustStacks.put(metal.getName(), new ItemStack((Item)dust, 1, metaId));
            }
            if (metal.type != MetalType.Drop) {
                identifier = "ingot";
                ingot = new MetalItem(configTag + "." + identifier);
                ingot.addSubItem(0, metal.getName(), 1, texture + "_" + identifier);
                OreDictionary.registerOre((String)(identifier + tag), (ItemStack)new ItemStack((Item)ingot, 1, 0));
                String registryName = metal.getName().toLowerCase();
                registryName = registryName.replace(" ", ".");
                registryName = registryName + "." + identifier;
                GameRegistry.registerItem((Item)ingot, (String)registryName);
                this.ingotStacks.put(metal.getName(), new ItemStack((Item)ingot));
            }
            if (metal.type == MetalType.Drop) {
                identifier = "item";
                boolean defaultOreDic = true;
                String[] customOreDic = metal.getDropOreDicNames();
                String[] oreDicAliases = this.createOreDicAliases(identifier, metal.getAliases());
                ArrayList<String> oreDicList = new ArrayList<String>();
                if (customOreDic != null && customOreDic.length > 0) {
                    oreDicList.addAll(Arrays.asList(customOreDic));
                    defaultOreDic = false;
                }
                if (oreDicAliases != null && oreDicAliases.length > 0) {
                    oreDicList.addAll(Arrays.asList(oreDicAliases));
                }
                String[] oreDic = null;
                if (oreDicList.size() > 0) {
                    oreDic = new String[oreDicList.size()];
                    oreDic = oreDicList.toArray(oreDic);
                }
                item = this.createItem(this.defaultDrops, metaId, tag, identifier, defaultOreDic, oreDic);
                String itemName = metal.dropName;
                String itemTexture = metal.dropName.replace(" ", "_");
                itemTexture = "Metallurgy:" + this.name + "/" + itemTexture.toLowerCase();
                if (itemName.compareTo("") == 0) {
                    itemName = metal.getName();
                    itemTexture = texture;
                }
                item.addSubItem(metaId, itemName, 2, itemTexture);
                this.dropStacks.put(metal.getName(), new ItemStack((Item)item, 1, metaId));
            }
            if (metal.type != MetalType.Alloy) {
                identifier = "ore";
                if (metal.type != MetalType.Respawn) {
                    String[] oreDicAliases = this.createOreDicAliases(identifier, metal.getAliases());
                    ore = this.createBlock(this.defaultOre, metaId, blockLvl, tag, identifier, true, oreDicAliases);
                    item = this.defaultDrops;
                    if (metal.type == MetalType.Drop) {
                        ore.addSubBlock(metaId, metal.getName(), 0, texture + "_" + identifier, item);
                    } else {
                        ore.addSubBlock(metaId, metal.getName(), 0, texture + "_" + identifier);
                    }
                    if (metal.haveParticles()) {
                        int type = metal.getParticleType();
                        int[] colors = metal.getParticleColors();
                        ore.setSubBlockParticles(metaId, type, colors[0], colors[1], colors[2]);
                    }
                    this.oreStacks.put(metal.getName(), new ItemStack((Block)ore, 1, metaId));
                }
                if (ConfigHandler.generates(tag)) {
                    String dims = ConfigHandler.getOreGenerationDimInfo(configTag, metal.dimensions);
                    int[] genInfo = ConfigHandler.getOreGenerationInformation(configTag, metal.generation);
                    WorldGenMetals worldGen = new WorldGenMetals(ore, metaId, genInfo, dims);
                    GameRegistry.registerWorldGenerator((IWorldGenerator)worldGen, (int)5);
                }
            }
            if (metal.type != MetalType.Respawn) {
                identifier = "block";
                String[] oreDicAliases = this.createOreDicAliases(identifier, metal.getAliases());
                block = this.createBlock(this.defaultBlock, metaId, blockLvl, tag, identifier, true, oreDicAliases);
                block.addSubBlock(metaId, metal.getName(), 1, texture + "_" + identifier);
                this.blockStacks.put(metal.getName(), new ItemStack((Block)block, 1, metaId));
                ItemStack recipeElement = metal.type == MetalType.Drop ? new ItemStack((Item)item, 1, metaId) : new ItemStack((Item)ingot);
                ItemStack returnedItems = recipeElement.func_77946_l();
                returnedItems.field_77994_a = 9;
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)block, 1, metaId), (Object[])new Object[]{"iii", "iii", "iii", Character.valueOf('i'), recipeElement});
                GameRegistry.addShapelessRecipe((ItemStack)returnedItems, (Object[])new Object[]{new ItemStack((Block)block, 1, metaId)});
            }
            if (metal.type != MetalType.Drop && metal.type != MetalType.Respawn) {
                identifier = "brick";
                String[] oreDicAliases = this.createOreDicAliases(identifier, metal.getAliases());
                brick = this.createBlock(this.defaultBricks, metaId, blockLvl, tag, identifier, true, oreDicAliases);
                brick.addSubBlock(metaId, metal.getName(), 2, texture + "_" + identifier);
                this.brickStacks.put(metal.getName(), new ItemStack((Block)brick, 1, metaId));
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)brick, 1, metaId), (Object[])new Object[]{"ii", "ii", Character.valueOf('i'), ingot});
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ingot, 4), (Object[])new Object[]{new ItemStack((Block)brick, 1, metaId)});
                String fluidName = metal.getName().trim().replace(" ", ".").toLowerCase() + ".molten";
                Fluid fluid = new Fluid(fluidName).setLuminosity(15).setDensity(3000).setViscosity(6000).setTemperature(1300);
                boolean registered = FluidRegistry.registerFluid((Fluid)fluid);
                String registryName = metal.getName().toLowerCase();
                registryName = registryName.trim().replace(" ", ".") + ".molten";
                String unlocalizedName = "Metallurgy".toLowerCase() + "." + registryName;
                String moltenTexture = "Metallurgy".toLowerCase() + ":";
                moltenTexture = moltenTexture + this.name.replace(" ", "_").toLowerCase() + "/";
                moltenTexture = moltenTexture + metal.getName().trim().replace(" ", "_").toLowerCase();
                MoltenMetalBlock moltenMetal = new MoltenMetalBlock(fluid, unlocalizedName, moltenTexture);
                GameRegistry.registerBlock((Block)moltenMetal, (String)registryName);
                if (!registered) {
                    Fluid registeredFluid = FluidRegistry.getFluid((String)fluidName);
                    Block registeredFluidBlock = registeredFluid.getBlock();
                    if (registeredFluidBlock == null) {
                        fluid.setBlock((Block)moltenMetal);
                    } else {
                        moltenMetal.disableWritingFluidIcons();
                    }
                }
            }
            if (metal.alloyRecipe != null && metal.alloyRecipe.length == 2) {
                String ore1 = metal.alloyRecipe[0];
                String ore2 = metal.alloyRecipe[1];
                ore1 = ore1.replace(" ", "");
                ore2 = ore2.replace(" ", "");
                ore1 = "dust" + ore1;
                ore2 = "dust" + ore2;
                Utils.alloys.put(tag, new String[]{ore1, ore2});
                Utils.requireAlloyer.put(tag, metal.isAlloyerRequired());
            }
            if (ingot != null && metal.haveTools()) {
                boolean enableEffect;
                String statsName = metal.getName().toUpperCase();
                statsName = statsName.replace(" ", "_");
                boolean weaponEnabled = ConfigHandler.weaponsEnabled(statsName.toLowerCase());
                int harvestLevel = metal.getToolHarvestLevel();
                int maxUses = metal.getToolDurability();
                int efficiency = metal.getToolEfficiency();
                int damage = metal.getToolDamage();
                int enchantability = metal.getToolEncantabilty();
                stats = new int[]{harvestLevel, maxUses, efficiency, damage, enchantability};
                stats = ConfigHandler.toolsStats(statsName.toLowerCase(), stats);
                harvestLevel = stats[0];
                maxUses = stats[1];
                efficiency = stats[2];
                damage = stats[3];
                enchantability = stats[4];
                Item.ToolMaterial toolMaterial = EnumHelper.addToolMaterial((String)statsName, (int)harvestLevel, (int)maxUses, (float)efficiency, (float)damage, (int)enchantability);
                toolMaterial.customCraftingMaterial = ingot;
                ingotOreDicName = "ingot" + tag;
                String toolUName = metal.getName().toLowerCase();
                toolUName = toolUName.replace(" ", ".");
                String axeTexture = texture + "_" + "axe";
                String axeUName = toolUName + ".axe";
                Axe axe = new Axe(toolMaterial, axeUName, axeTexture);
                axe.setHarvestLevel("axe", harvestLevel);
                GameRegistry.registerItem((Item)axe, (String)axeUName);
                if (weaponEnabled) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)axe), new Object[]{"ii ", "is ", " s ", Character.valueOf('i'), ingotOreDicName, Character.valueOf('s'), "stickWood"}));
                }
                this.axeStacks.put(metal.getName(), new ItemStack((Item)axe));
                String hoeTexture = texture + "_" + "hoe";
                String hoeUName = toolUName + ".hoe";
                Hoe hoe = new Hoe(toolMaterial, hoeUName, hoeTexture);
                hoe.setHarvestLevel("hoe", harvestLevel);
                GameRegistry.registerItem((Item)hoe, (String)hoeUName);
                if (weaponEnabled) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)hoe), new Object[]{"ii ", " s ", " s ", Character.valueOf('i'), ingotOreDicName, Character.valueOf('s'), "stickWood"}));
                }
                this.hoeStacks.put(metal.getName(), new ItemStack((Item)hoe));
                String pickaxeTexture = texture + "_" + "pick";
                String pickaxeUName = toolUName + ".pickaxe";
                Pickaxe pickaxe = new Pickaxe(toolMaterial, pickaxeUName, pickaxeTexture);
                pickaxe.setHarvestLevel("pickaxe", harvestLevel);
                GameRegistry.registerItem((Item)pickaxe, (String)pickaxeUName);
                if (weaponEnabled) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)pickaxe), new Object[]{"iii", " s ", " s ", Character.valueOf('i'), ingotOreDicName, Character.valueOf('s'), "stickWood"}));
                }
                this.pickaxeStacks.put(metal.getName(), new ItemStack((Item)pickaxe));
                String shovelTexture = texture + "_" + "shovel";
                String shovelUName = toolUName + ".shovel";
                Shovel shovel = new Shovel(toolMaterial, shovelUName, shovelTexture);
                shovel.setHarvestLevel("shovel", harvestLevel);
                GameRegistry.registerItem((Item)shovel, (String)shovelUName);
                if (weaponEnabled) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)shovel), new Object[]{"i", "s", "s", Character.valueOf('i'), ingotOreDicName, Character.valueOf('s'), "stickWood"}));
                }
                this.shovelStacks.put(metal.getName(), new ItemStack((Item)shovel));
                String swordTexture = texture + "_" + "sword";
                String swordUName = toolUName + ".sword";
                Sword sword = new Sword(toolMaterial, swordUName, swordTexture);
                if (metal.haveEntityEffects() && (enableEffect = ConfigHandler.swordEffectEnabled(statsName.toLowerCase()))) {
                    int effectId = metal.getEffectId();
                    int effectDura = metal.getEffectDuration();
                    int effectAmp = metal.getEffectAmplifier();
                    int effectRec = metal.getEffectReceiver();
                    sword.addEffect(effectId, effectDura, effectAmp, effectRec);
                }
                GameRegistry.registerItem((Item)sword, (String)swordUName);
                if (weaponEnabled) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)sword), new Object[]{"i", "i", "s", Character.valueOf('i'), ingotOreDicName, Character.valueOf('s'), "stickWood"}));
                }
                this.swordStacks.put(metal.getName(), new ItemStack((Item)sword));
            }
            if (ingot != null && metal.haveArmor()) {
                String modelTexture = metal.getName().replace(" ", "_").toLowerCase();
                modelTexture = this.name.toLowerCase() + "/" + modelTexture;
                String armorUName = metal.getName().toLowerCase();
                armorUName = armorUName.replace(" ", ".");
                armorUName = "Metallurgy".toLowerCase() + "." + armorUName;
                String armorConfName = metal.getName().toLowerCase().replace(" ", "_");
                boolean armorEnabled = ConfigHandler.armorEnabled(armorConfName);
                int mutiplier = metal.getArmorMultiplier();
                int[] damageReduction = metal.getArmorDamageReduction();
                int enchantablilty = metal.getArmorEnchantability();
                stats = new int[]{mutiplier, damageReduction[0], damageReduction[1], damageReduction[2], damageReduction[3], enchantablilty};
                stats = ConfigHandler.armourStats(armorConfName, stats);
                mutiplier = stats[0];
                damageReduction = new int[]{stats[1], stats[2], stats[3], stats[4]};
                enchantablilty = stats[5];
                ItemArmor.ArmorMaterial armorMaterial = EnumHelper.addArmorMaterial((String)armorUName, (int)mutiplier, (int[])damageReduction, (int)enchantablilty);
                armorMaterial.customCraftingMaterial = ingot;
                ingotOreDicName = "ingot" + tag;
                int renderIndex = 3;
                String helmetIconTexture = texture + "_helmet";
                String helmetUName = armorUName + ".helmet";
                ItemMetallurgyArmor helmet = new ItemMetallurgyArmor(armorMaterial, renderIndex, 0, modelTexture);
                helmet = (ItemMetallurgyArmor)helmet.func_77655_b(helmetUName);
                helmet = (ItemMetallurgyArmor)helmet.func_111206_d(helmetIconTexture);
                GameRegistry.registerItem((Item)helmet, (String)helmetUName);
                if (armorEnabled) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)helmet), new Object[]{"iii", "i i", Character.valueOf('i'), ingotOreDicName}));
                }
                this.helmetStacks.put(metal.getName(), new ItemStack((Item)helmet));
                String chestplateIconTexture = texture + "_chest";
                String chestplateUName = armorUName + ".chestplate";
                ItemMetallurgyArmor chestplate = new ItemMetallurgyArmor(armorMaterial, renderIndex, 1, modelTexture);
                chestplate = (ItemMetallurgyArmor)chestplate.func_77655_b(chestplateUName);
                chestplate = (ItemMetallurgyArmor)chestplate.func_111206_d(chestplateIconTexture);
                GameRegistry.registerItem((Item)chestplate, (String)chestplateUName);
                if (armorEnabled) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)chestplate), new Object[]{"i i", "iii", "iii", Character.valueOf('i'), ingotOreDicName}));
                }
                this.chestplateStacks.put(metal.getName(), new ItemStack((Item)chestplate));
                String leggingsIconTexture = texture + "_legs";
                String leggingsUName = armorUName + ".leggings";
                ItemMetallurgyArmor leggings = new ItemMetallurgyArmor(armorMaterial, renderIndex, 2, modelTexture);
                leggings = (ItemMetallurgyArmor)leggings.func_77655_b(leggingsUName);
                leggings = (ItemMetallurgyArmor)leggings.func_111206_d(leggingsIconTexture);
                GameRegistry.registerItem((Item)leggings, (String)leggingsUName);
                if (armorEnabled) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)leggings), new Object[]{"iii", "i i", "i i", Character.valueOf('i'), ingotOreDicName}));
                }
                this.leggingsStacks.put(metal.getName(), new ItemStack((Item)leggings));
                String bootsIconTexture = texture + "_boots";
                String bootsUName = armorUName + ".boots";
                ItemMetallurgyArmor boots = new ItemMetallurgyArmor(armorMaterial, renderIndex, 3, modelTexture);
                boots = (ItemMetallurgyArmor)boots.func_77655_b(bootsUName);
                boots = (ItemMetallurgyArmor)boots.func_111206_d(bootsIconTexture);
                GameRegistry.registerItem((Item)boots, (String)bootsUName);
                if (armorEnabled) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)boots), new Object[]{"i i", "i i", Character.valueOf('i'), ingotOreDicName}));
                }
                this.bootsStacks.put(metal.getName(), new ItemStack((Item)boots));
            }
            boolean shearsEnabled = ConfigHandler.recipeEnabled("shears");
            boolean bucketsEnabled = ConfigHandler.recipeEnabled("buckets");
            if (ingot != null) {
                String ingotOreDicName2 = "ingot" + tag;
                if (shearsEnabled) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)Items.field_151097_aZ), new Object[]{" i", "i ", Character.valueOf('i'), ingotOreDicName2}));
                }
                if (bucketsEnabled) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151133_ar), new Object[]{"i i", " i ", Character.valueOf('i'), ingotOreDicName2}));
                }
            }
            if (ingot == null) continue;
            GameRegistry.addSmelting((ItemStack)new ItemStack((Item)dust, 1, metaId), (ItemStack)new ItemStack((Item)ingot), (float)0.7f);
            if (ore == null) continue;
            GameRegistry.addSmelting((ItemStack)new ItemStack((Block)ore, 1, metaId), (ItemStack)new ItemStack((Item)ingot), (float)0.7f);
        }
    }
}

