/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy.metals;

import com.teammetallurgy.metallurgy.api.IMetalInfo;
import com.teammetallurgy.metallurgy.api.MetalType;

public class Metal
implements IMetalInfo {
    private String name;
    private String[] nameAliases;
    public MetalType type;
    public int meta;
    public int abstractorXp;
    public int blockLvl;
    public String[] alloyRecipe;
    public boolean requireAlloyer;
    public String dropName;
    public String[] dropOreDicNames;
    public int[] dropRate;
    public int[] equipment;
    public int[] entityEffect;
    public int[] particleEffect;
    public int[] dugeonLoot;
    public int[] generation;
    public String dimensions;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MetalType getType() {
        return this.type;
    }

    @Override
    public int getBlockLevel() {
        return this.blockLvl;
    }

    @Override
    public int getToolDamage() {
        if (this.haveTools()) {
            return this.equipment[2];
        }
        return -1;
    }

    @Override
    public int getToolDurability() {
        if (this.haveTools()) {
            return this.equipment[1];
        }
        return -1;
    }

    @Override
    public int getToolEfficiency() {
        if (this.haveTools()) {
            return this.equipment[3];
        }
        return -1;
    }

    @Override
    public int getToolEncantabilty() {
        if (this.haveTools()) {
            return this.equipment[4];
        }
        return -1;
    }

    @Override
    public int getToolHarvestLevel() {
        if (this.haveTools()) {
            return this.equipment[0];
        }
        return -1;
    }

    @Override
    public boolean haveTools() {
        return this.equipment != null && this.equipment.length >= 5;
    }

    @Override
    public boolean haveArmor() {
        return this.equipment != null && this.equipment.length >= 10;
    }

    @Override
    public int getArmorMultiplier() {
        if (this.haveArmor()) {
            return this.equipment[9];
        }
        return -1;
    }

    @Override
    public int[] getArmorDamageReduction() {
        if (this.haveArmor()) {
            int[] damageReduction = new int[]{this.equipment[5], this.equipment[6], this.equipment[7], this.equipment[8]};
            return damageReduction;
        }
        return null;
    }

    @Override
    public int getArmorEnchantability() {
        if (this.haveArmor()) {
            return this.equipment[4];
        }
        return -1;
    }

    public boolean haveEntityEffects() {
        return this.entityEffect != null && this.entityEffect.length == 4;
    }

    public int getEffectId() {
        if (this.haveEntityEffects()) {
            return this.entityEffect[0];
        }
        return -1;
    }

    public int getEffectDuration() {
        if (this.haveEntityEffects()) {
            return this.entityEffect[1];
        }
        return -1;
    }

    public int getEffectAmplifier() {
        if (this.haveEntityEffects()) {
            return this.entityEffect[2];
        }
        return -1;
    }

    public int getEffectReceiver() {
        if (this.haveEntityEffects()) {
            return this.entityEffect[3];
        }
        return -1;
    }

    public boolean haveParticles() {
        return this.particleEffect != null && this.particleEffect.length >= 4;
    }

    public int getParticleType() {
        if (this.haveParticles()) {
            return this.particleEffect[0];
        }
        return -1;
    }

    public int[] getParticleColors() {
        if (this.haveParticles()) {
            int[] colors = new int[]{this.particleEffect[1], this.particleEffect[2], this.particleEffect[3]};
            return colors;
        }
        return null;
    }

    @Override
    public boolean isAlloyerRequired() {
        return this.requireAlloyer;
    }

    @Override
    public String[] getAliases() {
        return this.nameAliases;
    }

    @Override
    public String[] getDropOreDicNames() {
        return this.dropOreDicNames;
    }

    @Override
    public int[] getGeneration() {
        return this.generation;
    }

    @Override
    public String getDimentions() {
        return this.dimensions;
    }
}

