/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.plugins;

import cofh.core.CoFHProps;
import cofh.thermalfoundation.ThermalFoundation;
import java.util.ArrayList;

public class TFPlugins {
    public static ArrayList<Plugin> pluginList = new ArrayList();

    public static void preInit() {
        ThermalFoundation.log.info("Loading Plugins...");
        for (int i = 0; i < pluginList.size(); ++i) {
            pluginList.get(i).preInit();
        }
        ThermalFoundation.log.info("Finished Loading Plugins.");
    }

    public static void initialize() {
        for (int i = 0; i < pluginList.size(); ++i) {
            pluginList.get(i).initialize();
        }
    }

    public static void postInit() {
        for (int i = 0; i < pluginList.size(); ++i) {
            pluginList.get(i).postInit();
        }
    }

    public static void loadComplete() {
        for (int i = 0; i < pluginList.size(); ++i) {
            pluginList.get(i).loadComplete();
        }
    }

    public static void cleanUp() {
        pluginList.clear();
    }

    public static boolean addPlugin(String string, String string2) {
        boolean bl = ThermalFoundation.config.get("Plugins." + string2, "Enable", true);
        ThermalFoundation.config.save();
        if (bl) {
            pluginList.add(new Plugin(string));
            return true;
        }
        return false;
    }

    static {
        TFPlugins.addPlugin("mfr.MFRPlugin", "MineFactoryReloaded");
        TFPlugins.addPlugin("thaumcraft.ThaumcraftPlugin", "Thaumcraft");
        TFPlugins.addPlugin("tconstruct.TConstructPlugin", "TConstruct");
    }

    static class Plugin {
        public Class<?> pluginClass = null;
        public String pluginPath;

        public Plugin(String string) {
            this.pluginPath = "cofh.thermalfoundation.plugins." + string;
        }

        public void preInit() {
            block2: {
                try {
                    this.pluginClass = TFPlugins.class.getClassLoader().loadClass(this.pluginPath);
                    this.pluginClass.getMethod("preInit", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (!CoFHProps.enableDebugOutput) break block2;
                    throwable.printStackTrace();
                }
            }
        }

        public void initialize() {
            block3: {
                try {
                    if (this.pluginClass != null) {
                        this.pluginClass.getMethod("initialize", new Class[0]).invoke(null, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (!CoFHProps.enableDebugOutput) break block3;
                    throwable.printStackTrace();
                }
            }
        }

        public void postInit() {
            block3: {
                try {
                    if (this.pluginClass != null) {
                        this.pluginClass.getMethod("postInit", new Class[0]).invoke(null, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (!CoFHProps.enableDebugOutput) break block3;
                    throwable.printStackTrace();
                }
            }
        }

        public void loadComplete() {
            block3: {
                try {
                    if (this.pluginClass != null) {
                        this.pluginClass.getMethod("loadComplete", new Class[0]).invoke(null, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (!CoFHProps.enableDebugOutput) break block3;
                    throwable.printStackTrace();
                }
            }
        }

        public void registerRenderInformation() {
            block3: {
                try {
                    if (this.pluginClass != null) {
                        this.pluginClass.getMethod("registerRenderInformation", new Class[0]).invoke(null, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (!CoFHProps.enableDebugOutput) break block3;
                    throwable.printStackTrace();
                }
            }
        }
    }
}

